#ifndef _MAIN_H_
#define _MAIN_H_

/**
 * @mainpage Electrowetting on dielectric (EWOD)
 *
 * This is the documentation of the %EWOD code submitted to Archive on Numerical Software.
 * 
 * The purpose of this code is to simulate electrowetting on dielectric, which consists in the
 * local modification of the surface tension betweent two immiscible fluids via electric
 * actuation. This phenomenon has several practical applications, therefore it is important to
 * possess simulation tools that are simple yet accurate. The following figure shows
 * a prototype of an electrowetting device:
 *
 * @image html ewod_scheme.png "Schematics of an electrowetting device" width=75
 *
 * The solid black stripes represent two conducting plates, which entrap a two-phase immiscible
 * fluid. %Voltage is applied to the plates and this generates an electric field between them.
 * The generated electric field changes the properties of the fluids, and thus they can be
 * manipulated.
 *
 * Unlike many of the problems usually tackled by scientific computing, the governing
 * laws for this phenomenon are still open for debate. Very little is known about what happens
 * at the interface between the two fluids and the solid container. The purpose of this code
 * is to explore the possiblities of a model of electrowetting, which consists of a %Cahn Hilliard
 * Navier Stokes system of equations, coupled with a convection diffusion equation that models
 * the transport of charges and a Poisson equation to model the voltage. The fluid and charge
 * equations are posed in the fluid domain, whereas the voltage equation in the fluid and plates.
 *
 * Due to the intricate coupling of the equations, as well as its high number, the structuring of 
 * the code becomes of importance. The main contributions of this work are the AsFunction and
 * Problem class templates. AsFunction is our attempt at encapsulating the information relevant to
 * a problem and allowing it to interface with another system, where it can serve as input.
 * Problem, as its name indicates, is the way we abstract the common features of a problem.
 *
 * In addition, we have "application specific" classes: DataStorage, GLPotential, InterfaceEnergy,
 * material_function, Material_Parameters, Phase0 and Vbc. These are nothing but classes
 * that represent specific objects in our system of equations: Coefficients, initial and/or
 * boundary conditions, etc.
 *
 * Finally, the classes that represent each one of the physical processes are: CahnHilliard,
 * Charge, Pressure, Voltage and Velocity. The class CHNSE refers to a fixed point iteration scheme
 * used to solve the fluid problem. The main class, i.e. the one that dirvies all these
 * processes and keeps them in sync is EWOD.
 *
 * @author Abner J. Salgado.
 * @date 2011-2012
 *
 * @warning This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#endif 