#include <deal.II/base/logstream.h>
#include <deal.II/base/utilities.h>

#include "../include/EWOD.h"
#include "../include/FileReader.h"

#include <iostream>

using namespace dealii;

int main( int argc, char **argv ){
  try{
    Utilities::System::MPI_InitFinalize mpi_initialization( argc, argv );
    DataStorage<DIM> data;
    if( argc < 2 ){
      std::cerr<<std::endl<< std::endl<<" Missing parameter file!!"<<std::endl
               <<" Aborting :'("<<std::endl<<std::endl;
      data.print_usage();
      return 1;
    }
    data.read_data( argv[1] );
    deallog.depth_console( data.verbose ? 2 : 0 );
    deallog.attach( std::cout );
    std::cout<<" Creating problem . . ."<<std::endl;
    EWOD<DIM> test( data );
    std::cout<<" Problem created!"<<std::endl;
    test.run();
  }catch( std::exception &exc ){
    std::cerr<<std::endl<<std::endl<<"----------------------------------------------------"
             <<std::endl<<"Exception on processing:"<<std::endl<<exc.what()<<std::endl
             <<"Aborting! :'("<<std::endl<<"----------------------------------------------------"<< std::endl;
    return 1;
  }catch( ... ){
    std::cerr<<std::endl<<std::endl
             <<"----------------------------------------------------"<<std::endl
             <<"Unknown exception!"<<std::endl<<"Aborting!"<<std::endl
             <<"----------------------------------------------------"<<std::endl;
    return 1;
  }
  std::cout<<"----------------------------------------------------"<<std::endl
           <<"Apparently everything went fine!"<<std::endl;
  return 0;
}
