#ifndef XFE_VALUES
#define XFE_VALUES

#include <deal.II/fe/fe_values.h>
#include <deal.II/dofs/dof_handler.h>


#include "level_set.h"
#include "xfem_functions.h"

using namespace dealii;

//The XFEValues class is a derived class of the FEValues that provides the additional shape functions needed for the XFEM. The XFEValues class will be defined twice, once for strong discontinuity and once for weak discontinuity. The only difference are the additional shape functions.
template <int dim, int spacedim=dim>
class XFEValues_strong : public FEValues<dim,spacedim>
{
protected:
  Level_Set<dim>            ls;
  Xfem<dim>                 xfem;

  Table<2,double>           _shape_values;
  Table<2,Tensor<1,dim> >   _shape_gradients;

  const unsigned int        _dofs_per_cell;
  const unsigned int        _n_q_points;

  UpdateFlags               _update_flags;

public:

  XFEValues_strong(const FiniteElement<dim, spacedim> &fe,
                   Quadrature<dim> quadrature,
                   UpdateFlags update_flags);
  void reinit(const typename hp::DoFHandler<dim,spacedim>::cell_iterator &cell);
  double shape_value(const unsigned int function_no,
                     const unsigned int point_no);
  Tensor<1,dim> shape_grad(const unsigned int function_no,
                           const unsigned int point_no);
  void get_function_values(const Vector<double> fe_function,
                           std::vector<Vector<double> > &values);
  void get_function_gradients(const Vector<double> fe_function,
                              std::vector<Vector<Tensor<1,dim> > > &values);
};

template <int dim, int spacedim=dim>
class XFEValues_weak : public FEValues<dim,spacedim>
{
protected:
  Level_Set<dim>            ls;
  Xfem<dim>                 xfem;

  Table<2,double>           _shape_values;
  Table<2,Tensor<1,dim> >   _shape_gradients;

  const unsigned int        _dofs_per_cell;
  const unsigned int        _n_q_points;

  UpdateFlags               _update_flags;

public:

  XFEValues_weak(const FiniteElement<dim, spacedim> &fe,
                 Quadrature<dim> quadrature,
                 UpdateFlags update_flags);
  void reinit(const typename hp::DoFHandler<dim,spacedim>::cell_iterator &cell);
  double shape_value(const unsigned int function_no,
                     const unsigned int point_no);
  Tensor<1,dim> shape_grad(const unsigned int function_no,
                           const unsigned int point_no);
  void get_function_values(const Vector<double> fe_function,
                           std::vector<Vector<double> > &values);
  void get_function_gradients(const Vector<double> fe_function,
                              std::vector<Vector<Tensor<1,dim> > > &values);

};

#endif
