#ifndef XFEM
#define XFEM

template <int dim>
class Xfem
{
private:

  double n0;
  double n1;
  double n2;
  double c;
  std::vector<dealii::Point<dim> > intersection_points;
  Level_Set<dim>  ls;

public:

  double sign(const double x);

  std::vector<typename dealii::hp::DoFHandler<dim>::active_cell_iterator> find_all_neighbors(const typename dealii::hp::DoFHandler<dim>::active_cell_iterator &cell);

  bool vertex_has_intersected_neighbor(const typename dealii::hp::DoFHandler<dim>::active_cell_iterator &cell,unsigned int vertex_index);

  bool interface_intersects_cell(const typename dealii::Triangulation<dim>::cell_iterator &cell) const;

  std::vector<unsigned int> indices_of_ramp(const typename dealii::hp::DoFHandler<dim>::active_cell_iterator &cell);

  dealii::Quadrature<dim> compute_quadrature (const dealii::Quadrature<dim> &plain_quadrature,
                                              const typename dealii::hp::DoFHandler<dim>::active_cell_iterator &cell);

  std::vector<std::vector<dealii::Point<dim> > > calculate_subcells
  (const typename dealii::hp::DoFHandler<dim>::active_cell_iterator &cell);

  void append_quadrature ( const dealii::Quadrature<dim> &plain_quadrature,
                           const std::vector<dealii::Point<dim> > &v,
                           std::vector<dealii::Point<dim> > &xfem_points,
                           std::vector<double>      &xfem_weights);

  void plot_vtk_strong ( dealii::hp::DoFHandler<dim> &dof_handler,
                         dealii::hp::FECollection<dim> &fe_collection,
                         dealii::Vector<double> &solution,
                         const unsigned int cycle);

  void plot_vtk_weak ( dealii::hp::DoFHandler<dim> &dof_handler,
                       dealii::hp::FECollection<dim> &fe_collection,
                       dealii::Vector<double> &solution,
                       const unsigned int cycle);

  void write_plot ( std::vector<dealii::Point<dim>> &mesh_,
                    std::vector<double> &solution_,
                    std::string filename);

  double level_set(const dealii::Point<dim> &p);

  std::vector<dealii::Point<dim> > get_intersection_points();
};

#endif
