#!/bin/bash

LOCREF=5
INITREF=3
OUTPUTSTEP=5

cd ../build-cmake/

OUTNAME=ucont1pcont1

cmake .. -DNSM_P_DISCONT:bool=false -DNSM_U_DISCONT:bool=false -DNSM_P_POLORDER:string=1 -DNSM_U_POLORDER:string=1 -DNSM_USE_IMAGE:bool=false
make
cd src
./nsm nsm.outputStep:${OUTPUTSTEP} nsm.initialRefinements:${INITREF} nsm.localRefine:${LOCREF} nsm.lambda_1:10 nsm.lambda_2:20 fem.io.path:../output/${OUTNAME}/ > ../../src/${OUTNAME}.log
cd ../../src/
python processOutput.py ${OUTPUTSTEP} ${OUTNAME}
if test ! -d ${OUTNAME}
  then
    mkdir ${OUTNAME}
fi
mv ${OUTNAME}.log ${OUTNAME}/
mv ${OUTNAME}.parameters ${OUTNAME}/
mv ${OUTNAME}.graph ${OUTNAME}/

cd ../build-cmake/

OUTNAME=ucont1pdiscont0
cmake .. -DNSM_P_DISCONT:bool=true -DNSM_U_DISCONT:bool=false -DNSM_P_POLORDER:string=0 -DNSM_U_POLORDER:string=1 -DNSM_USE_IMAGE:bool=false
make
cd src
./nsm nsm.outputStep:${OUTPUTSTEP} nsm.initialRefinements:${INITREF} nsm.localRefine:${LOCREF} nsm.lambda_1:10 nsm.lambda_2:20 fem.io.path:../output/${OUTNAME}/ > ../../src/${OUTNAME}.log
cd ../../src/
python processOutput.py ${OUTPUTSTEP} ${OUTNAME}
if test ! -d ${OUTNAME}
  then
    mkdir ${OUTNAME}
fi
mv ${OUTNAME}.log ${OUTNAME}/
mv ${OUTNAME}.parameters ${OUTNAME}/
mv ${OUTNAME}.graph ${OUTNAME}/


cd ../build-cmake/

OUTNAME=udiscont0pcont1

cmake .. -DNSM_P_DISCONT:bool=false -DNSM_U_DISCONT:bool=true -DNSM_P_POLORDER:string=1 -DNSM_U_POLORDER:string=0 -DNSM_USE_IMAGE:bool=false
make
cd src
./nsm nsm.outputStep:${OUTPUTSTEP} nsm.initialRefinements:${INITREF} nsm.localRefine:${LOCREF} nsm.lambda_1:10 nsm.lambda_2:20 fem.io.path:../output/${OUTNAME}/ > ../../src/${OUTNAME}.log
cd ../../src/
python processOutput.py ${OUTPUTSTEP} ${OUTNAME}
if test ! -d ${OUTNAME}
  then
    mkdir ${OUTNAME}
fi
mv ${OUTNAME}.log ${OUTNAME}/
mv ${OUTNAME}.parameters ${OUTNAME}/
mv ${OUTNAME}.graph ${OUTNAME}/
