#!/bin/bash

LOCREF=0
INITREF=8
OUTPUTSTEP=5
LAMBDA1=250
LAMBDA2=250

BASE=noisedImage
OUTNAME=${BASE}-${LAMBDA1}-${LAMBDA2}


cd ../build-cmake/

cmake .. -DNSM_P_DISCONT:bool=true -DNSM_U_DISCONT:bool=false -DNSM_P_POLORDER:string=0 -DNSM_U_POLORDER:string=1 -DNSM_USE_IMAGE:bool=true -DNSM_USE_NOISE:bool=true
make

cd src
./nsm nsm.tolerance:1e-4 nsm.noiseLevel1:-10 nsm.noiseType1:0 nsm.noiseLevel2:10 nsm.noiseType2:2 nsm.lambda_1:${LAMBDA1} nsm.lambda_2:${LAMBDA2} nsm.outputStep:${OUTPUTSTEP} nsm.initialRefinements:${INITREF} nsm.localRefine:${LOCREF} fem.io.path:../output/${OUTNAME}/ > ../../src/${OUTNAME}.log
cd ../../src/
python processOutput.py ${OUTPUTSTEP} ${OUTNAME}
if test ! -d ${OUTNAME}
  then
    mkdir ${OUTNAME}
fi
mv ${OUTNAME}.log ${OUTNAME}/
mv ${OUTNAME}.parameters ${OUTNAME}/
mv ${OUTNAME}.graph ${OUTNAME}/
