#!/bin/bash

LOCREF=3
INITREF=3
OUTPUTSTEP=5
LAMBDA1=150
LAMBDA2=150

BASE=parallelTest

cd ../build-cmake/

cmake .. -DNSM_P_DISCONT:bool=true -DNSM_U_DISCONT:bool=false -DNSM_P_POLORDER:string=0 -DNSM_U_POLORDER:string=1 -DNSM_USE_IMAGE:bool=false
make

for p in 1 2 4 8 16 32 ; do
  OUTNAME=${BASE}-${p}
  cd src/
  mpirun -n ${p} ./nsm fem.io.macroGridFile_2d:../data/finecube_2d.dgf nsm.constantL:0.125 nsm.tolerance:1e-4 nsm.lambda_1:${LAMBDA1} nsm.lambda_2:${LAMBDA2} nsm.outputStep:${OUTPUTSTEP} nsm.initialRefinements:${INITREF} nsm.localRefine:${LOCREF} fem.io.path:../output/${OUTNAME}/ > ../../src/${OUTNAME}.log 2>../../src/${OUTNAME}.time
  cd ../../src/
  python processOutput.py ${OUTPUTSTEP} ${OUTNAME}
  if test ! -d ${OUTNAME}
    then
      mkdir ${OUTNAME}
  fi
  mv ${OUTNAME}.log ${OUTNAME}/
  mv ${OUTNAME}.parameters ${OUTNAME}/
  mv ${OUTNAME}.graph ${OUTNAME}/

  echo ${p} >> ${BASE}.time
  grep RUNTIME *-${p}.time >> ${BASE}.time
  cd ../build-cmake/
done

cd ../src/
