#ifndef EXAMPLE_HH
#define EXAMPLE_HH

#include <cmath>
#include <vector>


/// Test function for Sacado and Adept. Both rely on special types and don't work well with auto.
template <class T>
T testFunctionWithFixedType(const T& x, const T& y, const T& z)
{
  return x*y*z;
}


template <class X, class Y, class Z>
auto testFunction(const X& x, const Y& y, const Z& z)
{
  return x*y*z;
}


struct TestFunction
{
  template <class T>
  auto operator()(const T& x, const T& y, const T& z) const
  {
    return testFunction(x,y,z);
  }

  template <class T>
  auto d1(const T& x, const T& y, const T& z, int id) const
  {
    if( id == 0 ) return y*z;
    if( id == 1 ) return x*z;
    /*if( id == 2 )*/
    return x*y;
  }
};


/// Interface for CppAD.
auto cppADFunction(double x)
{
  using CppAD::AD;

  auto nVars = 3;
  std::vector< AD<double> > X(nVars);
  X[0] = x;
  X[1] = x;
  X[2] = x;

  CppAD::Independent(X);

  std::vector< AD<double> > Y(1);
  Y[0] = testFunction(X[0],X[1],X[2]);

  return CppAD::ADFun<double>(X, Y);
}


/// Interface for FADBAD++, forward mode.
template <class Function>
struct FADBADForward
{
  template <class T>
  T operator()( T& o_dfdx, T& o_dfdy, T& o_dfdz, const T& i_x, const T& i_y, const T& i_z) const
  {
    using namespace fadbad;
    F<T,3> x(i_x), y(i_y), z(i_z);
    x.diff(0);
    y.diff(1);
    z.diff(2);
    Function func;
    F<T,3> f(func(x,y,z));
    o_dfdx = f.d(0);
    o_dfdy = f.d(1);
    o_dfdz = f.d(2);
    return f.x();
  }
};


std::string functionAsString()
{
  return "x*y*z";
}

#endif // EXAMPLE_HH
