#ifndef DUNE_FEM_GRIDPART_IDGRIDPART_ITERATOR_HH
#define DUNE_FEM_GRIDPART_IDGRIDPART_ITERATOR_HH

#include <type_traits>
#include <utility>

#include <dune/grid/common/entitypointer.hh>
#include <dune/grid/common/gridenums.hh>

namespace Dune
{

  namespace Fem
  {

    // IdIterator
    // ----------

    template< int codim, PartitionIteratorType pitype, class GridFamily >
    class IdIterator
    {
      typedef typename std::remove_const< GridFamily >::type::Traits Traits;

      typedef typename Traits::HostGridPartType HostGridPartType;

    public:
      typedef typename Traits::ExtraData ExtraData;
      typedef typename HostGridPartType::template Codim< codim >::template Partition< pitype >::IteratorType HostIteratorType;

      static const int codimension = HostIteratorType::codimension;

      typedef typename Traits::template Codim< codimension >::Entity Entity;

      IdIterator () = default;

      IdIterator ( ExtraData data, HostIteratorType hostIterator )
      : data_( std::move( data ) ),
        hostIterator_( std::move( hostIterator ) )
      {}

      void increment ()
      {
        ++hostIterator_;
      }

      Entity dereference () const
      {
        return typename Entity::Implementation( data_, *hostIterator_ );
      }

      bool equals ( const IdIterator &rhs ) const
      {
        return hostIterator_ == rhs.hostIterator_;
      }

      int level () const
      {
        return hostIterator_.level();
      }

      operator Dune::DefaultEntityPointer< Entity > () const
      {
        return Dune::DefaultEntityPointer< Entity >( dereference() );
      }
      
      bool equals ( const Dune::DefaultEntityPointer< Entity > &rhs ) const
      {
        return dereference() == rhs.dereference();
      }

    private:
      ExtraData data_;
      HostIteratorType hostIterator_;
    };

  } // namespace Fem

} // namespace Dune

#endif // #ifndef DUNE_FEM_GRIDPART_IDGRIDPART_ITERATOR_HH
