// original implementation done by Christian Engwer
#ifndef DUNE_ORTHONORMALBASE_1D_HH
#define DUNE_ORTHONORMALBASE_1D_HH

#include <stdlib.h>
#include <stdio.h>
#include <cassert>

namespace Dune
{
  namespace Fem
  {
    template <class DomainField, class RangeField>
    class OrthonormalBase_1D
    {
      typedef const DomainField* DomainType;
      typedef RangeField* JacobianRangeType;

    public:
      /****************************************************************************/
      /* functions                                                                */
      /****************************************************************************/
      /* \phi_i(x,y) for lines */
      static RangeField
      eval_line ( const int i, DomainType xi )
      {
        const RangeField &x = xi[0];

        switch (i)
          {
          case ( 0 ):
            return 1.;
          case ( 1 ):
            return 3.46410161513775458705489268300*x
              -1.73205080756887729352744634150;
          case ( 2 ):
            return x*( 13.4164078649987381784550420124*x
                 -13.4164078649987381784550420124)
              +2.23606797749978969640917366874;
          case ( 3 ):
            return x*(x*(52.9150262212918118100323150728*x
                  -79.3725393319377177150484726092)
             +31.7490157327750870860193890437)
                  -2.64575131106459059050161575364;
          case ( 4 ):
            return x*(x*(x*( 210.000000000000000000000000000*x
            -420.000000000000000000000000000)
            +270.000000000000000000000000000)
             -60.0000000000000000000000000000)
                   +3.00000000000000000000000000000;
          case ( 5 ):
            return x*(x*(x*(x*( 835.789447169560761976963049642*x
             -2089.47361792390190494240762410)
             +1857.30988259902391550436233253)
             -696.491205974633968314135874699)
             +99.498743710661995473447982101)
                   -3.31662479035539984911493273666;
          case ( 6 ):
            return x*(x*(x*(x*(x*( 3331.52937852872610684216045114*x
             -9994.58813558617832052648135341)
             +11357.4865177115662733255469926)
             -6057.32614277950201244029172934)
             +1514.33153569487550311007293234)
             -151.433153569487550311007293234)
                   +3.60555127546398929311922126752;

          case ( 7 ):
            return  x*(x*(x*(x*(x*(x*( 13292.0788441838547499352388521*x
              -46522.2759546434916247733359823)
                  +64415.4590141217576343015421294)
                    -44732.9576486956650238205153677)
                    +16266.5300540711509177529146793)
              -2927.97540973280716519552464227)
                    +216.88706738761534557003886240)
                    -3.87298334620741688517926540018;

          case ( 8 ):
            return  x*(x*(x*(x*(x*(x*(x* (53064.3694016992912762015448463*x
               -212257.477606797165104806179385)
               +346687.213424435369671183426329)
               -297160.468649516031146728651139)
               +142865.609927651938051311851510)
               -38097.4959807071834803498270695)
               +5195.11308827825229277497641852)
               -296.86360504447155958714150963)
                     +4.12310562561766054982140985569;
          case ( 9 ):
            return  x*(x*(x*(x*(x*(x*(x*(x*( 211929.666634947548109762064055*x
              -953683.499857263966493929288249)
              +1795168.94090779099575327866024)
              -1832568.29384336997483147196565)
              +1099540.97630602198489888317940)
              -392693.205823579280321029706926)
              +80552.4524766316472453394270618)
              -8630.61990821053363342922432814)
              +392.3009049186606197013283786)
                    -4.3588989435406735522369819839;

          case(10):
            return  x*(x*(x*(x*(x*(x*(x*(x*(x*(
                846658.355097261176257181247326*x
               -4233291.77548630588128590623663)
               +9023595.62669449411537258960966)
               -10694631.8538601411737749210189)
               +7706425.89469333702227898720481)
               -3467891.65261200166002554424214)
               +963303.236836667127784873400597)
               -157273.997850884429026101779690)
               +13610.249814018844819566500166)
               -504.0833264451424007246851913)
                     +4.58257569495584000658804719352	;
          }

        printf("Error eval_line: There is no shape function %d.\n",i);
        assert(false); abort();
        return 0.0;
      }

      /* \nabla\phi_i(x,y) for triangle */
      static void
      grad_line ( const int i, DomainType xi, JacobianRangeType grad )
      {
        const RangeField &x = xi[0];

        switch (i)	{
        case ( 0 ):
          grad[0]= 0;
          return;
        case ( 1 ):
          grad[0]= 3.46410161513775458705489268300;
          return;
        case ( 2 ):
          grad[0]=26.8328157299974763569100840248*x
                            -13.4164078649987381784550420124 ;
          return;
        case (3):
          grad[0]=x*( 158.745078663875435430096945218*x
               -158.745078663875435430096945218)
                             +31.7490157327750870860193890437;
          return;
        case (4):
          grad[0]=x*(x*(840.000000000000000000000000000*x
              -1260.00000000000000000000000000)
              +540.000000000000000000000000000)
                                -60.0000000000000000000000000000;
            return;

        case (5):
          grad[0]=x*(x*(x*(4178.94723584780380988481524820*x
              -8357.89447169560761976963049640)
              +5571.92964779707174651308699762)
              -1392.98241194926793662827174940)
                                 +99.4987437106619954734479821001;
          return;

        case (6):
          grad[0]=x*(x*(x*(x*(19989.1762711723566410529627068*x
                  -49972.9406779308916026324067670)
                  +45429.9460708462650933021879700)
                  -18171.9784283385060373208751880)
                  +3028.66307138975100622014586466)
                                     -151.433153569487550311007293233;
              return;
        case (7):
            grad[0]=x*(x*(x*(x*(x*( 93044.5519092869832495466719640*x
                      -279133.655727860949748640015893)
                        +322077.295070608788171507710646)
                            -178931.830594782660095282061470)
                            +48799.5901622134527532587440373)
                            -5855.95081946561433039104928446)
                         +216.887067387615345570038862388;
              return;

              case(8):
              grad[0]=x*(x*(x*(x*(x*(x*(+424514.955213594330209612358772*x
                   -1485802.34324758015573364325570)
                   +2080123.28054661221802710055798)
                   -1485802.34324758015573364325570)
                   +571462.439710607752205247406040)
                   -114292.487942121550441049481208)
                   +10390.2261765565045855499528371)
              -296.863605044471559587141509631;
              return;
            case(9):
                  grad[0 ]=x*(x*(x*(x*(x*(x*(x*(1907366.99971452793298785857650*x
              -7629467.99885811173195143430599)
                +12566182.5863545369702729506216)
                    -10995409.7630602198489888317939)
                          +5497704.88153010992449441589695)
              -1570772.82329431712128411882770)
              +241657.357429894941736018281185)
               -17261.2398164210672668584486561)
                           +392.300904918660619701328378547;
              return;
        case(10):
             grad[0]=x*(x*(x*(x*(x*(x*(x*(x*(8466583.55097261176257181247327*x
                   -38099625.9793767529315731561297)
                   +72188765.0135559529229807168774)
                   -74862422.9770209882164244471323)
                   +46238555.3681600221336739232286)
                   -17339458.2630600083001277212108)
                   +3853212.94734666851113949360238)
                   -471821.993552653287078305339067)
                   +27220.4996280376896391330003308)
               -504.083326445142400724685191311;
        }
      }

    }; // end struct OrthonormalBase_1d

  } // end namespace Fem
} // end namespace Dune
#endif
