// original implementation done by Christian Engwer
#ifndef DUNE_ORTHONORMALBASE_2D_HH
#define DUNE_ORTHONORMALBASE_2D_HH

#define PMAX2D 8

#include <stdlib.h>
#include <stdio.h>
#include <cassert>

namespace Dune {

  namespace Fem {

    template <class DomainField, class RangeField>
    class OrthonormalBase_2D
    {
      typedef const DomainField* DomainType;
      typedef RangeField* JacobianRangeType;
      typedef RangeField HessianRangeType[3];

    public:
      /* \phi_i(x,y) for triangle */
      static RangeField
      eval_triangle_2d ( const int i, DomainType xi )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];

        switch (i)	{
          #if (PMAX2D>=0)
          case ( 0 ):
            return 1.4142135623730950488016887242097;
          #endif
          #if (PMAX2D>=1)
          case ( 1 ):
            return -2.
             + 6.*x;
          case ( 2 ):
            return -3.4641016151377545870548926830117
             + 3.4641016151377545870548926830117*x
             + 6.928203230275509174109785366023*y;
          #endif
          #if (PMAX2D>=2)
          case ( 3 ):
            return 2.4494897427831780981972840747059
             + x*(-19.595917942265424785578272597647
             + 24.494897427831780981972840747059*x);
          case ( 4 ):
            return 4.2426406871192851464050661726291
             - 8.485281374238570292810132345258*y
             + x*(-25.455844122715710878430397035775
             + 21.213203435596425732025330863145*x
             + 42.426406871192851464050661726291*y);
          case ( 5 ):
            return 5.477225575051661134569697828008
             + y*(-32.863353450309966807418186968048
             + 32.863353450309966807418186968048*y)
             + x*(-10.954451150103322269139395656016
             + 5.477225575051661134569697828008*x
             + 32.863353450309966807418186968048*y);
          #endif
          #if (PMAX2D>=3)
          case ( 6 ):
            return -2.8284271247461900976033774484194
             + x*(42.426406871192851464050661726291
             + x*(-127.27922061357855439215198517887
             + 98.99494936611665341611821069468*x));
          case ( 7 ):
            return -4.8989794855663561963945681494118
             + 9.797958971132712392789136298824*y
             + x*(63.686733312362630553129385942353
             - 117.57550765359254871346963558588*y
             + x*(-161.66632302368975448102074893059
             + 102.87856919689348012428593113765*x
             + 205.75713839378696024857186227529*y));
          case ( 8 ):
            return -6.3245553203367586639977870888654
             + (37.947331922020551983986722533193
             - 37.947331922020551983986722533193*y)*y
             + x*(56.920997883030827975980083799789
             + y*(-303.57865537616441587189378026554
             + 265.63132345414386388790705773235*y)
             + x*(-94.868329805051379959966806332982
             + 44.271887242357310647984509622058*x
             + 265.63132345414386388790705773235*y));
          case ( 9 ):
            return -7.4833147735478827711674974646331
             + y*(89.799777282574593254009969575597
             + y*(-224.49944320643648313502492393899
             + 149.66629547095765542334994929266*y))
             + x*(22.449944320643648313502492393899
             + x*(-22.449944320643648313502492393899
             + 7.483314773547882771167497464633*x
             + 89.7997772825745932540099695756*y)
             + y*(-179.59955456514918650801993915119
             + 224.49944320643648313502492393899*y));
          #endif
          #if (PMAX2D>=4)
          case ( 10 ):
            return 3.1622776601683793319988935444327
             + x*(-75.894663844041103967973445066385
             + x*(398.44698518121579583186058659852
             + x*(-708.35019587771697036775215395293
             + 398.44698518121579583186058659852*x)));
          case ( 11 ):
            return 5.477225575051661134569697828008
             - 10.954451150103322269139395656016*y
             + x*(-120.49896265113654496053335221618
             + 230.04347415216976765192730877634*y
             + x*(575.10868538042441912981827194084
             - 920.1738966086790706077092351053*y
             + x*(-920.17389660867907060770923510535
             + 460.08694830433953530385461755267*x
             + 920.1738966086790706077092351053*y)));
          case ( 12 ):
            return 7.0710678118654752440084436210485
             + y*(-42.426406871192851464050661726291
             + 42.426406871192851464050661726291*y)
             + x*(-127.27922061357855439215198517887
             + (721.24891681027847488886124934695
             - 678.8225099390856234248105876207*y)*y
             + x*(487.90367901871779183658260985235
             + y*(-2206.1731573020282761306344097671
             + 1527.3506473629426527058238221465*y)
             + x*(-622.25396744416182147274303865227
             + 254.55844122715710878430397035775*x
             + 1527.3506473629426527058238221465*y)));
          case ( 13 ):
            return 8.3666002653407554797817202578519
             + y*(-100.39920318408906575738064309422
             + (250.99800796022266439345160773556
             - 167.33200530681510959563440515704*y)*y)
             + x*(-100.39920318408906575738064309422
             + y*(1104.3912350249797233311870740364
             + y*(-2509.9800796022266439345160773556
             + 1505.9880477613359863607096464133*y))
             + x*(250.99800796022266439345160773556
             + x*(-234.26480742954115343388816721985
             + 75.29940238806679931803548232067*x
             + 903.592828656801591816425787848*y)
             + y*(-1907.5848604976922493902322187902
             + 2258.98207164200397954106446962*y)));
          case ( 14 ):
            return 9.4868329805051379959966806332982
             + y*(-189.73665961010275991993361266596
             + y*(853.81496824546241963970125699683
             + y*(-1328.1566172707193194395352886617
             + 664.0783086353596597197676443309*y)))
             + x*(-37.947331922020551983986722533193
             + x*(56.920997883030827975980083799789
             + x*(-37.947331922020551983986722533193
             + 9.486832980505137995996680633298*x
             + 189.73665961010275991993361266596*y)
             + y*(-569.20997883030827975980083799789
             + 853.8149682454624196397012569968*y))
             + y*(569.20997883030827975980083799789
             + y*(-1707.6299364909248392794025139937
             + 1328.1566172707193194395352886617*y)));
          #endif
          #if (PMAX2D>=5)
          case ( 15 ):
            return -3.4641016151377545870548926830117
             + x*(121.24355652982141054692124390541
             + x*(-969.94845223857128437536995124329
             + x*(2909.8453567157138531261098537299
             + x*(-3637.3066958946423164076373171623
             + 1600.4149461936426192193604195514*x))));
          case ( 16 ):
            return -6.
             + 12.*y
             + x*(198.
             - 384.*y
             + x*(-1488.
             + 2592.*y
             + x*(4176.
             - 5760.*y
             + x*(-4860.
             + 1980.*x
             + 3960.*y))));
          case ( 17 ):
            return -7.7459666924148337703585307995648
             + (46.475800154489002622151184797389
             - 46.475800154489002622151184797389*y)*y
             + x*(224.63303408003017934039739318738
             + y*(-1301.3224043256920734202331743269
             + 1254.8466041712030707980819895295*y)
             + x*(-1471.7336715588184163681208519173
             + (7529.079625027218424788491937177
             - 6274.233020856015353990409947647*y)*y
             + x*(3578.6366118956532019056412293989
             + y*(-13942.740046346700786645355439217
             + 7668.507025490685432654945491569*y)
             + x*(-3601.8745119728977032167168217976
             + 1278.0845042484475721091575819282*x
             + 7668.507025490685432654945491569*y))));
          case ( 18 ):
            return -9.165151389911680013176094387456
             + y*(109.98181667894016015811313264947
             + y*(-274.95454169735040039528283162368
             + 183.30302779823360026352188774912*y))
             + x*(210.79848196796864030305017091149
             + y*(-2419.5999669366835234784889182884
             + (5774.0453756443584083009394640973
             - 3666.0605559646720052704377549824*y)*y)
             + x*(-1081.4878640095782415547791377198
             + y*(10558.254401178255375178860734349
             + y*(-20621.590627301280029646212371776
             + 10081.666528902848014493703826202*y))
             + x*(2071.3242141200396829777973315651
             + x*(-1695.5530071336608024375774616794
             + 504.0833264451424007246851913101*x
             + 6048.999917341708808696222295721*y)
             + y*(-14297.636168262220820554707244431
             + 15122.499793354272021740555739302*y))));
          case ( 19 ):
            return -10.392304845413263761164678049035
             + y*(207.8460969082652752232935609807
             + y*(-935.30743608719373850482102441317
             + (1454.9226783578569265630549268649
             - 727.4613391789284632815274634325*y)*y))
             + x*(155.88457268119895641747017073553
             + y*(-2909.8453567157138531261098537299
             + y*(12158.996669133518600562673317371
             + y*(-17459.072140294283118756659122379
             + 8002.074730968213096096802097757*y)))
             + x*(-519.61524227066318805823390245176
             + x*(727.46133917892846328152746343247
             + x*(-467.65371804359686925241051220659
             + 114.31535329954590137281145853939*x
             + 2286.3070659909180274562291707878*y)
             + y*(-7066.767294881019357591981073344
             + 10288.381796959131123553031268545*y))
             + y*(7482.4594886975499080385681953054
             + y*(-21512.071030005455985610883561503
             + 16004.149461936426192193604195514*y))));
          case ( 20 ):
            return -11.489125293076057319701222936438
             + y*(344.67375879228171959103668809314
             + y*(-2412.716311545972037137256816652
             + y*(6433.9101641225920990326848444052
             + y*(-7238.1489346379161114117704499559
             + 2895.2595738551664445647081799823*y))))
             + x*(57.445626465380286598506114682189
             + x*(-114.89125293076057319701222936438
             + x*(114.89125293076057319701222936438
             + x*(-57.445626465380286598506114682189
             + 11.489125293076057319701222936438*x
             + 344.67375879228171959103668809314*y)
             + y*(-1378.6950351691268783641467523725
             + 2412.716311545972037137256816652*y))
             + y*(2068.0425527536903175462201285588
             + y*(-7238.1489346379161114117704499559
             + 6433.910164122592099032684844405*y)))
             + y*(-1378.6950351691268783641467523725
             + y*(7238.1489346379161114117704499559
             + y*(-12867.82032824518419806536968881
             + 7238.148934637916111411770449956*y))));
          #endif
          #if (PMAX2D>=6)
          case ( 21 ):
            return 3.7416573867739413855837487323165
             + x*(-179.59955456514918650801993915119
             + x*(2020.4949888579283482152243154509
             + x*(-8979.9777282574593254009969575597
             + x*(18521.204064531009858639556224967
             + x*(-17780.355901949769464293973975968
             + 6420.684075704083417661712824655*x)))));
          case ( 22 ):
            return 6.480740698407860230965967436088
             - 12.961481396815720461931934872176*y
             + x*(-298.11407212676157062443450206005
             + 583.2666628567074207869370692479*y
             + x*(3207.9666457118908143281538808636
             - 5832.666628567074207869370692479*y
             + x*(-13609.555466656506485028531615785
             + 21386.44430474593876218769253909*y
             + x*(26733.055380932423452734615673863
             - 32079.666457118908143281538808636*y
             + x*(-24380.546507410370188893969494563
             + 8340.713278850916117253200090245*x
             + 16681.426557701832234506400180491*y)))));
          case ( 23 ):
            return 8.3666002653407554797817202578519
             + y*(-50.199601592044532878690321547111
             + 50.19960159204453287869032154711*y)
             + x*(-351.39721114431173015083225082978
             + (2058.1836652738258480263031834316
             - 2007.9840636817813151476128618844*y)*y
             + x*(3438.6727090550505021902870259771
             + y*(-18573.852589056477165115418972431
             + 16565.868525374695849967806110547*y)
             + x*(-13219.228419238393658055118007406
             + (60741.517926373884783215289072005
             - 44175.649400999188933247482961458*y)*y
             + x*(23468.313744280819120787725323275
             + y*(-80068.364539311029941511062867642
             + 35892.715138311841008263579906185*y)
             + x*(-19326.846612937145158295773795638
             + 5982.119189718640168043929984364*x
             + 35892.715138311841008263579906185*y)))));
          case ( 24 ):
            return 9.8994949366116653416118210694679
             + y*(-118.79393923933998409934185283361
             + (296.98484809834996024835463208404
             - 197.98989873223330683223642138936*y)*y)
             + x*(-356.38181771801995229802555850084
             + y*(4157.7878733768994434769648491765
             + y*(-10097.484835343898648444057490857
             + 6533.666658163699125463801905849*y))
             + x*(2969.8484809834996024835463208404
             + y*(-31480.393898425095786325591000908
             + (68603.499910718840817369920011412
             - 39201.999948982194752782811435093*y)*y)
             + x*(-9701.5050378794320347795846480785
             + y*(84937.666556128088631029424776034
             + y*(-143740.66647960138076020364192867
             + 56625.11103741872575401961651736*y))
             + x*(14700.74998086832303229355428816
             + x*(-10453.866653061918600742083049358
             + 2831.2555518709362877009808258678*x
             + 33975.066622451235452411769910414*y)
             + y*(-91471.333214291787756493226681883
             + 84937.66655612808863102942477603*y)))));
          case ( 25 ):
            return 11.22497216032182415675124619695
             + y*(-224.49944320643648313502492393899
             + y*(1010.2474944289641741076121577255
             + y*(-1571.496102445055381945174467573
             + 785.7480512225276909725872337865*y)))
             + x*(-314.29922048901107638903489351459
             + y*(6061.4849665737850446456729463528
             + y*(-26266.434855153068526797916100862
             + (39287.402561126384548629361689324
             - 18857.953229340664583342093610875*y)*y))
             + x*(2020.4949888579283482152243154509
             + y*(-34348.414810584781919658813362666
             + y*(128301.43179247845011166674403113
             + y*(-160292.60244939564895840779569244
             + 61288.34799535715989586180423535*y)))
             + x*(-5163.4871937480391121055732505968
             + x*(6342.1092705818306485644541012766
             + x*(-3771.5906458681329166684187221751
             + 875.5478285051022842265972033621*x
             + 17510.956570102045684531944067241*y)
             + y*(-57920.85634726061264883643037626
             + 78799.30456545920558039374830259*y))
             + y*(68921.329064376000322452651649271
             + y*(-181844.54899721355133937018839058
             + 122576.69599071431979172360847069*y)))));
          case ( 26 ):
            return 12.409673645990856596133241955449
             + y*(-372.29020937972569788399725866348
             + y*(2606.0314656580798851879808106444
             + y*(-6949.4172417548796938346154950517
             + (7818.0943969742396555639424319332
             - 3127.2377587896958622255769727733*y)*y)))
             + x*(-223.37412562783541873039835519809
             + y*(6328.9335594553368640279533972792
             + y*(-41696.50345052927816300769297031
             + y*(104241.25862632319540751923242578
             + y*(-109453.32155763935517789519404706
             + 40654.090864266046208932500646052*y))))
             + x*(930.72552344931424470999314665871
             + x*(-1737.3543104387199234586538737629
             + x*(1675.3059422087656404779876639857
             + x*(-819.03846063539653534479396905967
             + 161.32575739788113574973214542084*x
             + 4839.7727219364340724919643626253*y)
             + y*(-19731.381097125461987851854709165
             + 33878.409053555038507443750538377*y))
             + y*(30527.797169137507226487775210406
             + y*(-104241.25862632319540751923242578
             + 90342.42414281343601985000143567*y)))
             + y*(-21592.832144024090477271841002482
             + y*(109453.32155763935517789519404706
             + y*(-187634.2655273817517335346183664
             + 101635.22716066511552233125161513*y)))));
          case ( 27 ):
            return 13.490737563232041465550305611496
             + y*(-566.61097765574574155311283568281
             + y*(5666.1097765574574155311283568281
             + y*(-22664.439106229829662124513427313
             + y*(42495.823324180930616483462676211
             + y*(-37396.324525279218942505447155066
             + 12465.441508426406314168482385022*y)))))
             + x*(-80.944425379392248793301833668973
             + y*(2833.0548882787287077655641784141
             + y*(-22664.439106229829662124513427313
             + y*(67993.317318689488986373540281938
             + y*(-84991.646648361861232966925352422
             + 37396.324525279218942505447155066*y))))
             + x*(202.36106344848062198325458417243
             + x*(-269.81475126464082931100611222991
             + x*(202.36106344848062198325458417243
             + x*(-80.944425379392248793301833668973
             + 13.490737563232041465550305611496*x
             + 566.6109776557457415531128356828*y)
             + y*(-2833.0548882787287077655641784141
             + 5666.109776557457415531128356828*y))
             + y*(5666.1097765574574155311283568281
             + y*(-22664.439106229829662124513427313
             + 22664.439106229829662124513427313*y)))
             + y*(-5666.1097765574574155311283568281
             + y*(33996.658659344744493186770140969
             + y*(-67993.317318689488986373540281938
             + 42495.823324180930616483462676211*y)))));
          #endif
          #if (PMAX2D>=7)
          case ( 28 ):
            return -4.
             + x*(252.
             + x*(-3780.
             + x*(23100.
             + x*(-69300.
             + x*(108108.
             + x*(-84084.
             + 25740.*x))))));
          case ( 29 ):
            return -6.9282032302755091741097853660235
             + 13.856406460551018348219570732047*y
             + x*(422.62039704680605962069690732743
             - 831.3843876330611008931742439228*y
             + x*(-6131.4598587938256190871600489308
             + 11431.535329954590137281145853939*y
             + x*(36199.861878189535434723628537473
             - 60968.18842642448073216611122101*y
             + x*(-104789.07385791707625841050366111
             + 148609.9592894096717846548961012*y
             + x*(157526.55684677425209173418986728
             - 166443.15440413883239881348363335*y
             + x*(-117897.23436959833961582621757362
             + 34675.657167528923416419475756948*x
             + 69351.3143350578468328389515139*y))))));
          case ( 30 ):
            return -8.9442719099991587856366946749251
             + (53.665631459994952713820168049551
             - 53.66563145999495271382016804955*y)*y
             + x*(509.82349886995205078129159647073
             + y*(-3005.2753617597173519739294107748
             + 2951.6097302997223992601092427253*y)
             + x*(-6896.0336426093514237258915943673
             + (38370.926493896391190381420155429
             - 35419.316763596668791121310912703*y)*y
             + x*(37878.991538846437457171401948308
             + y*(-188903.02273918223355264699153442
             + 153483.70597558556476152568062171*y)
             + x*(-101830.53569534042277447376887402
             + (422080.19143286030309419562170972
             - 268596.485457274738332669941088*y)*y
             + x*(141972.42802741664740441125457509
             + y*(-429754.3767316395813322719057408
             + 161157.8912743648429996019646528*y)
             + x*(-98485.3780010007373886456450656
             + 26859.6485457274738332669941088*x
             + 161157.8912743648429996019646528*y))))));
          case ( 31 ):
            return -10.583005244258362362006463014557
             + y*(126.99606293110034834407755617468
             + y*(-317.49015732775087086019389043671
             + 211.66010488516724724012926029114*y))
             + x*(539.73326745717648046232961374241
             + y*(-6349.8031465550174172038778087342
             + (15557.017709059792672149500631399
             - 10159.685034488027867526204493975*y)*y)
             + x*(-6508.5482252188928526339747539526
             + y*(71752.775556071696814403819238697
             + y*(-163824.92118111944936386004746534
             + 99056.92908625827170838049381625*y))
             + x*(31801.930758996378897829421358744
             + y*(-309870.39355188484995954923706623
             + (610851.06269859267553501304520023
             - 308177.1127128035119816282029839*y)*y)
             + x*(-76038.892679996333571016436759592
             + y*(602596.31860807115289264800404888
             + y*(-895639.73382158520669660696492196
             + 288916.04316825329248277644029741*y))
             + x*(94516.819836471434255079721183009
             + x*(-58746.262110878169471497876193806
             + 14445.80215841266462413882201487*x
             + 173349.62590095197548966586417844*y)
             + y*(-531605.51942958605816830865014723
             + 433374.06475237993872416466044611*y))))));
          case ( 32 ):
            return -12.
             + y*(240.
             + y*(-1080.
             + (1680.
             - 840.*y)*y))
             + x*(516.
             + y*(-10080.
             + y*(44280.
             + y*(-67200.
             + 32760.*y)))
             + x*(-5220.
             + y*(94320.
             + y*(-380160.
             + (524160.
             - 229320.*y)*y))
             + x*(21420.
             + y*(-334080.
             + y*(1.1232e6
             + y*(-1.22304e6
             + 382200.*y)))
             + x*(-43380.
             + x*(46332.
             + x*(-25116.
             + 5460.*x
             + 109200.*y)
             + y*(-393120.
             + 491400.*y))
             + y*(533520.
             + y*(-1.27764e6
             + 764400.*y))))));
          case ( 33 ):
            return -13.266499161421599396459730946683
             + y*(397.99497484264798189379192840048
             + y*(-2785.9648238985358732565434988034
             + y*(7429.2395303960956620174493301423
             + y*(-8357.8944716956076197696304964101
             + 3343.1577886782430479078521985641*y))))
             + x*(437.79447232691278008317112124053
             + y*(-12735.839194964735420601341708815
             + y*(86364.909540854612070952848462905
             + y*(-222877.18591188286986052347990427
             + (242378.93967917262097331928439589
             - 93608.41808299080534141986155979*y)*y)))
             + x*(-3382.9572861625078460972313914041
             + y*(88752.879389910499962315600033308
             + y*(-534905.24618851888766525635177025
             + y*(1.2035368039241674972468267914831e6
             + y*(-1.1115999647355158134293608560225e6
             + 351031.56781121552003032448084923*y))))
             + x*(10812.196816558603508114680721546
             + x*(-17710.776380497835194273740813821
             + x*(15800.400501253124881183539557499
             + x*(-7336.3740362661444662422312135156
             + 1392.9824119492679366282717494017*x
             + 41789.472358478038098848152482051*y)
             + y*(-178301.74872950629588841878392342
             + 292526.30650934626669193706737435*y))
             + y*(295710.26630808745054708740280156
             + y*(-955585.93459719780452699442008956
             + 780070.1506915900445118321796649*y)))
             + y*(-235613.02510684760528112482161309
             + y*(1.1143859295594143493026173995214e6
             + y*(-1.7681590082342707675601529405739e6
             + 877578.9195280388000758112021231*y))))));
          case ( 34 ):
            return -14.422205101855957172476885069882
             + y*(605.73261427795020124402917293504
             + y*(-6057.3261427795020124402917293504
             + y*(24229.304571118008049761166917402
             + y*(-45429.946070846265093302187970128
             + (39978.352542344713282105925413713
             - 13326.117514114904427368641804571*y)*y))))
             + x*(302.86630713897510062201458646752
             + y*(-12114.652285559004024880583458701
             + y*(115089.19671281053823636554285766
             + y*(-436127.48228012414489570100451323
             + y*(772309.08320438650658613719549218
             + y*(-639653.64067751541251369480661941
             + 199891.76271172356641052962706856*y)))))
             + x*(-1514.3315356948755031100729323376
             + y*(51487.272213625767105742479699479
             + y*(-399783.52542344713282105925413713
             + y*(1.1630066194136643863885360120353e6
             + y*(-1.408328328196234217892367827074e6
             + 599675.2881351706992315888812057*y))))
             + x*(3533.4402499547095072568368421211
             + x*(-4542.9946070846265093302187970128
             + x*(3331.5293785287261068421604511427
             + x*(-1312.4206642688921026953965413593
             + 216.33307652783935758715327604823*x
             + 9085.989214169253018660437594026*y)
             + y*(-46035.678685124215294546217143063
             + 90859.89214169253018660437594026*y))
             + y*(93888.555213082281192824521804932
             + y*(-369496.89470954962275885779549038
             + 363439.56856677012074641750376103*y)))
             + y*(-96917.218284472032199044667669607
             + y*(569388.65742127318916938742255894
             + y*(-1.1145480102714283702890136782005e6
             + 681449.1910626939763995328195519*y))))));
          case ( 35 ):
            return -15.49193338482966754071706159913
             + y*(867.54826955046138228015544955126
             + y*(-11711.901638931228660782098568942
             + y*(65066.120216284603671011658716344
             + y*(-178931.83059478266009528206146995
             + y*(257661.83605648703053720616851672
             + y*(-186089.10381857396649909334392874
             + 53168.31537673541899974095540821*y))))))
             + x*(108.44353369380767278501943119391
             + y*(-5205.2896173027682936809326973075
             + y*(58559.50819465614330391049284471
             + y*(-260264.48086513841468404663486538
             + y*(536795.49178434798028584618440984
             + y*(-515323.67211297406107441233703345
             + 186089.10381857396649909334392874*y)))))
             + x*(-325.33060108142301835505829358172
             + x*(542.21766846903836392509715596954
             + x*(-542.21766846903836392509715596954
             + x*(325.33060108142301835505829358172
             + x*(-108.44353369380767278501943119391
             + 15.49193338482966754071706159913*x
             + 867.5482695504613822801554495513*y)
             + y*(-5205.2896173027682936809326973075
             + 11711.901638931228660782098568942*y))
             + y*(13013.224043256920734202331743269
             + y*(-58559.50819465614330391049284471
             + 65066.12021628460367101165871634*y)))
             + y*(-17350.965391009227645603108991025
             + y*(117119.01638931228660782098568942
             + y*(-260264.48086513841468404663486538
             + 178931.83059478266009528206146995*y))))
             + y*(13013.224043256920734202331743269
             + y*(-117119.01638931228660782098568942
             + y*(390396.72129770762202606995229807
             + y*(-536795.49178434798028584618440984
             + 257661.83605648703053720616851672*y))))));
          #endif
          #if (PMAX2D>=8)
          case ( 36 ):
            return 4.2426406871192851464050661726291
             + x*(-339.41125496954281171240529381033
             + x*(6533.6666581636991254638019058488
             + x*(-52269.33326530959300371041524679
             + x*(212344.16639032022157757356194009
             + x*(-475650.93271431729633376477874579
             + x*(594563.66589289662041720597343224
             + x*(-388286.47568515697659899165611901
             + 103138.59510386982190910715865661*x)))))));
          case ( 37 ):
            return 7.3484692283495342945918522241177
             - 14.696938456699068589183704448235*y
             + x*(-573.18059981126367497816447348118
             + 1131.6642611658282813671452425141*y
             + x*(10750.810481075368672987879803884
             - 20369.956700984909064608614365254*y
             + x*(-83743.155326271292821168747946045
             + 147116.35395155767657772888152684*y
             + x*(331011.79639100477229988998343538
             - 514907.2388304518680220510853439*y
             + x*(-720870.1343626326152308715194815
             + 926833.0298948133624396919536191*y
             + x*(875342.30601176817563748684508467
             - 823851.5821287229888352817365503*y
             + x*(-554838.82061730323737886321032978
             + 142913.02955294174296122234205464*x
             + 285826.05910588348592244468410928*y)))))));
          case ( 38 ):
            return 9.4868329805051379959966806332982
             + y*(-56.920997883030827975980083799789
             + 56.92099788303082797598008379979*y)
             + x*(-702.02564055738021170375436686406
             + (4155.2328454612504422465461173846
             - 4098.3118475782196142705660335848*y)*y
             + x*(12475.185369364256464735635032787
             + y*(-70695.879370724288346167264079338
             + 66597.56752314606873189669804575*y)
             + x*(-91946.385247055797457199828697926
             + (480982.43211161049639703170810822
             - 414384.86458846442766513501006246*y)*y
             + x*(343470.78805918852114505982232856
             + y*(-1.5798422962435206304733272258631e6
             + 1.1654574316550562028081922158007e6*y)
             + x*(-706180.87340284146214600091298145
             + (2.6572429441735281424026782520255e6
             - 1.4917855125184719395944860362249e6*y)*y
             + x*(808913.78774873160150464896755943
             + y*(-2.1962397823188614666252155533311e6
             + 704454.2698003895270307295171062*y)
             + x*(-483449.00868654183227599084507287
             + 117409.0449667315878384549195177*x
             + 704454.2698003895270307295171062*y)))))));
          case ( 39 ):
            return 11.22497216032182415675124619695
             + y*(-134.6996659238618898810149543634
             + (336.74916480965472470253738590849
             - 224.49944320643648313502492393899*y)*y)
             + x*(-763.29810690188404265908474139258
             + y*(9024.8776168987466220280019423475
             + y*(-22225.44487743721183036746746996
             + 14592.463808418371403776620056035*y))
             + x*(12437.26915363658116568038078622
             + y*(-140222.3522267402273661365674923
             + (328330.43568941335658497395126078
             - 204294.49331785719965287268078448*y)*y)
             + x*(-83917.891870565957395872316568396
             + y*(866792.35022005126138433123132845
             + y*(-1.8386504398607147968758541270604e6
             + 1.0214724665892859982643634039224e6*y))
             + x*(286741.91383542099808421058410108
             + y*(-2.5741106158050007156261957778845e6
             + (4.5966260996517869921896353176509e6
             - 2.0429449331785719965287268078448e6*y)*y)
             + x*(-539337.46235914300708358387727104
             + y*(3.8979389325047153693768107493679e6
             + y*(-5.148221231610001431252391555769e6
             + 1.3892025545614289576395342293345e6*y))
             + x*(565895.74649046444303845732577302
             + x*(-310527.62984314294347236647479242
             + 69460.12772807144788197671146672*x
             + 833521.5327368573745837205376007*y)
             + y*(-2.8928100253808579470846771599083e6
             + 2.0838038318421434364593013440017e6*y)))))));
          case ( 40 ):
            return 12.727922061357855439215198517887
             + y*(-254.55844122715710878430397035775
             + y*(1145.5129855222069895293678666099
             + y*(-1781.9090885900997614901277925042
             + 890.9545442950498807450638962521*y)))
             + x*(-763.67532368147132635291191107324
             + y*(15018.948032402269418273934251107
             + y*(-66439.753160288005392703336263372
             + (101568.81804963568640493728417274
             - 49893.454480522793321723578190118*y)*y))
             + x*(10946.012972767755677725070725383
             + y*(-203901.31142295284413622748025655
             + y*(851116.14824299979322032032489112
             + y*(-1.2223896347728084363822276656579e6
             + 561301.3629058814248693902546388*y)))
             + x*(-64912.402512925062739997512441225
             + y*(1.0943467388355484106637227685679e6
             + y*(-4.0734441765169680547664321336646e6
             + (5.1140790842535863154766667644871e6
             - 1.9957381792209117328689431276047e6*y)*y))
             + x*(195309.96403153629171475722125698
             + y*(-2.8118525417951774236314216565717e6
             + y*(8.5798922615613303515749653209078e6
             + y*(-8.2324199892862608980843904013695e6
             + 2.12047181542221871617325207308e6*y)))
             + x*(-325020.21775883419649579930935277
             + x*(303815.49960461200933406678862197
             + x*(-149680.36344156837996517073457035
             + 30292.454506031695945332172472572*x
             + 605849.0901206339189066434494514*y)
             + y*(-2.3877581787107336803967712419557e6
             + 2.7263209055428526350798955225315e6*y))
             + y*(3.6885518133815065062845645304837e6
             + y*(-8.018590898655448926705575066269e6
             + 4.24094363084443743234650414616e6*y)))))));
          case ( 41 ):
            return 14.071247279470288663696890340633
             + y*(-422.137418384108659910906710219
             + y*(2954.961928688760619376346971533
             + y*(-7879.8984765033616516702585907547
             + (8864.885786066281858129040914599
             - 3545.9543144265127432516163658396*y)*y)))
             + x*(-703.56236397351443318484451703167
             + y*(20684.733500821324335634428800731
             + y*(-141838.17257706050973006465463358
             + y*(370355.22839565799762850215376547
             + y*(-407784.74615904896547393588207156
             + 159567.94414919307344632273646278*y))))
             + x*(8372.3921312848217548996497526769
             + y*(-230487.03043772332831135506377958
             + y*(1.4715710404870027884494207918234e6
             + y*(-3.5538342129030161049032866244304e6
             + (3.5902787433568441525422615704126e6
             - 1.2765435531935445875705818917023e6*y)*y)))
             + x*(-41369.467001642648671268857601462
             + y*(1.0105969796115561318267106642643e6
             + y*(-5.6026078167938901343375538580266e6
             + y*(1.1386453298547357586663523663641e7
             + y*(-9.219481217508933132454202551183e6
             + 2.4112489338100286654110991287709e6*y))))
             + x*(104901.14846845100198786031748942
             + x*(-149521.07359165128734044315675957
             + x*(121645.93273102064549765961699478
             + x*(-52907.889770808285375500307680782
             + 9568.448150039796291313885431631*x
             + 287053.44450119388873941656294892*y)
             + y*(-1.3001832486230546725255926674745e6
             + 2.0093741115083572211759159406424e6*y))
             + y*(2.3491947333075646924041958423687e6
             + y*(-7.0919086288530254865032327316792e6
             + 5.358330964022285923135775841713e6*y)))
             + y*(-2.1364374744419739278090988604184e6
             + y*(9.352454504299927360326138164902e6
             + y*(-1.3553425379585782040872844776098e7
             + 6.028122334525071663527747821927e6*y)))))));
          case ( 42 ):
            return 15.297058540778354490084672327068
             + y*(-642.47645871269088858355623773687
             + y*(6424.7645871269088858355623773687
             + y*(-25699.058348507635543342249509475
             + y*(48185.734403451816643766717830265
             + y*(-42403.446275037598646514711690633
             + 14134.482091679199548838237230211*y)))))
             + x*(-581.2882245495774706232175484286
             + y*(23771.628972369562877591580796264
             + y*(-231291.52513656871989008024558527
             + y*(899467.04219776724401697873283162
             + y*(-1.638314969717361765888068406229e6
             + (1.3993137270762407553349854857909e6
             - 452303.42693373438556282359136676*y)*y))))
             + x*(5246.8910794869755900990426081844
             + y*(-196597.79636608341190656820874748
             + y*(1.7346864385242653991756018418896e6
             + y*(-6.0392787118992943526854286347266e6
             + y*(9.6853326150938151453971102838833e6
             + y*(-7.1237789742063165726144715640264e6
             + 1.9222895644683711386420002633087e6*y)))))
             + x*(-20130.929039664314508951428782422
             + y*(648901.22329981779746939180011424
             + y*(-4.7543257944739125755183161592528e6
             + y*(1.2978024465996355949387836002285e7
             + y*(-1.4648463258649352259705082220401e7
             + 5.766868693405113415926000789926e6*y))))
             + x*(41225.572767397665350778191921449
             + x*(-49042.369681735404495211459480581
             + x*(34158.331721558065576359073306344
             + x*(-12971.905642580044607591802133354
             + 2080.3999615458562106515154364813*x
             + 87376.79838492596084736364833221*y)
             + y*(-457443.23860343591267149204126865
             + 873767.9838492596084736364833221*y))
             + y*(977206.69370200284153558903759778
             + y*(-3.7006644021850995182412839293644e6
             + 3.4950719353970384338945459332886e6*y)))
             + y*(-1.0825728329308841472632922605866e6
             + y*(6.0714025348349288971146064466134e6
             + y*(-1.1307585673343359639070589784169e7
             + 6.553259878869447063552273624916e6*y)))))));
          case ( 43 ):
            return 16.431676725154983403709093484024
             + y*(-920.17389660867907060770923510535
             + y*(12422.347604217167453204074673922
             + y*(-69013.042245650930295578192632901
             + y*(189785.86617554005831284002974048
             + y*(-273291.64729277768397048964282629
             + (197377.3008225616606453536309301
             - 56393.51452073190304152960883717*y)*y)))))
             + x*(-394.36024140371960168901824361658
             + y*(21163.999621999618623977312407423
             + y*(-273291.64729277768397048964282629
             + y*(1.4492738871586695362071420452909e6
             + y*(-3.7957173235108011662568005948096e6
             + y*(5.1925412985627759954393032136995e6
             + y*(-3.5527914148061098916163653567417e6
             + 958689.7468524423517060033502319*y))))))
             + x*(2300.4347415216976765192730877634
             + y*(-107660.34590321545126110198050733
             + y*(1.1801230224006309080543870940226e6
             + y*(-5.1069651261781688418727862548347e6
             + y*(1.0248436773479163148893361605986e7
             + y*(-9.5652076552472189389671374989201e6
             + 3.3554141139835482309710117258116e6*y)))))
             + x*(-6441.2172762607534942539646457374
             + x*(10351.956336847639544336728894935
             + x*(-10121.912862695469776684801586159
             + x*(5981.1303279564139589501100281848
             + x*(-1971.8012070185980084450912180829
             + 279.33850432763471786305458922841*x
             + 15642.956242347544200331056996791*y)
             + y*(-94777.911350693944272594051215851
             + 211179.90927169184670446926945668*y))
             + y*(240165.3870148652374286121103625
             + y*(-1.0683218939626764009755504219573e6
             + 1.1732217181760658150248292747593e6*y)))
             + y*(-326661.7332960810700657367784624
             + y*(2.1739108307380043043107130679364e6
             + y*(-4.7618999149499141903948952916702e6
             + 3.2263597249841809913182805055881e6*y))))
             + y*(253047.82156738674441712003965397
             + y*(-2.236022568759090141576733441306e6
             + y*(7.3153824780389986113312884190875e6
             + y*(-9.8688650411280830322676815465049e6
             + 4.6459580039772206274983239280469e6*y)))))));
          case ( 44 ):
            return 17.492855684535901412622458632637
             + y*(-1259.4856092865849017088170215498
             + y*(22040.998162515235779904297877122
             + y*(-161633.98652511172905263151776556
             + y*(606127.44946916898394736819162086
             + y*(-1.2607450948958714866105258385714e6
             + y*(1.4708692773785167343789468116666e6
             + y*(-900532.21063990820472180417040814
             + 225133.05265997705118045104260203*y)))))))
             + x*(-139.94284547628721130097966906109
             + y*(8816.3992650060943119617191508489
             + y*(-132245.98897509141467942578726273
             + y*(808169.93262555864526315758882782
             + y*(-2.4245097978766759357894727664835e6
             + y*(3.7822352846876144598315775157142e6
             + y*(-2.9417385547570334687578936233333e6
             + 900532.2106399082047218041704081*y))))))
             + x*(489.79995916700523955342884171383
             + x*(-979.59991833401047910685768342766
             + x*(1224.4998979175130988835721042846
             + x*(-979.59991833401047910685768342766
             + x*(489.79995916700523955342884171383
             + x*(-139.94284547628721130097966906109
             + 17.492855684535901412622458632637*x
             + 1259.4856092865849017088170215498*y)
             + y*(-8816.3992650060943119617191508489
             + 22040.998162515235779904297877122*y))
             + y*(26449.197795018282935885157452547
             + y*(-132245.98897509141467942578726273
             + 161633.98652511172905263151776556*y)))
             + y*(-44081.996325030471559808595754245
             + y*(330614.97243772853669856446815683
             + y*(-808169.93262555864526315758882782
             + 606127.4494691689839473681916209*y))))
             + y*(44081.996325030471559808595754245
             + y*(-440819.96325030471559808595754245
             + y*(1.6163398652511172905263151776556e6
             + y*(-2.4245097978766759357894727664835e6
             + 1.2607450948958714866105258385714e6*y)))))
             + y*(-26449.197795018282935885157452547
             + y*(330614.97243772853669856446815683
             + y*(-1.6163398652511172905263151776556e6
             + y*(3.6367646968150139036842091497252e6
             + y*(-3.7822352846876144598315775157142e6
             + 1.4708692773785167343789468116666e6*y)))))));
          #endif
        }

        printf("Error eval_triangle_2d: There is no shape function %d.\n",i);
        return 0.0;
      }

      /* \nabla\phi_i(x,y) for triangle */
      static void
      grad_triangle_2d ( const int i, DomainType xi, JacobianRangeType grad )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];

        switch (i)	{
          #if (PMAX2D>=0)
          case ( 0 ):
            grad[0]= 0;
            grad[1]= 0;
            return;
          #endif
          #if (PMAX2D>=1)
          case ( 1 ):
            grad[0]= 6.;
            grad[1]= 0;
            return;
          case ( 2 ):
            grad[0]= 3.4641016151377545870548926830117;
            grad[1]= 6.9282032302755091741097853660235;
            return;
          #endif
          #if (PMAX2D>=2)
          case ( 3 ):
            grad[0]= -19.595917942265424785578272597647
             + 48.989794855663561963945681494118*x;
            grad[1]= 0;
            return;
          case ( 4 ):
            grad[0]= -25.455844122715710878430397035775
             + 42.426406871192851464050661726291*x
             + 42.426406871192851464050661726291*y;
            grad[1]= -8.4852813742385702928101323452582
             + 42.426406871192851464050661726291*x;
            return;
          case ( 5 ):
            grad[0]= -10.954451150103322269139395656016
             + 10.954451150103322269139395656016*x
             + 32.863353450309966807418186968048*y;
            grad[1]= -32.863353450309966807418186968048
             + 32.863353450309966807418186968048*x
             + 65.7267069006199336148363739361*y;
            return;
          #endif
          #if (PMAX2D>=3)
          case ( 6 ):
            grad[0]= 42.426406871192851464050661726291
             + x*(-254.55844122715710878430397035775
             + 296.98484809834996024835463208404*x);
            grad[1]= 0;
            return;
          case ( 7 ):
            grad[0]= 63.686733312362630553129385942353
             - 117.57550765359254871346963558588*y
             + x*(-323.33264604737950896204149786118
             + 308.63570759068044037285779341294*x
             + 411.51427678757392049714372455059*y);
            grad[1]= 9.7979589711327123927891362988236
             + x*(-117.57550765359254871346963558588
             + 205.75713839378696024857186227529*x);
            return;
          case ( 8 ):
            grad[0]= 56.920997883030827975980083799789
             + y*(-303.57865537616441587189378026554
             + 265.63132345414386388790705773235*y)
             + x*(-189.73665961010275991993361266596
             + 132.81566172707193194395352886617*x
             + 531.2626469082877277758141154647*y);
            grad[1]= 37.947331922020551983986722533193
             - 75.89466384404110396797344506639*y
             + x*(-303.57865537616441587189378026554
             + 265.63132345414386388790705773235*x
             + 531.2626469082877277758141154647*y);
            return;
          case ( 9 ):
            grad[0]= 22.449944320643648313502492393899
             + x*(-44.899888641287296627004984787799
             + 22.449944320643648313502492393899*x
             + 179.59955456514918650801993915119*y)
             + y*(-179.59955456514918650801993915119
             + 224.49944320643648313502492393899*y);
            grad[1]= 89.799777282574593254009969575597
             + y*(-448.99888641287296627004984787799
             + 448.99888641287296627004984787799*y)
             + x*(-179.59955456514918650801993915119
             + 89.7997772825745932540099695756*x
             + 448.99888641287296627004984787799*y);
            return;
          #endif
          #if (PMAX2D>=4)
          case ( 10 ):
            grad[0]= -75.894663844041103967973445066385
             + x*(796.89397036243159166372117319705
             + x*(-2125.0505876331509111032564618588
             + 1593.7879407248631833274423463941*x));
            grad[1]= 0;
            return;
          case ( 11 ):
            grad[0]= -120.49896265113654496053335221618
             + 230.04347415216976765192730877634*y
             + x*(1150.2173707608488382596365438817
             - 1840.3477932173581412154184702107*y
             + x*(-2760.521689826037211823127705316
             + 1840.3477932173581412154184702107*x
             + 2760.521689826037211823127705316*y));
            grad[1]= -10.954451150103322269139395656016
             + x*(230.04347415216976765192730877634
             + x*(-920.17389660867907060770923510535
             + 920.1738966086790706077092351053*x));
            return;
          case ( 12 ):
            grad[0]= -127.27922061357855439215198517887
             + (721.24891681027847488886124934695
             - 678.8225099390856234248105876207*y)*y
             + x*(975.80735803743558367316521970469
             + y*(-4412.3463146040565522612688195343
             + 3054.7012947258853054116476442929*y)
             + x*(-1866.7619023324854644182291159568
             + 1018.233764908628435137215881431*x
             + 4582.0519420888279581174714664394*y));
            grad[1]= -42.426406871192851464050661726291
             + 84.85281374238570292810132345258*y
             + x*(721.24891681027847488886124934695
             - 1357.6450198781712468496211752413*y
             + x*(-2206.1731573020282761306344097671
             + 1527.3506473629426527058238221465*x
             + 3054.7012947258853054116476442929*y));
            return;
          case ( 13 ):
            grad[0]= -100.39920318408906575738064309422
             + y*(1104.3912350249797233311870740364
             + y*(-2509.9800796022266439345160773556
             + 1505.9880477613359863607096464133*y))
             + x*(501.99601592044532878690321547111
             + x*(-702.79442228862346030166450165956
             + 301.19760955226719727214192928267*x
             + 2710.778485970404775449277363544*y)
             + y*(-3815.1697209953844987804644375805
             + 4517.96414328400795908212893924*y));
            grad[1]= -100.39920318408906575738064309422
             + (501.99601592044532878690321547111
             - 501.9960159204453287869032154711*y)*y
             + x*(1104.3912350249797233311870740364
             + y*(-5019.9601592044532878690321547111
             + 4517.96414328400795908212893924*y)
             + x*(-1907.5848604976922493902322187902
             + 903.592828656801591816425787848*x
             + 4517.96414328400795908212893924*y));
            return;
          case ( 14 ):
            grad[0]= -37.947331922020551983986722533193
             + y*(569.20997883030827975980083799789
             + y*(-1707.6299364909248392794025139937
             + 1328.1566172707193194395352886617*y))
             + x*(113.84199576606165595196016759958
             + x*(-113.84199576606165595196016759958
             + 37.947331922020551983986722533193*x
             + 569.2099788303082797598008379979*y)
             + y*(-1138.4199576606165595196016759958
             + 1707.6299364909248392794025139937*y));
            grad[1]= -189.73665961010275991993361266596
             + y*(1707.6299364909248392794025139937
             + y*(-3984.4698518121579583186058659852
             + 2656.3132345414386388790705773235*y))
             + x*(569.20997883030827975980083799789
             + x*(-569.20997883030827975980083799789
             + 189.73665961010275991993361266596*x
             + 1707.6299364909248392794025139937*y)
             + y*(-3415.2598729818496785588050279873
             + 3984.4698518121579583186058659852*y));
            return;
          #endif
          #if (PMAX2D>=5)
          case ( 15 ):
            grad[0]= 121.24355652982141054692124390541
             + x*(-1939.8969044771425687507399024866
             + x*(8729.5360701471415593783295611896
             + x*(-14549.226783578569265630549268649
             + 8002.074730968213096096802097757*x)));
            grad[1]= 0;
            return;
          case ( 16 ):
            grad[0]= 198.
             - 384.*y
             + x*(-2976.
             + 5184.*y
             + x*(12528.
             - 17280.*y
             + x*(-19440.
             + 9900.*x
             + 15840.*y)));
            grad[1]= 12.
             + x*(-384.
             + x*(2592.
             + x*(-5760.
             + 3960.*x)));
            return;
          case ( 17 ):
            grad[0]= 224.63303408003017934039739318738
             + y*(-1301.3224043256920734202331743269
             + 1254.8466041712030707980819895295*y)
             + x*(-2943.4673431176368327362417038346
             + (15058.159250054436849576983874354
             - 12548.466041712030707980819895295*y)*y
             + x*(10735.909835686959605716923688197
             + y*(-41828.22013904010235993606631765
             + 23005.521076472056297964836474707*y)
             + x*(-14407.498047891590812866867287191
             + 6390.422521242237860545787909641*x
             + 30674.028101962741730619781966277*y)));
            grad[1]= 46.475800154489002622151184797389
             - 92.95160030897800524430236959478*y
             + x*(-1301.3224043256920734202331743269
             + 2509.693208342406141596163979059*y
             + x*(7529.079625027218424788491937177
             - 12548.466041712030707980819895295*y
             + x*(-13942.740046346700786645355439217
             + 7668.507025490685432654945491569*x
             + 15337.014050981370865309890983138*y)));
            return;
          case ( 18 ):
            grad[0]= 210.79848196796864030305017091149
             + y*(-2419.5999669366835234784889182884
             + (5774.0453756443584083009394640973
             - 3666.0605559646720052704377549824*y)*y)
             + x*(-2162.9757280191564831095582754396
             + y*(21116.508802356510750357721468699
             + y*(-41243.181254602560059292424743552
             + 20163.333057805696028987407652403*y))
             + x*(6213.9726423601190489333919946952
             + x*(-6782.2120285346432097503098467175
             + 2520.4166322257120036234259565504*x
             + 24195.999669366835234784889182884*y)
             + y*(-42892.908504786662461664121733294
             + 45367.499380062816065221667217907*y)));
            grad[1]= 109.98181667894016015811313264947
             + y*(-549.90908339470080079056566324736
             + 549.9090833947008007905656632474*y)
             + x*(-2419.5999669366835234784889182884
             + (11548.090751288716816601878928195
             - 10998.181667894016015811313264947*y)*y
             + x*(10558.254401178255375178860734349
             + y*(-41243.181254602560059292424743552
             + 30244.999586708544043481111478605*y)
             + x*(-14297.636168262220820554707244431
             + 6048.999917341708808696222295721*x
             + 30244.999586708544043481111478605*y)));
            return;
          case ( 19 ):
            grad[0]= 155.88457268119895641747017073553
             + y*(-2909.8453567157138531261098537299
             + y*(12158.996669133518600562673317371
             + y*(-17459.072140294283118756659122379
             + 8002.074730968213096096802097757*y)))
             + x*(-1039.2304845413263761164678049035
             + x*(2182.3840175367853898445823902974
             + x*(-1870.6148721743874770096420488263
             + 571.5767664977295068640572926969*x
             + 9145.228263963672109824916683151*y)
             + y*(-21200.301884643058072775943220032
             + 30865.145390877393370659093805635*y))
             + y*(14964.918977395099816077136390611
             + y*(-43024.142060010911971221767123006
             + 32008.298923872852384387208391029*y)));
            grad[1]= 207.8460969082652752232935609807
             + y*(-1870.6148721743874770096420488263
             + (4364.7680350735707796891647805948
             - 2909.8453567157138531261098537299*y)*y)
             + x*(-2909.8453567157138531261098537299
             + y*(24317.993338267037201125346634742
             + y*(-52377.216420882849356269977367138
             + 32008.298923872852384387208391029*y))
             + x*(7482.4594886975499080385681953054
             + x*(-7066.767294881019357591981073344
             + 2286.3070659909180274562291707878*x
             + 20576.76359391826224710606253709*y)
             + y*(-43024.142060010911971221767123006
             + 48012.448385809278576580812586543*y)));
            return;
          case ( 20 ):
            grad[0]= 57.445626465380286598506114682189
             + y*(-1378.6950351691268783641467523725
             + y*(7238.1489346379161114117704499559
             + y*(-12867.82032824518419806536968881
             + 7238.148934637916111411770449956*y)))
             + x*(-229.78250586152114639402445872876
             + x*(344.67375879228171959103668809314
             + x*(-229.78250586152114639402445872876
             + 57.44562646538028659850611468219*x
             + 1378.6950351691268783641467523725*y)
             + y*(-4136.0851055073806350924402571176
             + 7238.148934637916111411770449956*y))
             + y*(4136.0851055073806350924402571176
             + y*(-14476.297869275832222823540899912
             + 12867.82032824518419806536968881*y)));
            grad[1]= 344.67375879228171959103668809314
             + y*(-4825.4326230919440742745136333039
             + y*(19301.730492367776297098054533216
             + y*(-28952.595738551664445647081799823
             + 14476.297869275832222823540899912*y)))
             + x*(-1378.6950351691268783641467523725
             + x*(2068.0425527536903175462201285588
             + x*(-1378.6950351691268783641467523725
             + 344.67375879228171959103668809314*x
             + 4825.4326230919440742745136333039*y)
             + y*(-14476.297869275832222823540899912
             + 19301.730492367776297098054533216*y))
             + y*(14476.297869275832222823540899912
             + y*(-38603.460984735552594196109066431
             + 28952.595738551664445647081799823*y)));
             return;
          #endif
          #if (PMAX2D>=6)
          case ( 21 ):
            grad[0]= -179.59955456514918650801993915119
             + x*(4040.9899777158566964304486309019
             + x*(-26939.933184772377976202990872679
             + x*(74084.816258124039434558224899868
             + x*(-88901.779509748847321469869879841
             + 38524.104454224500505970276947931*x))));
            grad[1]= 0;
            return;
          case ( 22 ):
            grad[0]= -298.11407212676157062443450206005
             + 583.2666628567074207869370692479*y
             + x*(6415.9332914237816286563077617271
             - 11665.333257134148415738741384958*y
             + x*(-40828.666399969519455085594847354
             + 64159.33291423781628656307761727*y
             + x*(106932.22152372969381093846269545
             - 128318.66582847563257312615523454*y
             + x*(-121902.73253705185094446984747282
             + 50044.27967310549670351920054147*x
             + 83407.13278850916117253200090245*y))));
            grad[1]= -12.961481396815720461931934872176
             + x*(583.26666285670742078693706924792
             + x*(-5832.6666285670742078693706924792
             + x*(21386.44430474593876218769253909
             + x*(-32079.666457118908143281538808636
             + 16681.426557701832234506400180491*x))));
            return;
          case ( 23 ):
            grad[0]= -351.39721114431173015083225082978
             + (2058.1836652738258480263031834316
             - 2007.9840636817813151476128618844*y)*y
             + x*(6877.3454181101010043805740519542
             + y*(-37147.705178112954330230837944862
             + 33131.737050749391699935612221093*y)
             + x*(-39657.685257715180974165354022218
             + (182224.55377912165434964586721601
             - 132526.94820299756679974244888437*y)*y
             + x*(93873.254977123276483150901293098
             + y*(-320273.45815724411976604425147057
             + 143570.86055324736403305431962474*y)
             + x*(-96634.233064685725791478868978189
             + 35892.715138311841008263579906185*x
             + 179463.57569155920504131789953092*y))));
            grad[1]= -50.199601592044532878690321547111
             + 100.39920318408906575738064309422*y
             + x*(2058.1836652738258480263031834316
             - 4015.9681273635626302952257237689*y
             + x*(-18573.852589056477165115418972431
             + 33131.737050749391699935612221093*y
             + x*(60741.517926373884783215289072005
             - 88351.29880199837786649496592292*y
             + x*(-80068.364539311029941511062867642
             + 35892.715138311841008263579906185*x
             + 71785.43027662368201652715981237*y))));
            return;
          case ( 24 ):
            grad[0]= -356.38181771801995229802555850084
             + y*(4157.7878733768994434769648491765
             + y*(-10097.484835343898648444057490857
             + 6533.666658163699125463801905849*y))
             + x*(5939.6969619669992049670926416807
             + y*(-62960.787796850191572651182001816
             + (137206.99982143768163473984002282
             - 78403.99989796438950556562287019*y)*y)
             + x*(-29104.515113638296104338753944236
             + y*(254812.9996683842658930882743281
             + y*(-431221.99943880414228061092578602
             + 169875.33311225617726205884955207*y))
             + x*(58802.999923473292129174217152639
             + x*(-52269.33326530959300371041524679
             + 16987.533311225617726205884955207*x
             + 169875.33311225617726205884955207*y)
             + y*(-365885.33285716715102597290672753
             + 339750.66622451235452411769910414*y))));
            grad[1]= -118.79393923933998409934185283361
             + (593.96969619669992049670926416807
             - 593.9696961966999204967092641681*y)*y
             + x*(4157.7878733768994434769648491765
             + y*(-20194.969670687797296888114981714
             + 19600.999974491097376391405717546*y)
             + x*(-31480.393898425095786325591000908
             + (137206.99982143768163473984002282
             - 117605.99984694658425834843430528*y)*y
             + x*(84937.666556128088631029424776034
             + y*(-287481.33295920276152040728385735
             + 169875.33311225617726205884955207*y)
             + x*(-91471.333214291787756493226681883
             + 33975.066622451235452411769910414*x
             + 169875.33311225617726205884955207*y))));
            return;
          case ( 25 ):
            grad[0]= -314.29922048901107638903489351459
             + y*(6061.4849665737850446456729463528
             + y*(-26266.434855153068526797916100862
             + (39287.402561126384548629361689324
             - 18857.953229340664583342093610875*y)*y))
             + x*(4040.9899777158566964304486309019
             + y*(-68696.829621169563839317626725332
             + y*(256602.86358495690022333348806227
             + y*(-320585.20489879129791681559138488
             + 122576.69599071431979172360847069*y)))
             + x*(-15490.461581244117336316719751791
             + x*(25368.437082327322594257816405106
             + x*(-18857.953229340664583342093610875
             + 5253.286971030613705359583220172*x
             + 87554.78285051022842265972033621*y)
             + y*(-231683.42538904245059534572150504
             + 315197.21826183682232157499321035*y))
             + y*(206763.98719312800096735795494781
             + y*(-545533.64699164065401811056517175
             + 367730.08797214295937517082541207*y))));
            grad[1]= -224.49944320643648313502492393899
             + y*(2020.4949888579283482152243154509
             + y*(-4714.4883073351661458355234027189
             + 3142.9922048901107638903489351459*y))
             + x*(6061.4849665737850446456729463528
             + y*(-52532.869710306137053595832201724
             + (117862.20768337915364588808506797
             - 75431.8129173626583333683744435*y)*y)
             + x*(-34348.414810584781919658813362666
             + y*(256602.86358495690022333348806227
             + y*(-480877.80734818694687522338707732
             + 245153.39198142863958344721694138*y))
             + x*(68921.329064376000322452651649271
             + x*(-57920.85634726061264883643037626
             + 17510.956570102045684531944067241*x
             + 157598.60913091841116078749660517*y)
             + y*(-363689.09799442710267874037678117
             + 367730.08797214295937517082541207*y))));
            return;
          case ( 26 ):
            grad[0]= -223.37412562783541873039835519809
             + y*(6328.9335594553368640279533972792
             + y*(-41696.50345052927816300769297031
             + y*(104241.25862632319540751923242578
             + y*(-109453.32155763935517789519404706
             + 40654.090864266046208932500646052*y))))
             + x*(1861.4510468986284894199862933174
             + y*(-43185.664288048180954543682004964
             + y*(218906.64311527871035579038809413
             + y*(-375268.53105476350346706923673279
             + 203270.45432133023104466250323026*y)))
             + x*(-5212.0629313161597703759616212888
             + x*(6701.2237688350625619119506559427
             + x*(-4095.1923031769826767239698452983
             + 967.9545443872868144983928725251*x
             + 24198.863609682170362459821813126*y)
             + y*(-78925.524388501847951407418836659
             + 135513.63621422015402977500215351*y))
             + y*(91583.391507412521679463325631217
             + y*(-312723.77587896958622255769727733
             + 271027.27242844030805955000430702*y))));
            grad[1]= -372.29020937972569788399725866348
             + y*(5212.0629313161597703759616212888
             + y*(-20848.251725264639081503846485155
             + (31272.377587896958622255769727733
             - 15636.188793948479311127884863866*y)*y))
             + x*(6328.9335594553368640279533972792
             + y*(-83393.00690105855632601538594062
             + y*(312723.77587896958622255769727733
             + y*(-437813.28623055742071158077618826
             + 203270.45432133023104466250323026*y)))
             + x*(-21592.832144024090477271841002482
             + x*(30527.797169137507226487775210406
             + x*(-19731.381097125461987851854709165
             + 4839.7727219364340724919643626253*x
             + 67756.81810711007701488750107675*y)
             + y*(-208482.51725264639081503846485155
             + 271027.27242844030805955000430702*y))
             + y*(218906.64311527871035579038809413
             + y*(-562902.79658214525520060385509919
             + 406540.90864266046208932500646052*y))));
            return;
          case ( 27 ):
            grad[0]= -80.944425379392248793301833668973
             + y*(2833.0548882787287077655641784141
             + y*(-22664.439106229829662124513427313
             + y*(67993.317318689488986373540281938
             + y*(-84991.646648361861232966925352422
             + 37396.324525279218942505447155066*y))))
             + x*(404.72212689696124396650916834487
             + x*(-809.44425379392248793301833668973
             + x*(809.44425379392248793301833668973
             + x*(-404.72212689696124396650916834487
             + 80.94442537939224879330183366897*x
             + 2833.0548882787287077655641784141*y)
             + y*(-11332.219553114914831062256713656
             + 22664.439106229829662124513427313*y))
             + y*(16998.329329672372246593385070484
             + y*(-67993.317318689488986373540281938
             + 67993.31731868948898637354028194*y)))
             + y*(-11332.219553114914831062256713656
             + y*(67993.317318689488986373540281938
             + y*(-135986.63463737897797274708056388
             + 84991.64664836186123296692535242*y))));
            grad[1]= -566.61097765574574155311283568281
             + y*(11332.219553114914831062256713656
             + y*(-67993.317318689488986373540281938
             + y*(169983.29329672372246593385070484
             + y*(-186981.62262639609471252723577533
             + 74792.64905055843788501089431013*y))))
             + x*(2833.0548882787287077655641784141
             + x*(-5666.1097765574574155311283568281
             + x*(5666.1097765574574155311283568281
             + x*(-2833.0548882787287077655641784141
             + 566.6109776557457415531128356828*x
             + 11332.219553114914831062256713656*y)
             + y*(-45328.878212459659324249026854625
             + 67993.31731868948898637354028194*y))
             + y*(67993.317318689488986373540281938
             + y*(-203979.95195606846695912062084581
             + 169983.29329672372246593385070484*y)))
             + y*(-45328.878212459659324249026854625
             + y*(203979.95195606846695912062084581
             + y*(-339966.58659344744493186770140969
             + 186981.62262639609471252723577533*y))));
            return;
          #endif
          #if (PMAX2D>=7)
          case ( 28 ):
            grad[0]= 252.
             + x*(-7560.
             + x*(69300.
             + x*(-277200.
             + x*(540540.
             + x*(-504504.
             + 180180.*x)))));
            grad[1]= 0;
            return;
          case ( 29 ):
            grad[0]= 422.62039704680605962069690732743
             - 831.3843876330611008931742439228*y
             + x*(-12262.919717587651238174320097862
             + 22863.070659909180274562291707878*y
             + x*(108599.58563456860630417088561242
             - 182904.56527927344219649833366302*y
             + x*(-419156.29543166830503364201464442
             + 594439.8371576386871386195844048*y
             + x*(787632.78423387126045867094933638
             - 832215.7720206941619940674181667*y
             + x*(-707383.40621759003769495730544173
             + 242729.60017270246391493633029863*x
             + 416107.88601034708099703370908337*y)))));
            grad[1]= 13.856406460551018348219570732047
             + x*(-831.38438763306110089317424392282
             + x*(11431.535329954590137281145853939
             + x*(-60968.188426424480732166111221007
             + x*(148609.9592894096717846548961012
             + x*(-166443.15440413883239881348363335
             + 69351.3143350578468328389515139*x)))));
            return;
          case ( 30 ):
            grad[0]= 509.82349886995205078129159647073
             + y*(-3005.2753617597173519739294107748
             + 2951.6097302997223992601092427253*y)
             + x*(-13792.067285218702847451783188735
             + (76741.852987792782380762840310857
             - 70838.63352719333758224262182541*y)*y
             + x*(113636.97461653931237151420584492
             + y*(-566709.06821754670065794097460325
             + 460451.11792675669428457704186514*y)
             + x*(-407322.14278136169109789507549609
             + (1.6883207657314412123767824868389e6
             - 1.074385941829098953330679764352e6*y)*y
             + x*(709862.14013708323702205627287543
             + y*(-2.148771883658197906661359528704e6
             + 805789.456371824214998009823264*y)
             + x*(-590912.2680060044243318738703936
             + 188017.5398200923168328689587616*x
             + 966947.3476461890579976117879168*y)))));
            grad[1]= 53.665631459994952713820168049551
             - 107.3312629199899054276403360991*y
             + x*(-3005.2753617597173519739294107748
             + 5903.219460599444798520218485451*y
             + x*(38370.926493896391190381420155429
             - 70838.63352719333758224262182541*y
             + x*(-188903.02273918223355264699153442
             + 306967.41195117112952305136124343*y
             + x*(422080.19143286030309419562170972
             - 537192.970914549476665339882176*y
             + x*(-429754.3767316395813322719057408
             + 161157.8912743648429996019646528*x
             + 322315.7825487296859992039293056*y)))));
            return;
          case ( 31 ):
            grad[0]= 539.73326745717648046232961374241
             + y*(-6349.8031465550174172038778087342
             + (15557.017709059792672149500631399
             - 10159.685034488027867526204493975*y)*y)
             + x*(-13017.096450437785705267949507905
             + y*(143505.55111214339362880763847739
             + y*(-327649.84236223889872772009493069
             + 198113.85817251654341676098763251*y))
             + x*(95405.792276989136693488264076232
             + y*(-929611.18065565454987864771119869
             + (1.8325531880957780266050391356007e6
             - 924531.3381384105359448846089517*y)*y)
             + x*(-304155.57071998533428406574703837
             + y*(2.4103852744322846115705920161955e6
             + y*(-3.5825589352863408267864278596878e6
             + 1.1556641726730131699311057611896e6*y))
             + x*(472584.09918235717127539860591504
             + x*(-352477.57266526901682898725716284
             + 101120.61510888865236897175410409*x
             + 1.0400977554057118529379951850707e6*y)
             + y*(-2.6580275971479302908415432507361e6
             + 2.1668703237618996936208233022306e6*y)))));
            grad[1]= 126.99606293110034834407755617468
             + y*(-634.98031465550174172038778087342
             + 634.9803146555017417203877808734*y)
             + x*(-6349.8031465550174172038778087342
             + (31114.035418119585344299001262798
             - 30479.055103464083602578613481924*y)*y
             + x*(71752.775556071696814403819238697
             + y*(-327649.84236223889872772009493069
             + 297170.78725877481512514148144876*y)
             + x*(-309870.39355188484995954923706623
             + (1.2217021253971853510700260904005e6
             - 924531.3381384105359448846089517*y)*y
             + x*(602596.31860807115289264800404888
             + y*(-1.7912794676431704133932139298439e6
             + 866748.1295047598774483293208922*y)
             + x*(-531605.51942958605816830865014723
             + 173349.62590095197548966586417844*x
             + 866748.1295047598774483293208922*y)))));
            return;
          case ( 32 ):
            grad[0]= 516.
             + y*(-10080.
             + y*(44280.
             + y*(-67200.
             + 32760.*y)))
             + x*(-10440.
             + y*(188640.
             + y*(-760320.
             + (1.04832e6
             - 458640.*y)*y))
             + x*(64260.
             + y*(-1.00224e6
             + y*(3.3696e6
             + y*(-3.66912e6
             + 1.1466e6*y)))
             + x*(-173520.
             + x*(231660.
             + x*(-150696.
             + 38220.*x
             + 655200.*y)
             + y*(-1.9656e6
             + 2.457e6*y))
             + y*(2.13408e6
             + y*(-5.11056e6
             + 3.0576e6*y)))));
            grad[1]= 240.
             + y*(-2160.
             + (5040.
             - 3360.*y)*y)
             + x*(-10080.
             + y*(88560.
             + y*(-201600.
             + 131040.*y))
             + x*(94320.
             + y*(-760320.
             + (1.57248e6
             - 917280.*y)*y)
             + x*(-334080.
             + y*(2.2464e6
             + y*(-3.66912e6
             + 1.5288e6*y))
             + x*(533520.
             + x*(-393120.
             + 109200.*x
             + 982800.*y)
             + y*(-2.55528e6
             + 2.2932e6*y)))));
            return;
          case ( 33 ):
            grad[0]= 437.79447232691278008317112124053
             + y*(-12735.839194964735420601341708815
             + y*(86364.909540854612070952848462905
             + y*(-222877.18591188286986052347990427
             + (242378.93967917262097331928439589
             - 93608.41808299080534141986155979*y)*y)))
             + x*(-6765.9145723250156921944627828082
             + y*(177505.75877982099992463120006662
             + y*(-1.0698104923770377753305127035405e6
             + y*(2.4070736078483349944936535829661e6
             + y*(-2.2231999294710316268587217120451e6
             + 702063.1356224310400606489616985*y))))
             + x*(32436.590449675810524344042164639
             + y*(-706839.07532054281584337446483926
             + y*(3.3431577886782430479078521985641e6
             + y*(-5.3044770247028123026804588217216e6
             + 2.6327367585841164002274336063692e6*y)))
             + x*(-70843.105521991340777094963255286
             + x*(79002.002506265624405917697787496
             + x*(-44018.244217596866797453387281093
             + 9750.876883644875556397902245812*x
             + 250736.8341508682285930889148923*y)
             + y*(-891508.74364753147944209391961708
             + 1.4626315325467313334596853368718e6*y))
             + y*(1.1828410652323498021883496112062e6
             + y*(-3.8223437383887912181079776803582e6
             + 3.1202806027663601780473287186598e6*y)))));
            grad[1]= 397.99497484264798189379192840048
             + y*(-5571.9296477970717465130869976068
             + y*(22287.718591188286986052347990427
             + y*(-33431.577886782430479078521985641
             + 16715.78894339121523953926099282*y)))
             + x*(-12735.839194964735420601341708815
             + y*(172729.81908170922414190569692581
             + y*(-668631.55773564860958157043971281
             + (969515.75871669048389327713758358
             - 468042.09041495402670709930779897*y)*y))
             + x*(88752.879389910499962315600033308
             + y*(-1.0698104923770377753305127035405e6
             + y*(3.6106104117725024917404803744492e6
             + y*(-4.4463998589420632537174434240902e6
             + 1.7551578390560776001516224042461e6*y)))
             + x*(-235613.02510684760528112482161309
             + x*(295710.26630808745054708740280156
             + x*(-178301.74872950629588841878392342
             + 41789.472358478038098848152482051*x
             + 585052.6130186925333838741347487*y)
             + y*(-1.9111718691943956090539888401791e6
             + 2.3402104520747701335354965389948e6*y))
             + y*(2.2287718591188286986052347990427e6
             + y*(-5.3044770247028123026804588217216e6
             + 3.5103156781121552003032448084923e6*y)))));
            return;
          case ( 34 ):
            grad[0]= 302.86630713897510062201458646752
             + y*(-12114.652285559004024880583458701
             + y*(115089.19671281053823636554285766
             + y*(-436127.48228012414489570100451323
             + y*(772309.08320438650658613719549218
             + y*(-639653.64067751541251369480661941
             + 199891.76271172356641052962706856*y)))))
             + x*(-3028.6630713897510062201458646752
             + y*(102974.54442725153421148495939896
             + y*(-799567.05084689426564211850827426
             + y*(2.3260132388273287727770720240706e6
             + y*(-2.816656656392468435784735654148e6
             + 1.1993505762703413984631777624114e6*y))))
             + x*(10600.320749864128521770510526363
             + x*(-18171.978428338506037320875188051
             + x*(16657.646892643630534210802255714
             + x*(-7874.5239856133526161723792481556
             + 1514.3315356948755031100729323376*x
             + 54515.93528501551811196262556415*y)
             + y*(-230178.39342562107647273108571532
             + 454299.46070846265093302187970128*y))
             + y*(375554.22085232912477129808721973
             + y*(-1.4779875788381984910354311819615e6
             + 1.4537582742670804829856700150441e6*y)))
             + y*(-290751.65485341609659713400300882
             + y*(1.7081659722638195675081622676768e6
             + y*(-3.3436440308142851108670410346014e6
             + 2.0443475731880819291985984586558e6*y)))));
            grad[1]= 605.73261427795020124402917293504
             + y*(-12114.652285559004024880583458701
             + y*(72687.913713354024149283500752205
             + y*(-181719.78428338506037320875188051
             + (199891.76271172356641052962706856
             - 79956.70508468942656421185082743*y)*y)))
             + x*(-12114.652285559004024880583458701
             + y*(230178.39342562107647273108571532
             + y*(-1.3083824468403724346871030135397e6
             + y*(3.0892363328175460263445487819687e6
             + y*(-3.198268203387577062568474033097e6
             + 1.1993505762703413984631777624114e6*y))))
             + x*(51487.272213625767105742479699479
             + x*(-96917.218284472032199044667669607
             + x*(93888.555213082281192824521804932
             + x*(-46035.678685124215294546217143063
             + 9085.989214169253018660437594026*x
             + 181719.78428338506037320875188051*y)
             + y*(-738993.78941909924551771559098075
             + 1.0903187057003103622392525112831e6*y))
             + y*(1.1387773148425463783387748451179e6
             + y*(-3.3436440308142851108670410346014e6
             + 2.7257967642507759055981312782077e6*y)))
             + y*(-799567.05084689426564211850827426
             + y*(3.4890198582409931591656080361058e6
             + y*(-5.6333133127849368715694713082959e6
             + 2.9983764406758534961579444060285e6*y)))));
            return;
          case ( 35 ):
            grad[0]= 108.44353369380767278501943119391
             + y*(-5205.2896173027682936809326973075
             + y*(58559.50819465614330391049284471
             + y*(-260264.48086513841468404663486538
             + y*(536795.49178434798028584618440984
             + y*(-515323.67211297406107441233703345
             + 186089.10381857396649909334392874*y)))))
             + x*(-650.66120216284603671011658716344
             + y*(26026.448086513841468404663486538
             + y*(-234238.03277862457321564197137884
             + y*(780793.44259541524405213990459613
             + y*(-1.0735909835686959605716923688197e6
             + 515323.6721129740610744123370334*y))))
             + x*(1626.6530054071150917752914679086
             + x*(-2168.8706738761534557003886238781
             + x*(1626.6530054071150917752914679086
             + x*(-650.66120216284603671011658716344
             + 108.44353369380767278501943119391*x
             + 5205.289617302768293680932697308*y)
             + y*(-26026.448086513841468404663486538
             + 58559.50819465614330391049284471*y))
             + y*(52052.896173027682936809326973075
             + y*(-234238.03277862457321564197137884
             + 260264.48086513841468404663486538*y)))
             + y*(-52052.896173027682936809326973075
             + y*(351357.04916793685982346295706826
             + y*(-780793.44259541524405213990459613
             + 536795.4917843479802858461844098*y)))));
            grad[1]= 867.54826955046138228015544955126
             + y*(-23423.803277862457321564197137884
             + y*(195198.36064885381101303497614903
             + y*(-715727.32237913064038112824587979
             + y*(1.2883091802824351526860308425836e6
             + y*(-1.1165346229114437989945600635725e6
             + 372178.20763714793299818668785749*y)))))
             + x*(-5205.2896173027682936809326973075
             + y*(117119.01638931228660782098568942
             + y*(-780793.44259541524405213990459613
             + y*(2.1471819671373919211433847376394e6
             + y*(-2.5766183605648703053720616851672e6
             + 1.1165346229114437989945600635725e6*y))))
             + x*(13013.224043256920734202331743269
             + x*(-17350.965391009227645603108991025
             + x*(13013.224043256920734202331743269
             + x*(-5205.2896173027682936809326973075
             + 867.5482695504613822801554495513*x
             + 23423.803277862457321564197137884*y)
             + y*(-117119.01638931228660782098568942
             + 195198.36064885381101303497614903*y))
             + y*(234238.03277862457321564197137884
             + y*(-780793.44259541524405213990459613
             + 715727.3223791306403811282458798*y)))
             + y*(-234238.03277862457321564197137884
             + y*(1.1711901638931228660782098568942e6
             + y*(-2.1471819671373919211433847376394e6
             + 1.2883091802824351526860308425836e6*y)))));
            return;
          #endif
          #if (PMAX2D>=8)
          case ( 36 ):
            grad[0]= -339.41125496954281171240529381033
             + x*(13067.333316327398250927603811698
             + x*(-156807.99979592877901113124574037
             + x*(849376.66556128088631029424776034
             + x*(-2.378254663571586481668823893729e6
             + x*(3.5673819953573797225032358405934e6
             + x*(-2.7180053297960988361929415928331e6
             + 825108.7608309585752728572692529*x))))));
            grad[1]= 0;
            return;
          case ( 37 ):
            grad[0]= -573.18059981126367497816447348118
             + 1131.6642611658282813671452425141*y
             + x*(21501.620962150737345975759607768
             - 40739.913401969818129217228730508*y
             + x*(-251229.46597881387846350624383814
             + 441349.06185467302973318664458051*y
             + x*(1.3240471855640190891995599337415e6
             - 2.0596289553218074720882043413757e6*y
             + x*(-3.6043506718131630761543575974075e6
             + 4.6341651494740668121984597680953e6*y
             + x*(5.252053836070609053824921070508e6
             - 4.9431094927723379330116904193017e6*y
             + x*(-3.8838717443211226616520424723085e6
             + 1.1433042364235339436897787364371e6*x
             + 2.000782413741184401457112788765e6*y))))));
            grad[1]= -14.696938456699068589183704448235
             + x*(1131.6642611658282813671452425141
             + x*(-20369.956700984909064608614365254
             + x*(147116.35395155767657772888152684
             + x*(-514907.23883045186802205108534393
             + x*(926833.02989481336243969195361907
             + x*(-823851.58212872298883528173655028
             + 285826.05910588348592244468410928*x))))));
            return;
          case ( 38 ):
            grad[0]= -702.02564055738021170375436686406
             + (4155.2328454612504422465461173846
             - 4098.3118475782196142705660335848*y)*y
             + x*(24950.370738728512929471270065574
             + y*(-141391.75874144857669233452815868
             + 133195.13504629213746379339609151*y)
             + x*(-275839.15574116739237159948609378
             + (1.4429472963348314891910951243246e6
             - 1.2431545937653932829954050301874e6*y)*y
             + x*(1.3738831522367540845802392893142e6
             + y*(-6.3193691849740825218933089034526e6
             + 4.6618297266202248112327688632027e6*y)
             + x*(-3.5309043670142073107300045649072e6
             + (1.3286214720867640712013391260128e7
             - 7.458927562592359697972430181124e6*y)*y
             + x*(4.8534827264923896090278938053566e6
             + y*(-1.3177438693913168799751293319986e7
             + 4.2267256188023371621843771026371e6*y)
             + x*(-3.3841430608057928259319359155101e6
             + 939272.3597338527027076393561416*x
             + 4.9311798886027266892151066197433e6*y))))));
            grad[1]= -56.920997883030827975980083799789
             + 113.84199576606165595196016759958*y
             + x*(4155.2328454612504422465461173846
             - 8196.62369515643922854113206717*y
             + x*(-70695.879370724288346167264079338
             + 133195.13504629213746379339609151*y
             + x*(480982.43211161049639703170810822
             - 828769.7291769288553302700201249*y
             + x*(-1.5798422962435206304733272258631e6
             + 2.3309148633101124056163844316014e6*y
             + x*(2.6572429441735281424026782520255e6
             - 2.9835710250369438791889720724497e6*y
             + x*(-2.1962397823188614666252155533311e6
             + 704454.2698003895270307295171062*x
             + 1.4089085396007790540614590342124e6*y))))));
            return;
          case ( 39 ):
            grad[0]= -763.29810690188404265908474139258
             + y*(9024.8776168987466220280019423475
             + y*(-22225.44487743721183036746746996
             + 14592.463808418371403776620056035*y))
             + x*(24874.53830727316233136076157244
             + y*(-280444.70445348045473227313498459
             + (656660.87137882671316994790252155
             - 408588.98663571439930574536156897*y)*y)
             + x*(-251753.67561169787218761694970519
             + y*(2.6003770506601537841529936939854e6
             + y*(-5.5159513195821443906275623811811e6
             + 3.0644173997678579947930902117673e6*y))
             + x*(1.1469676553416839923368423364043e6
             + y*(-1.0296442463220002862504783111538e7
             + (1.8386504398607147968758541270604e7
             - 8.171779732714287986114907231379e6*y)*y)
             + x*(-2.6966873117957150354179193863552e6
             + y*(1.948969466252357684688405374684e7
             + y*(-2.5741106158050007156261957778845e7
             + 6.946012772807144788197671146672e6*y))
             + x*(3.3953744789427866582307439546381e6
             + x*(-2.1736934089020006043065653235469e6
             + 555681.0218245715830558136917338*x
             + 5.834650729158001622086043763205e6*y)
             + y*(-1.735686015228514768250806295945e7
             + 1.250282299105286061875580806401e7*y))))));
            grad[1]= -134.6996659238618898810149543634
             + (673.49832961930944940507477181698
             - 673.498329619309449405074771817*y)*y
             + x*(9024.8776168987466220280019423475
             + y*(-44450.889754874423660734934939921
             + 43777.391425255114211329860168104*y)
             + x*(-140222.3522267402273661365674923
             + (656660.87137882671316994790252155
             - 612883.4799535715989586180423535*y)*y
             + x*(866792.35022005126138433123132845
             + y*(-3.6773008797214295937517082541207e6
             + 3.0644173997678579947930902117673e6*y)
             + x*(-2.5741106158050007156261957778845e6
             + (9.1932521993035739843792706353018e6
             - 6.128834799535715989586180423535e6*y)*y
             + x*(3.8979389325047153693768107493679e6
             + y*(-1.0296442463220002862504783111538e7
             + 4.1676076636842868729186026880035e6*y)
             + x*(-2.8928100253808579470846771599083e6
             + 833521.5327368573745837205376007*x
             + 4.1676076636842868729186026880035e6*y))))));
            return;
          case ( 40 ):
            grad[0]= -763.67532368147132635291191107324
             + y*(15018.948032402269418273934251107
             + y*(-66439.753160288005392703336263372
             + (101568.81804963568640493728417274
             - 49893.454480522793321723578190118*y)*y))
             + x*(21892.025945535511355450141450766
             + y*(-407802.62284590568827245496051311
             + y*(1.7022322964859995864406406497822e6
             + y*(-2.4447792695456168727644553313158e6
             + 1.1226027258117628497387805092777e6*y)))
             + x*(-194737.20753877518821999253732368
             + y*(3.2830402165066452319911683057038e6
             + y*(-1.2220332529550904164299296400994e7
             + (1.5342237252760758946430000293461e7
             - 5.987214537662735198606829382814e6*y)*y))
             + x*(781239.85612614516685902888502792
             + y*(-1.1247410167180709694525686626287e7
             + y*(3.4319569046245321406299861283631e7
             + y*(-3.2929679957145043592337561605478e7
             + 8.48188726168887486469300829232e6*y)))
             + x*(-1.6251010887941709824789965467638e6
             + x*(1.8228929976276720560044007317318e6
             + x*(-1.0477625440909786597561951419925e6
             + 242339.63604825356756265737978057*x
             + 4.24094363084443743234650414616e6*y)
             + y*(-1.4326549072264402082380627451734e7
             + 1.6357925433257115810479373135189e7*y))
             + y*(1.8442759066907532531422822652419e7
             + y*(-4.0092954493277244633527875331345e7
             + 2.12047181542221871617325207308e7*y))))));
            grad[1]= -254.55844122715710878430397035775
             + y*(2291.0259710444139790587357332197
             + y*(-5345.7272657702992844703833775127
             + 3563.8181771801995229802555850084*y))
             + x*(15018.948032402269418273934251107
             + y*(-132879.50632057601078540667252674
             + (304706.45414890705921481185251822
             - 199573.81792209117328689431276047*y)*y)
             + x*(-203901.31142295284413622748025655
             + y*(1.7022322964859995864406406497822e6
             + y*(-3.6671689043184253091466829969737e6
             + 2.2452054516235256994775610185553e6*y))
             + x*(1.0943467388355484106637227685679e6
             + y*(-8.1468883530339361095328642673293e6
             + (1.5342237252760758946430000293461e7
             - 7.982952716883646931475772510419e6*y)*y)
             + x*(-2.8118525417951774236314216565717e6
             + y*(1.7159784523122660703149930641816e7
             + y*(-2.4697259967858782694253171204108e7
             + 8.48188726168887486469300829232e6*y))
             + x*(3.6885518133815065062845645304837e6
             + x*(-2.3877581787107336803967712419557e6
             + 605849.0901206339189066434494514*x
             + 5.452641811085705270159791045063e6*y)
             + y*(-1.6037181797310897853411150132538e7
             + 1.272283089253331229703951243848e7*y))))));
            return;
          case ( 41 ):
            grad[0]= -703.56236397351443318484451703167
             + y*(20684.733500821324335634428800731
             + y*(-141838.17257706050973006465463358
             + y*(370355.22839565799762850215376547
             + y*(-407784.74615904896547393588207156
             + 159567.94414919307344632273646278*y))))
             + x*(16744.784262569643509799299505354
             + y*(-460974.06087544665662271012755915
             + y*(2.9431420809740055768988415836469e6
             + y*(-7.1076684258060322098065732488607e6
             + (7.1805574867136883050845231408252e6
             - 2.5530871063870891751411637834045e6*y)*y)))
             + x*(-124108.40100492794601380657280439
             + y*(3.0317909388346683954801319927929e6
             + y*(-1.680782345038167040301266157408e7
             + y*(3.4159359895642072759990570990922e7
             + y*(-2.7658443652526799397362607653549e7
             + 7.233746801430085996233297386313e6*y))))
             + x*(419604.59387380400795144126995769
             + y*(-8.5457498977678957112363954416735e6
             + y*(3.7409818017199709441304552659608e7
             + y*(-5.4213701518343128163491379104392e7
             + 2.4112489338100286654110991287709e7*y)))
             + x*(-747605.36795825643670221578379785
             + x*(729875.59638612387298595770196865
             + x*(-370355.22839565799762850215376547
             + 76547.58520031837033051108345305*x
             + 2.0093741115083572211759159406424e6*y)
             + y*(-7.8010994917383280351535560048472e6
             + 1.2056244669050143327055495643855e7*y))
             + y*(1.1745973666537823462020979211844e7
             + y*(-3.5459543144265127432516163658396e7
             + 2.6791654820111429615678879208566e7*y))))));
            grad[1]= -422.137418384108659910906710219
             + y*(5909.923857377521238752693943066
             + y*(-23639.695429510084955010775772264
             + (35459.543144265127432516163658396
             - 17729.771572132563716258081829198*y)*y))
             + x*(20684.733500821324335634428800731
             + y*(-283676.34515412101946012930926717
             + y*(1.1110656851869739928855064612964e6
             + y*(-1.6311389846361958618957435282862e6
             + 797839.7207459653672316136823139*y)))
             + x*(-230487.03043772332831135506377958
             + y*(2.9431420809740055768988415836469e6
             + y*(-1.0661502638709048314709859873291e7
             + (1.436111497342737661016904628165e7
             - 6.382717765967722937852909458511e6*y)*y))
             + x*(1.0105969796115561318267106642643e6
             + y*(-1.1205215633587780268675107716053e7
             + y*(3.4159359895642072759990570990922e7
             + y*(-3.6877924870035732529816810204732e7
             + 1.2056244669050143327055495643855e7*y)))
             + x*(-2.1364374744419739278090988604184e6
             + x*(2.3491947333075646924041958423687e6
             + x*(-1.3001832486230546725255926674745e6
             + 287053.44450119388873941656294892*x
             + 4.0187482230167144423518318812849e6*y)
             + y*(-1.4183817257706050973006465463358e7
             + 1.607499289206685776940732752514e7*y))
             + y*(1.8704909008599854720652276329804e7
             + y*(-4.0660276138757346122618534328294e7
             + 2.4112489338100286654110991287709e7*y))))));
            return;
          case ( 42 ):
            grad[0]= -581.2882245495774706232175484286
             + y*(23771.628972369562877591580796264
             + y*(-231291.52513656871989008024558527
             + y*(899467.04219776724401697873283162
             + y*(-1.638314969717361765888068406229e6
             + (1.3993137270762407553349854857909e6
             - 452303.42693373438556282359136676*y)*y))))
             + x*(10493.782158973951180198085216369
             + y*(-393195.59273216682381313641749496
             + y*(3.4693728770485307983512036837791e6
             + y*(-1.2078557423798588705370857269453e7
             + y*(1.9370665230187630290794220567767e7
             + y*(-1.4247557948412633145228943128053e7
             + 3.8445791289367422772840005266174e6*y)))))
             + x*(-60392.787118992943526854286347266
             + y*(1.9467036698994533924081754003427e6
             + y*(-1.4262977383421737726554948477759e7
             + y*(3.8934073397989067848163508006854e7
             + y*(-4.3945389775948056779115246661202e7
             + 1.7300606080215340247778002369778e7*y))))
             + x*(164902.2910695906614031127676858
             + x*(-245211.84840867702247605729740291
             + x*(204949.99032934839345815443983806
             + x*(-90803.339498060312253142614933478
             + 16643.19969236684968521212349185*x
             + 611637.5886944817259315455383255*y)
             + y*(-2.7446594316206154760289522476119e6
             + 5.242607903095557650841818899933e6*y))
             + y*(4.8860334685100142076779451879889e6
             + y*(-1.8503322010925497591206419646822e7
             + 1.7475359676985192169472729666443e7*y)))
             + y*(-4.3302913317235365890531690423465e6
             + y*(2.4285610139339715588458425786454e7
             + y*(-4.5230342693373438556282359136676e7
             + 2.6213039515477788254209094499664e7*y))))));
            grad[1]= -642.47645871269088858355623773687
             + y*(12849.529174253817771671124754737
             + y*(-77097.175045522906630026748528424
             + y*(192742.93761380726657506687132106
             + y*(-212017.23137518799323257355845317
             + 84806.89255007519729302942338127*y))))
             + x*(23771.628972369562877591580796264
             + y*(-462583.05027313743978016049117055
             + y*(2.6984011265933017320509361984949e6
             + y*(-6.5532598788694470635522736249161e6
             + (6.9965686353812037766749274289545e6
             - 2.7138205616024063133769415482005e6*y)*y)))
             + x*(-196597.79636608341190656820874748
             + y*(3.4693728770485307983512036837791e6
             + y*(-1.811783613569788305805628590418e7
             + y*(3.8741330460375260581588441135533e7
             + y*(-3.5618894871031582863072357820132e7
             + 1.1533737386810226831852001579852e7*y))))
             + x*(648901.22329981779746939180011424
             + x*(-1.0825728329308841472632922605866e6
             + x*(977206.69370200284153558903759778
             + x*(-457443.23860343591267149204126865
             + 87376.79838492596084736364833221*x
             + 1.7475359676985192169472729666443e6*y)
             + y*(-7.4013288043701990364825678587287e6
             + 1.0485215806191115301683637799866e7*y))
             + y*(1.2142805069669857794229212893227e7
             + y*(-3.3922757020030078917211769352507e7
             + 2.6213039515477788254209094499664e7*y)))
             + y*(-9.5086515889478251510366323185057e6
             + y*(3.8934073397989067848163508006854e7
             + y*(-5.8593853034597409038820328881603e7
             + 2.8834343467025567079630003949631e7*y))))));
            return;
          case ( 43 ):
            grad[0]= -394.36024140371960168901824361658
             + y*(21163.999621999618623977312407423
             + y*(-273291.64729277768397048964282629
             + y*(1.4492738871586695362071420452909e6
             + y*(-3.7957173235108011662568005948096e6
             + y*(5.1925412985627759954393032136995e6
             + y*(-3.5527914148061098916163653567417e6
             + 958689.7468524423517060033502319*y))))))
             + x*(4600.8694830433953530385461755267
             + y*(-215320.69180643090252220396101465
             + y*(2.3602460448012618161087741880452e6
             + y*(-1.0213930252356337683745572509669e7
             + y*(2.0496873546958326297786723211972e7
             + y*(-1.913041531049443787793427499784e7
             + 6.710828227967096461942023451623e6*y)))))
             + x*(-19323.651828782260482761893937212
             + x*(41407.825347390558177346915579741
             + x*(-50609.564313477348883424007930794
             + x*(35886.781967738483753700660169109
             + x*(-13802.60844913018605911563852658
             + 2234.7080346210777429044367138273*x
             + 109500.69369643280940231739897754*y)
             + y*(-568667.4681041636656355643072951
             + 1.2670794556301510802268156167401e6*y))
             + y*(1.2008269350743261871430605518125e6
             + y*(-5.3416094698133820048777521097865e6
             + 5.866108590880329075124146373797e6*y)))
             + y*(-1.3066469331843242802629471138496e6
             + y*(8.6956433229520172172428522717455e6
             + y*(-1.9047599659799656761579581166681e7
             + 1.2905438899936723965273122022352e7*y))))
             + y*(759143.46470216023325136011896191
             + y*(-6.708067706277270424730200323918e6
             + y*(2.1946147434116995833993865257263e7
             + y*(-2.9606595123384249096803044639515e7
             + 1.3937874011931661882494971784141e7*y))))));
            grad[1]= -920.17389660867907060770923510535
             + y*(24844.695208434334906408149347844
             + y*(-207039.1267369527908867345778987
             + y*(759143.46470216023325136011896191
             + y*(-1.3664582364638884198524482141314e6
             + (1.1842638049353699638721217855806e6
             - 394754.60164512332129070726186019*y)*y))))
             + x*(21163.999621999618623977312407423
             + y*(-546583.29458555536794097928565258
             + y*(4.3478216614760086086214261358728e6
             + y*(-1.5182869294043204665027202379238e7
             + y*(2.5962706492813879977196516068497e7
             + y*(-2.131674848883665934969819214045e7
             + 6.710828227967096461942023451623e6*y)))))
             + x*(-107660.34590321545126110198050733
             + y*(2.3602460448012618161087741880452e6
             + y*(-1.5320895378534506525618358764504e7
             + y*(4.0993747093916652595573446423943e7
             + y*(-4.78260382762360946948356874946e7
             + 2.013248468390128938582607035487e7*y))))
             + x*(253047.82156738674441712003965397
             + x*(-326661.7332960810700657367784624
             + x*(240165.3870148652374286121103625
             + x*(-94777.911350693944272594051215851
             + 15642.956242347544200331056996791*x
             + 422359.81854338369340893853891335*y)
             + y*(-2.1366437879253528019511008439146e6
             + 3.519665154528197445074487824278e6*y))
             + y*(4.3478216614760086086214261358728e6
             + y*(-1.4285699744849742571184685875011e7
             + 1.2905438899936723965273122022352e7*y)))
             + y*(-4.472045137518180283153466882612e6
             + y*(2.1946147434116995833993865257263e7
             + y*(-3.9475460164512332129070726186019e7
             + 2.3229790019886103137491619640234e7*y))))));
            return;
          case ( 44 ):
            grad[0]= -139.94284547628721130097966906109
             + y*(8816.3992650060943119617191508489
             + y*(-132245.98897509141467942578726273
             + y*(808169.93262555864526315758882782
             + y*(-2.4245097978766759357894727664835e6
             + y*(3.7822352846876144598315775157142e6
             + y*(-2.9417385547570334687578936233333e6
             + 900532.2106399082047218041704081*y))))))
             + x*(979.59991833401047910685768342766
             + y*(-52898.395590036565871770314905094
             + y*(661229.94487545707339712893631367
             + y*(-3.2326797305022345810526303553113e6
             + y*(7.2735293936300278073684182994504e6
             + y*(-7.5644705693752289196631550314284e6
             + 2.9417385547570334687578936233333e6*y)))))
             + x*(-2938.799755002031437320573050283
             + x*(4897.9995916700523955342884171383
             + x*(-4897.9995916700523955342884171383
             + x*(2938.799755002031437320573050283
             + x*(-979.59991833401047910685768342766
             + 139.94284547628721130097966906109*x
             + 8816.399265006094311961719150849*y)
             + y*(-52898.395590036565871770314905094
             + 132245.98897509141467942578726273*y))
             + y*(132245.98897509141467942578726273
             + y*(-661229.94487545707339712893631367
             + 808169.9326255586452631575888278*y)))
             + y*(-176327.98530012188623923438301698
             + y*(1.3224598897509141467942578726273e6
             + y*(-3.2326797305022345810526303553113e6
             + 2.4245097978766759357894727664835e6*y))))
             + y*(132245.98897509141467942578726273
             + y*(-1.3224598897509141467942578726273e6
             + y*(4.8490195957533518715789455329669e6
             + y*(-7.2735293936300278073684182994504e6
             + 3.7822352846876144598315775157142e6*y))))));
            grad[1]= -1259.4856092865849017088170215498
             + y*(44081.996325030471559808595754245
             + y*(-484901.95957533518715789455329669
             + y*(2.4245097978766759357894727664835e6
             + y*(-6.303725474479357433052629192857e6
             + y*(8.8252156642711004062736808699998e6
             + y*(-6.303725474479357433052629192857e6
             + 1.8010644212798164094436083408163e6*y))))))
             + x*(8816.3992650060943119617191508489
             + y*(-264491.97795018282935885157452547
             + y*(2.4245097978766759357894727664835e6
             + y*(-9.6980391915067037431578910659338e6
             + y*(1.8911176423438072299157887578571e7
             + y*(-1.765043132854220081254736174e7
             + 6.303725474479357433052629192857e6*y)))))
             + x*(-26449.197795018282935885157452547
             + x*(44081.996325030471559808595754245
             + x*(-44081.996325030471559808595754245
             + x*(26449.197795018282935885157452547
             + x*(-8816.3992650060943119617191508489
             + 1259.4856092865849017088170215498*x
             + 44081.996325030471559808595754245*y)
             + y*(-264491.97795018282935885157452547
             + 484901.95957533518715789455329669*y))
             + y*(661229.94487545707339712893631367
             + y*(-2.4245097978766759357894727664835e6
             + 2.4245097978766759357894727664835e6*y)))
             + y*(-881639.92650060943119617191508489
             + y*(4.8490195957533518715789455329669e6
             + y*(-9.6980391915067037431578910659338e6
             + 6.303725474479357433052629192857e6*y))))
             + y*(661229.94487545707339712893631367
             + y*(-4.8490195957533518715789455329669e6
             + y*(1.4547058787260055614736836598901e7
             + y*(-1.8911176423438072299157887578571e7
             + 8.82521566427110040627368087e6*y))))));
            return;
          #endif
        }
      }

      /* H\phi_i(x,y) for triangle */
      static void
      hess_triangle_2d ( const int i, DomainType xi, HessianRangeType &h )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];

        switch (i)	{
          #if (PMAX2D>=0)
          case ( 0 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 0;
            return;
          #endif
          #if (PMAX2D>=1)
          case ( 1 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 2 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 0;
            return;
          #endif
          #if (PMAX2D>=2)
          case ( 3 ):
            h[0] = 48.989794855663561963945681494118;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 4 ):
            h[0] = 42.426406871192851464050661726290;
            h[1] = 42.426406871192851464050661726291;
            h[2] = 0;
            return;
          case ( 5 ):
            h[0] = 10.954451150103322269139395656016;
            h[1] = 32.863353450309966807418186968048;
            h[2] = 65.726706900619933614836373936096;
            return;
          #endif
          #if (PMAX2D>=3)
          case ( 6 ):
            h[0] = -254.55844122715710878430397035774+593.96969619669992049670926416808*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 7 ):
            h[0] = -323.33264604737950896204149786118+617.27141518136088074571558682590*x+411.51427678757392049714372455058*y;
            h[1] = -117.57550765359254871346963558588+411.51427678757392049714372455058*x;
            h[2] = 0;
            return;
          case ( 8 ):
            h[0] = -189.73665961010275991993361266596+265.63132345414386388790705773235*x+531.26264690828772777581411546470*y;
            h[1] = -303.57865537616441587189378026554+531.26264690828772777581411546470*y+531.26264690828772777581411546470*x;
            h[2] = -75.894663844041103967973445066386+531.26264690828772777581411546470*x;
            return;
          case ( 9 ):
            h[0] = -44.899888641287296627004984787798+44.899888641287296627004984787798*x+179.5995545651491865080199391512*y;
            h[1] = 179.5995545651491865080199391512*x-179.59955456514918650801993915119+448.99888641287296627004984787798*y;
            h[2] = -448.99888641287296627004984787798+897.99777282574593254009969575596*y+448.99888641287296627004984787798*x;
            return;
          #endif
          #if (PMAX2D>=4)
          case ( 10 ):
            h[0] = 796.89397036243159166372117319704+(-4250.1011752663018222065129237177+4781.3638221745895499823270391822*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 11 ):
            h[0] = 1150.2173707608488382596365438817-1840.3477932173581412154184702106*y+(-5521.0433796520744236462554106321+5521.0433796520744236462554106318*y+5521.0433796520744236462554106320*x)*x;
            h[1] = 230.04347415216976765192730877634+(-1840.3477932173581412154184702106+2760.5216898260372118231277053159*x)*x;
            h[2] = 0;
            return;
          case ( 12 ):
            h[0] = 975.80735803743558367316521970470+(-4412.3463146040565522612688195342+3054.7012947258853054116476442930*y)*y+(-3733.5238046649709288364582319135+9164.1038841776559162349429328790*y+3054.7012947258853054116476442930*x)*x;
            h[1] = -1357.6450198781712468496211752414*y+721.24891681027847488886124934695+(-4412.3463146040565522612688195342+6109.4025894517706108232952885860*y+4582.0519420888279581174714664395*x)*x;
            h[2] = 84.852813742385702928101323452582+x*(-1357.6450198781712468496211752414+3054.7012947258853054116476442930*x);
            return;
          case ( 13 ):
            h[0] = 501.99601592044532878690321547112+(-3815.1697209953844987804644375804+4517.96414328400795908212893924*y)*y+(-1405.5888445772469206033290033191+5421.556971940809550898554727088*y+903.59282865680159181642578784804*x)*x;
            h[1] = 1104.3912350249797233311870740364+(-5019.9601592044532878690321547112+4517.9641432840079590821289392399*y)*y+(-3815.1697209953844987804644375804+9035.92828656801591816425787848*y+2710.778485970404775449277363544*x)*x;
            h[2] = -1003.9920318408906575738064309422*y+501.99601592044532878690321547112+x*(-5019.9601592044532878690321547112+9035.9282865680159181642578784798*y+4517.96414328400795908212893924*x);
            return;
          case ( 14 ):
            h[0] = 113.84199576606165595196016759958+(-1138.4199576606165595196016759958+1707.6299364909248392794025139936*y)*y+(-227.68399153212331190392033519916+1138.4199576606165595196016759958*y+113.84199576606165595196016759958*x)*x;
            h[1] = 569.20997883030827975980083799789+(-3415.2598729818496785588050279874+3984.4698518121579583186058659851*y)*y+(-1138.4199576606165595196016759958+3415.2598729818496785588050279872*y+569.20997883030827975980083799788*x)*x;
            h[2] = 1707.6299364909248392794025139937+(-7968.9397036243159166372117319702+7968.9397036243159166372117319708*y)*y+x*(1707.6299364909248392794025139936*x-3415.2598729818496785588050279874+7968.9397036243159166372117319702*y);
            return;
          #endif
          #if (PMAX2D>=5)
          case ( 15 ):
            h[0] = -1939.8969044771425687507399024866+(17459.072140294283118756659122380+(-43647.680350735707796891647805948+32008.298923872852384387208391028*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 16 ):
            h[0] = -2976.+5184.*y+(25056.-34560.*y+(-58320.+47520.*y+39600.*x)*x)*x;
            h[1] = -384.+(5184.+(-17280.+15840.*x)*x)*x;
            h[2] = 0;
            return;
          case ( 17 ):
            h[0] = -2943.4673431176368327362417038346+(15058.159250054436849576983874354-12548.466041712030707980819895294*y)*y+(21471.819671373919211433847376394+(-83656.440278080204719872132635302+46011.042152944112595929672949414*y)*y+(-43222.494143674772438600601861570+92022.084305888225191859345898828*y+25561.690084968951442183151638564*x)*x)*x;
            h[1] = -1301.3224043256920734202331743269+2509.6932083424061415961639790590*y+(-25096.932083424061415961639790588*y+15058.159250054436849576983874354+(-41828.220139040102359936066317651+46011.042152944112595929672949414*y+30674.028101962741730619781966276*x)*x)*x;
            h[2] = -92.951600308978005244302369594778+x*(2509.6932083424061415961639790590+x*(-12548.466041712030707980819895294+15337.014050981370865309890983138*x));
            return;
          case ( 18 ):
            h[0] = -2162.9757280191564831095582754396+(21116.508802356510750357721468698+(-41243.181254602560059292424743552+20163.333057805696028987407652404*y)*y)*y+(12427.945284720238097866783989391+(-85785.817009573324923328243466586+90734.998760125632130443334435812*y)*y+(-20346.636085603929629250929540152+72587.999008100505704354667548652*y+10081.666528902848014493703826202*x)*x)*x;
            h[1] = -2419.5999669366835234784889182884+(11548.090751288716816601878928195-10998.181667894016015811313264947*y)*y+(21116.508802356510750357721468698+(-82486.362509205120118584849487104+60489.999173417088086962222957212*y)*y+(-42892.908504786662461664121733293+90734.998760125632130443334435812*y+24195.999669366835234784889182884*x)*x)*x;
            h[2] = -549.90908339470080079056566324736+1099.8181667894016015811313264947*y+x*(-21996.363335788032031622626529895*y+11548.090751288716816601878928195+x*(-41243.181254602560059292424743552+60489.999173417088086962222957212*y+30244.999586708544043481111478604*x));
            return;
          case ( 19 ):
            h[0] = -1039.2304845413263761164678049035+(14964.918977395099816077136390611+(-43024.142060010911971221767123006+32008.298923872852384387208391028*y)*y)*y+(4364.7680350735707796891647805947+(-42400.603769286116145551886440064+61730.290781754786741318187611270*y)*y+(-5611.8446165231624310289261464792+27435.684791891016329474750049454*y+2286.3070659909180274562291707878*x)*x)*x;
            h[1] = -2909.8453567157138531261098537299+(24317.993338267037201125346634742+(-52377.216420882849356269977367137+32008.298923872852384387208391028*y)*y)*y+(14964.918977395099816077136390611+(-86048.284120021823942443534246012+96024.896771618557153161625173084*y)*y+(-21200.301884643058072775943220032+61730.290781754786741318187611270*y+9145.2282639636721098249166831512*x)*x)*x;
            h[2] = -1870.6148721743874770096420488263+(8729.5360701471415593783295611894-8729.5360701471415593783295611900*y)*y+(24317.993338267037201125346634742+(-104754.43284176569871253995473427+96024.896771618557153161625173084*y)*y+x*(20576.763593918262247106062537090*x-43024.142060010911971221767123006+96024.896771618557153161625173084*y))*x;
            return;
          case ( 20 ):
            h[0] = -229.78250586152114639402445872876+(4136.0851055073806350924402571176+(-14476.297869275832222823540899912+12867.820328245184198065369688810*y)*y)*y+(689.34751758456343918207337618628+(-8272.1702110147612701848805142350+14476.297869275832222823540899912*y)*y+(-689.34751758456343918207337618628+4136.0851055073806350924402571178*y+229.78250586152114639402445872876*x)*x)*x;
            h[1] = -1378.6950351691268783641467523725+(14476.297869275832222823540899912+(-38603.46098473555259419610906643+28952.595738551664445647081799824*y)*y)*y+(4136.0851055073806350924402571176+(-28952.595738551664445647081799824+38603.460984735552594196109066430*y)*y+(-4136.0851055073806350924402571175+14476.297869275832222823540899912*y+1378.6950351691268783641467523725*x)*x)*x;
            h[2] = -4825.432623091944074274513633304+(38603.460984735552594196109066430+(-86857.787215654993336941245399472+57905.191477103328891294163599647*y)*y)*y+(14476.297869275832222823540899912+(-77206.92196947110518839221813286+86857.787215654993336941245399472*y)*y+x*(4825.432623091944074274513633304*x-14476.297869275832222823540899912+38603.460984735552594196109066430*y))*x;
            return;
          #endif
          #if (PMAX2D>=6)
          case ( 21 ):
            h[0] = 4040.9899777158566964304486309018+(-53879.866369544755952405981745357+(222254.44877437211830367467469960+(-355607.11803899538928587947951937+192620.52227112250252985138473965*x)*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 22 ):
            h[0] = 6415.9332914237816286563077617272-11665.333257134148415738741384958*y+(-81657.332799939038910171189694710+128318.66582847563257312615523454*y+(320796.66457118908143281538808636-384955.99748542689771937846570362*y+(-487610.93014820740377787938989127+333628.53115403664469012800360982*y+250221.39836552748351759600270735*x)*x)*x)*x;
            h[1] = 583.2666628567074207869370692479+(-11665.333257134148415738741384958+(64159.33291423781628656307761727+(-128318.66582847563257312615523454+83407.132788509161172532000902455*x)*x)*x)*x;
            h[2] = 0;
            return;
          case ( 23 ):
            h[0] = 6877.3454181101010043805740519542+(-37147.705178112954330230837944862+33131.737050749391699935612221094*y)*y+(-79315.370515430361948330708044436+(364449.10755824330869929173443203-265053.89640599513359948489776875*y)*y+(281619.76493136982944945270387930+(-960820.37447173235929813275441170+430712.58165974209209916295887422*y)*y+(-386536.93225874290316591547591277+717854.30276623682016527159812371*y+179463.57569155920504131789953092*x)*x)*x)*x;
            h[1] = -4015.9681273635626302952257237688*y+2058.1836652738258480263031834316+(-37147.705178112954330230837944862+66263.474101498783399871224442188*y+(-265053.89640599513359948489776875*y+182224.55377912165434964586721602+(-320273.45815724411976604425147056+287141.72110649472806610863924948*y+179463.57569155920504131789953092*x)*x)*x)*x;
            h[2] = 100.39920318408906575738064309422+x*(-4015.9681273635626302952257237688+x*(33131.737050749391699935612221094+x*(-88351.298801998377866494965922916+71785.430276623682016527159812370*x)));
            return;
          case ( 24 ):
            h[0] = 5939.6969619669992049670926416808+(-62960.787796850191572651182001816+(137206.99982143768163473984002282-78403.999897964389505565622870186*y)*y)*y+(-58209.030227276592208677507888471+(509625.99933676853178617654865620+(-862443.99887760828456122185157202+339750.66622451235452411769910416*y)*y)*y+(176408.99977041987638752265145792+(-1097655.9985715014530779187201826+1019251.9986735370635723530973124*y)*y+(-209077.33306123837201484166098716+679501.33244902470904823539820829*y+84937.666556128088631029424776035*x)*x)*x)*x;
            h[1] = 4157.7878733768994434769648491765+(-20194.969670687797296888114981714+19600.999974491097376391405717547*y)*y+(-62960.787796850191572651182001816+(274413.99964287536326947968004564-235211.99969389316851669686861056*y)*y+(254812.99966838426589308827432810+(-862443.99887760828456122185157202+509625.99933676853178617654865624*y)*y+(-365885.33285716715102597290672753+679501.33244902470904823539820824*y+169875.33311225617726205884955206*x)*x)*x)*x;
            h[2] = -1187.9393923933998409934185283362*y+593.96969619669992049670926416808+x*(-20194.969670687797296888114981714+39201.999948982194752782811435094*y+x*(-235211.99969389316851669686861056*y+137206.99982143768163473984002282+x*(-287481.33295920276152040728385734+339750.66622451235452411769910416*y+169875.33311225617726205884955206*x)));
            return;
          case ( 25 ):
            h[0] = 4040.9899777158566964304486309018+(-68696.829621169563839317626725332+(256602.86358495690022333348806226+(-320585.20489879129791681559138488+122576.69599071431979172360847070*y)*y)*y)*y+(-30980.923162488234672633439503582+(413527.97438625600193471590989563+(-1091067.2939832813080362211303435+735460.17594428591875034165082414*y)*y)*y+(76105.311246981967782773449215318+(-695050.27616712735178603716451512+945591.65478551046696472497963108*y)*y+(-75431.812917362658333368374443500+350219.13140204091369063888134482*y+26266.434855153068526797916100863*x)*x)*x)*x;
            h[1] = 6061.4849665737850446456729463528+(-52532.869710306137053595832201724+(117862.20768337915364588808506797-75431.812917362658333368374443500*y)*y)*y+(-68696.829621169563839317626725332+(513205.72716991380044666697612452+(-961755.61469637389375044677415464+490306.78396285727916689443388280*y)*y)*y+(206763.98719312800096735795494781+(-1091067.2939832813080362211303435+1103190.2639164288781255124762362*y)*y+(-231683.42538904245059534572150504+630394.43652367364464314998642072*y+87554.782850510228422659720336205*x)*x)*x)*x;
            h[2] = 2020.4949888579283482152243154510+(-9428.976614670332291671046805438+9428.9766146703322916710468054380*y)*y+(-52532.869710306137053595832201724+(235724.41536675830729177617013595-226295.43875208797500010512333050*y)*y+(256602.86358495690022333348806226+(-961755.61469637389375044677415464+735460.17594428591875034165082420*y)*y+x*(157598.60913091841116078749660518*x-363689.09799442710267874037678116+735460.17594428591875034165082414*y))*x)*x;
            return;
          case ( 26 ):
            h[0] = 1861.4510468986284894199862933174+(-43185.664288048180954543682004964+(218906.64311527871035579038809412+(-375268.5310547635034670692367328+203270.45432133023104466250323026*y)*y)*y)*y+(-10424.125862632319540751923242577+(183166.78301482504335892665126244+(-625447.55175793917244511539455468+542054.54485688061611910000861402*y)*y)*y+(20103.671306505187685735851967828+(-236776.57316550554385422225650998+406540.90864266046208932500646052*y)*y+(-16380.769212707930706895879381193+96795.454438728681449839287252507*y+4839.7727219364340724919643626252*x)*x)*x)*x;
            h[1] = 6328.9335594553368640279533972792+(-83393.00690105855632601538594062+(312723.77587896958622255769727734+(-437813.28623055742071158077618824+203270.45432133023104466250323026*y)*y)*y)*y+(-43185.664288048180954543682004964+(437813.28623055742071158077618824+(-1125805.5931642905104012077101984+813081.81728532092417865001292104*y)*y)*y+(91583.391507412521679463325631218+(-625447.55175793917244511539455468+813081.81728532092417865001292103*y)*y+(-78925.524388501847951407418836660+271027.27242844030805955000430701*y+24198.863609682170362459821813126*x)*x)*x)*x;
            h[2] = 5212.0629313161597703759616212888+(-41696.503450529278163007692970309+(93817.132763690875866767309183196-62544.755175793917244511539455467*y)*y)*y+(-83393.00690105855632601538594062+(625447.55175793917244511539455468+(-1313439.8586916722621347423285647+813081.81728532092417865001292104*y)*y)*y+(218906.64311527871035579038809412+(-1125805.5931642905104012077101984+1219622.7259279813862679750193816*y)*y+x*(67756.818107110077014887501076754*x-208482.51725264639081503846485156+542054.54485688061611910000861402*y))*x)*x;
            return;
          case ( 27 ):
            h[0] = 404.72212689696124396650916834486+(-11332.219553114914831062256713656+(67993.317318689488986373540281938+(-135986.63463737897797274708056388+84991.646648361861232966925352422*y)*y)*y)*y+(-1618.8885075878449758660366733794+(33996.658659344744493186770140969+(-135986.63463737897797274708056388+135986.63463737897797274708056388*y)*y)*y+(2428.3327613817674637990550100692+(-33996.658659344744493186770140969+67993.317318689488986373540281936*y)*y+(-1618.8885075878449758660366733794+11332.219553114914831062256713656*y+404.72212689696124396650916834488*x)*x)*x)*x;
            h[1] = 2833.0548882787287077655641784141+(-45328.878212459659324249026854626+(203979.95195606846695912062084582+(-339966.58659344744493186770140968+186981.62262639609471252723577534*y)*y)*y)*y+(-11332.219553114914831062256713656+(135986.63463737897797274708056388+(-407959.90391213693391824124169164+339966.58659344744493186770140968*y)*y)*y+(16998.329329672372246593385070484+(-135986.63463737897797274708056388+203979.95195606846695912062084582*y)*y+(-11332.219553114914831062256713656+45328.878212459659324249026854624*y+2833.0548882787287077655641784140*x)*x)*x)*x;
            h[2] = 11332.219553114914831062256713656+(-135986.63463737897797274708056388+(509949.87989017116739780155211452+(-747926.49050558437885010894310131+373963.24525279218942505447155066*y)*y)*y)*y+(-45328.878212459659324249026854626+(407959.90391213693391824124169164+(-1019899.7597803423347956031042290+747926.49050558437885010894310131*y)*y)*y+(67993.317318689488986373540281938+(-407959.90391213693391824124169164+509949.87989017116739780155211452*y)*y+x*(11332.219553114914831062256713656*x-45328.878212459659324249026854626+135986.63463737897797274708056388*y))*x)*x;
            return;
          #endif
          #if (PMAX2D>=7)
          case ( 28 ):
            h[0] = -7560.+(138600.+(-831600.+(2162160.+(-2522520.+1081080.*x)*x)*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 29 ):
            h[0] = -12262.919717587651238174320097862+22863.070659909180274562291707878*y+(217199.17126913721260834177122484-365809.13055854688439299666732606*y+(-1257468.8862950049151009260439333+1783319.5114729160614158587532144*y+(3150531.1369354850418346837973457-3328863.0880827766479762696726670*y+(-3536917.0310879501884747865272086+2080539.4300517354049851685454170*y+1456377.6010362147834896179817918*x)*x)*x)*x)*x;
            h[1] = -831.3843876330611008931742439228+(22863.070659909180274562291707878+(-182904.56527927344219649833366303+(594439.8371576386871386195844048+(-832215.77202069416199406741816675+416107.8860103470809970337090834*x)*x)*x)*x)*x;
            h[2] = 0;
            return;
          case ( 30 ):
            h[0] = -13792.067285218702847451783188735+(76741.852987792782380762840310858-70838.633527193337582242621825406*y)*y+(227273.94923307862474302841168985+(-1133418.1364350934013158819492065+920902.23585351338856915408373026*y)*y+(-1221966.4283440850732936852264882+(5064962.2971943236371303474605166-3223157.825487296859992039293056*y)*y+(2839448.5605483329480882250915018+(-8595087.5346327916266454381148160+3223157.8254872968599920392930560*y)*y+(-2954561.3400300221216593693519680+4834736.7382309452899880589395840*y+1128105.2389205539009972137525696*x)*x)*x)*x)*x;
            h[1] = -3005.2753617597173519739294107748+5903.2194605994447985202184854506*y+(-141677.26705438667516448524365081*y+76741.852987792782380762840310858+(-566709.06821754670065794097460326+920902.23585351338856915408373026*y+(-2148771.883658197906661359528704*y+1688320.7657314412123767824868389+(-2148771.8836581979066613595287040+1611578.9127436484299960196465280*y+966947.3476461890579976117879168*x)*x)*x)*x)*x;
            h[2] = -107.33126291998990542764033609910+x*(5903.2194605994447985202184854506+x*(-70838.633527193337582242621825406+x*(306967.41195117112952305136124342+x*(-537192.970914549476665339882176+322315.7825487296859992039293056*x))));
            return;
          case ( 31 ):
            h[0] = -13017.096450437785705267949507905+(143505.55111214339362880763847739+(-327649.84236223889872772009493068+198113.85817251654341676098763250*y)*y)*y+(190811.58455397827338697652815247+(-1859222.3613113090997572954223974+(3665106.3761915560532100782712014-1849062.6762768210718897692179034*y)*y)*y+(-912466.71215995600285219724111508+(7231155.8232968538347117760485866+(-10747676.805859022480359283579064+3466992.5180190395097933172835689*y)*y)*y+(1890336.3967294286851015944236602+(-10632110.388591721163366173002945+8667481.2950475987744832932089222*y)*y+(-1762387.8633263450841449362858142+5200488.7770285592646899759253532*y+606723.69065333191421383052462454*x)*x)*x)*x)*x;
            h[1] = -6349.8031465550174172038778087342+(31114.035418119585344299001262798-30479.055103464083602578613481925*y)*y+(143505.55111214339362880763847739+(-655299.68472447779745544018986136+594341.57451754963025028296289750*y)*y+(-929611.18065565454987864771119869+(3665106.3761915560532100782712014-2773594.0144152316078346538268551*y)*y+(2410385.2744322846115705920161956+(-7165117.8705726816535728557193756+3466992.5180190395097933172835689*y)*y+(-2658027.5971479302908415432507361+4333740.6475237993872416466044610*y+1040097.7554057118529379951850706*x)*x)*x)*x)*x;
            h[2] = -634.98031465550174172038778087342+1269.9606293110034834407755617468*y+x*(-60958.110206928167205157226963850*y+31114.035418119585344299001262798+x*(-327649.84236223889872772009493068+594341.57451754963025028296289750*y+x*(-1849062.6762768210718897692179034*y+1221702.1253971853510700260904005+x*(-1791279.4676431704133932139298439+1733496.2590095197548966586417844*y+866748.12950475987744832932089222*x))));
            return;
          case ( 32 ):
            h[0] = -10440.+(188640.+(-760320.+(1048320.-458640.*y)*y)*y)*y+(128520.+(-2004480.+(.67392e7+(-.733824e7+2293200.*y)*y)*y)*y+(-520560.+(6402240.+(-.1533168e8+9172800.*y)*y)*y+(926640.+(-7862400.+9828000.*y)*y+(-753480.+3276000.*y+229320.*x)*x)*x)*x)*x;
            h[1] = -10080.+(88560.+(-201600.+131040.*y)*y)*y+(188640.+(-1520640.+(3144960.-1834560.*y)*y)*y+(-1002240.+(.67392e7+(-.1100736e8+4586400.*y)*y)*y+(2134080.+(-.1022112e8+9172800.*y)*y+(-1965600.+4914000.*y+655200.*x)*x)*x)*x)*x;
            h[2] = -2160.+(10080.-10080.*y)*y+(88560.+(-403200.+393120.*y)*y+(-760320.+(3144960.-2751840.*y)*y+(.22464e7+(-.733824e7+4586400.*y)*y+x*(982800.*x-.255528e7+4586400.*y))*x)*x)*x;
            return;
          case ( 33 ):
            h[0] = -6765.9145723250156921944627828082+(177505.75877982099992463120006662+(-1069810.4923770377753305127035405+(2407073.6078483349944936535829662+(-2223199.9294710316268587217120450+702063.13562243104006064896169846*y)*y)*y)*y)*y+(64873.180899351621048688084329276+(-1413678.1506410856316867489296785+(6686315.5773564860958157043971284+(-10608954.049405624605360917643443+5265473.5171682328004548672127386*y)*y)*y)*y+(-212529.31656597402233128488976585+(3548523.1956970494065650488336187+(-11467031.215166373654323933041075+9360841.8082990805341419861559788*y)*y)*y+(316008.01002506249762367079114998+(-3566034.9745901259177683756784684+5850526.1301869253338387413474870*y)*y+(-220091.22108798433398726693640547+1253684.1707543411429654445744615*y+58505.261301869253338387413474871*x)*x)*x)*x)*x;
            h[1] = -12735.839194964735420601341708815+(172729.81908170922414190569692581+(-668631.55773564860958157043971281+(969515.75871669048389327713758356-468042.09041495402670709930779895*y)*y)*y)*y+(177505.75877982099992463120006662+(-2139620.9847540755506610254070810+(7221220.8235450049834809607488986+(-8892799.7178841265074348868481800+3510315.6781121552003032448084923*y)*y)*y)*y+(-706839.07532054281584337446483927+(6686315.5773564860958157043971284+(-15913431.074108436908041376465165+10530947.034336465600909734425477*y)*y)*y+(1182841.0652323498021883496112062+(-7644687.4767775824362159553607164+9360841.8082990805341419861559788*y)*y+(-891508.74364753147944209391961710+2925263.0650934626669193706737435*y+250736.83415086822859308891489230*x)*x)*x)*x)*x;
            h[2] = -5571.9296477970717465130869976068+(44575.437182376573972104695980855+(-100294.73366034729143723556595692+66863.155773564860958157043971280*y)*y)*y+(172729.81908170922414190569692581+(-1337263.1154712972191631408794256+(2908547.2761500714516798314127506-1872168.3616598161068283972311958*y)*y)*y+(-1069810.4923770377753305127035405+(7221220.8235450049834809607488986+(-13339199.576826189761152330272270+7020631.3562243104006064896169847*y)*y)*y+(2228771.8591188286986052347990428+(-10608954.049405624605360917643443+10530947.034336465600909734425477*y)*y+x*(585052.61301869253338387413474870*x-1911171.8691943956090539888401791+4680420.9041495402670709930779894*y))*x)*x)*x;
            return;
          case ( 34 ):
            h[0] = -3028.6630713897510062201458646752+(102974.54442725153421148495939896+(-799567.05084689426564211850827426+(2326013.2388273287727770720240706+(-2816656.656392468435784735654148+1199350.5762703413984631777624114*y)*y)*y)*y)*y+(21200.641499728257043541021052726+(-581503.30970683219319426800601764+(3416331.9445276391350163245353536+(-6687288.0616285702217340820692030+4088695.1463761638583971969173114*y)*y)*y)*y+(-54515.935285015518111962625564154+(1126662.6625569873743138942616592+(-4433962.7365145954731062935458846+4361274.8228012414489570100451324*y)*y)*y+(66630.587570574522136843209022853+(-920713.57370248430589092434286126+1817197.8428338506037320875188052*y)*y+(-39372.619928066763080861896240780+272579.67642507759055981312782078*y+9085.9892141692530186604375940259*x)*x)*x)*x)*x;
            h[1] = -12114.652285559004024880583458701+(230178.39342562107647273108571532+(-1308382.4468403724346871030135397+(3089236.3328175460263445487819688+(-3198268.2033875770625684740330970+1199350.5762703413984631777624114*y)*y)*y)*y)*y+(102974.54442725153421148495939896+(-1599134.1016937885312842370165485+(6978039.7164819863183312160722118+(-11266626.625569873743138942616592+5996752.8813517069923158888120570*y)*y)*y)*y+(-290751.65485341609659713400300882+(3416331.9445276391350163245353536+(-10030932.092442855332601123103804+8177390.2927523277167943938346228*y)*y)*y+(375554.22085232912477129808721972+(-2955975.1576763969820708623639230+4361274.8228012414489570100451323*y)*y+(-230178.39342562107647273108571531+908598.92141692530186604375940260*y+54515.935285015518111962625564156*x)*x)*x)*x)*x;
            h[2] = -12114.652285559004024880583458701+(145375.82742670804829856700150441+(-545159.35285015518111962625564154+(799567.05084689426564211850827427-399783.52542344713282105925413713*y)*y)*y)*y+(230178.39342562107647273108571532+(-2616764.8936807448693742060270794+(9267708.9984526380790336463459064+(-12793072.813550308250273896132388+5996752.8813517069923158888120569*y)*y)*y)*y+(-799567.05084689426564211850827426+(6978039.7164819863183312160722118+(-16899939.938354810614708413924888+11993505.762703413984631777624114*y)*y)*y+(1138777.3148425463783387748451179+(-6687288.0616285702217340820692030+8177390.2927523277167943938346228*y)*y+x*(181719.78428338506037320875188052*x-738993.78941909924551771559098076+2180637.4114006207244785050225662*y))*x)*x)*x;
            return;
          case ( 35 ):
            h[0] = -650.66120216284603671011658716344+(26026.448086513841468404663486538+(-234238.03277862457321564197137884+(780793.44259541524405213990459614+(-1073590.9835686959605716923688197+515323.67211297406107441233703344*y)*y)*y)*y)*y+(3253.3060108142301835505829358173+(-104105.79234605536587361865394615+(702714.09833587371964692591413652+(-1561586.8851908304881042798091923+1073590.9835686959605716923688197*y)*y)*y)*y+(-6506.6120216284603671011658716346+(156158.68851908304881042798091923+(-702714.09833587371964692591413652+780793.44259541524405213990459608*y)*y)*y+(6506.6120216284603671011658716343+(-104105.79234605536587361865394615+234238.03277862457321564197137884*y)*y+(-3253.3060108142301835505829358173+26026.448086513841468404663486539*y+650.66120216284603671011658716346*x)*x)*x)*x)*x;
            h[1] = -5205.2896173027682936809326973075+(117119.01638931228660782098568942+(-780793.44259541524405213990459614+(2147181.9671373919211433847376393+(-2576618.3605648703053720616851672+1116534.6229114437989945600635724*y)*y)*y)*y)*y+(26026.448086513841468404663486538+(-468476.06555724914643128394275768+(2342380.3277862457321564197137884+(-4294363.9342747838422867694752787+2576618.3605648703053720616851672*y)*y)*y)*y+(-52052.896173027682936809326973075+(702714.09833587371964692591413652+(-2342380.3277862457321564197137884+2147181.9671373919211433847376394*y)*y)*y+(52052.896173027682936809326973076+(-468476.06555724914643128394275768+780793.44259541524405213990459608*y)*y+(-26026.448086513841468404663486538+117119.01638931228660782098568942*y+5205.2896173027682936809326973078*x)*x)*x)*x)*x;
            h[2] = -23423.803277862457321564197137884+(390396.72129770762202606995229807+(-2147181.9671373919211433847376394+(5153236.7211297406107441233703343+(-5582673.1145572189949728003178621+2233069.2458228875979891201271448*y)*y)*y)*y)*y+(117119.01638931228660782098568942+(-1561586.8851908304881042798091923+(6441545.9014121757634301542129182+(-10306473.442259481221488246740669+5582673.1145572189949728003178621*y)*y)*y)*y+(-234238.03277862457321564197137884+(2342380.3277862457321564197137884+(-6441545.9014121757634301542129182+5153236.7211297406107441233703343*y)*y)*y+(234238.03277862457321564197137884+(-1561586.8851908304881042798091923+2147181.9671373919211433847376394*y)*y+x*(23423.803277862457321564197137884*x-117119.01638931228660782098568942+390396.72129770762202606995229804*y))*x)*x)*x;
            return;
          #endif
          #if (PMAX2D>=8)
          case ( 36 ):
            h[0] = 13067.333316327398250927603811698+(-313615.99959185755802226249148074+(2548129.9966838426589308827432810+(-9513018.6542863459266752955749160+(17836909.976786898612516179202966+(-16308031.978776593017157649556998+5775761.3258167100269100008847701*x)*x)*x)*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 37 ):
            h[0] = 21501.620962150737345975759607768-40739.913401969818129217228730508*y+(-502458.93195762775692701248767627+882698.12370934605946637328916104*y+(3972141.5566920572675986798012246-6178886.8659654224162646130241268*y+(-14417402.687252652304617430389630+18536660.597896267248793839072382*y+(26260269.180353045269124605352540-24715547.463861689665058452096509*y+(-23303230.465926735969912254833852+12004694.482447106408742676732590*y+8003129.6549647376058284511550599*x)*x)*x)*x)*x)*x;
            h[1] = 1131.6642611658282813671452425141+(-40739.913401969818129217228730508+(441349.06185467302973318664458052+(-2059628.9553218074720882043413756+(4634165.1494740668121984597680955+(-4943109.4927723379330116904193018+2000782.4137411844014571127887650*x)*x)*x)*x)*x)*x;
            h[2] = 0;
            return;
          case ( 38 ):
            h[0] = 24950.370738728512929471270065574+(-141391.75874144857669233452815868+133195.13504629213746379339609150*y)*y+(-551678.31148233478474319897218755+(2885894.5926696629783821902486493-2486309.1875307865659908100603748*y)*y+(4121649.4567102622537407178679426+(-18958107.554922247565679926710357+13985489.179860674433698306589608*y)*y+(-14123617.468056829242920018259629+(53144858.883470562848053565040510-29835710.250369438791889720724498*y)*y+(24267413.632461948045139469026783+(-65887193.469565843998756466599933+21133628.094011685810921885513186*y)*y+(-20304858.364834756955591615493060+29587079.331616360135290639718460*y+6574906.5181369689189534754929912*x)*x)*x)*x)*x)*x;
            h[1] = -8196.6236951564392285411320671696*y+4155.2328454612504422465461173846+(-141391.75874144857669233452815868+266390.27009258427492758679218300*y+(-2486309.1875307865659908100603747*y+1442947.2963348314891910951243247+(-6319369.1849740825218933089034524+9323659.4532404496224655377264056*y+(-14917855.125184719395944860362249*y+13286214.720867640712013391260128+(-13177438.693913168799751293319987+8453451.2376046743243687542052744*y+4931179.8886027266892151066197434*x)*x)*x)*x)*x)*x;
            h[2] = 113.84199576606165595196016759958+x*(-8196.6236951564392285411320671696+x*(133195.13504629213746379339609150+x*(-828769.72917692885533027002012492+x*(2330914.8633101124056163844316014+x*(-2983571.0250369438791889720724498+1408908.5396007790540614590342124*x)))));
            return;
          case ( 39 ):
            h[0] = 24874.53830727316233136076157244+(-280444.7044534804547322731349846+(656660.87137882671316994790252156-408588.98663571439930574536156896*y)*y)*y+(-503507.35122339574437523389941037+(5200754.1013203075683059873879707+(-11031902.639164288781255124762362+6128834.7995357159895861804235344*y)*y)*y+(3440902.9660250519770105270092130+(-30889327.389660008587514349334614+(55159513.195821443906275623811811-24515339.198142863958344721694138*y)*y)*y+(-10786749.247182860141671677545421+(77958778.650094307387536214987358+(-102964424.63220002862504783111538+27784051.091228579152790684586690*y)*y)*y+(16976872.394713933291153719773190+(-86784300.761425738412540314797249+62514114.955264303093779040320051*y)*y+(-13042160.453412003625839391941282+35007904.374948009732516262579228*y+3889767.1527720010813906958421363*x)*x)*x)*x)*x)*x;
            h[1] = 9024.8776168987466220280019423475+(-44450.88975487442366073493493992+43777.391425255114211329860168105*y)*y+(-280444.7044534804547322731349846+(1313321.7427576534263398958050431-1225766.9599071431979172360847069*y)*y+(2600377.0506601537841529936939854+(-11031902.639164288781255124762362+9193252.1993035739843792706353016*y)*y+(-10296442.463220002862504783111538+(36773008.797214295937517082541208-24515339.198142863958344721694137*y)*y+(19489694.662523576846884053746840+(-51482212.316100014312523915557690+20838038.318421434364593013440018*y)*y+(-17356860.152285147682508062959449+25005645.982105721237511616128019*y+5834650.7291580016220860437632049*x)*x)*x)*x)*x)*x;
            h[2] = -1346.9966592386188988101495436339*y+673.49832961930944940507477181698+x*(-44450.88975487442366073493493992+87554.782850510228422659720336210*y+x*(-1225766.9599071431979172360847069*y+656660.87137882671316994790252156+x*(-3677300.8797214295937517082541208+6128834.7995357159895861804235344*y+x*(-12257669.599071431979172360847069*y+9193252.1993035739843792706353018+x*(-10296442.463220002862504783111538+8335215.3273685737458372053760070*y+4167607.6636842868729186026880034*x)))));
            return;
          case ( 40 ):
            h[0] = 21892.025945535511355450141450766+(-407802.62284590568827245496051310+(1702232.2964859995864406406497822+(-2444779.2695456168727644553313158+1122602.7258117628497387805092776*y)*y)*y)*y+(-389474.41507755037643998507464735+(6566080.4330132904639823366114074+(-24440665.059101808328598592801988+(30684474.505521517892860000586923-11974429.075325470397213658765628*y)*y)*y)*y+(2343719.5683784355005770866550838+(-33742230.501542129083577059878860+(102958707.13873596421889958385089+(-98789039.871435130777012684816434+25445661.78506662459407902487696*y)*y)*y)*y+(-6500404.3551766839299159861870553+(73771036.267630130125691290609674+(-160371817.97310897853411150132538+84818872.61688874864693008292320*y)*y)*y+(9114464.9881383602800220036586590+(-71632745.361322010411903137258671+81789627.166285579052396865675945*y)*y+(-6286575.2645458719585371708519547+25445661.785066624594079024876959*y+1696377.4523377749729386016584640*x)*x)*x)*x)*x)*x;
            h[1] = 15018.948032402269418273934251107+(-132879.50632057601078540667252674+(304706.45414890705921481185251822-199573.81792209117328689431276047*y)*y)*y+(-407802.62284590568827245496051310+(3404464.5929719991728812812995644+(-7334337.8086368506182933659939474+4490410.9032470513989551220371104*y)*y)*y+(3283040.2165066452319911683057037+(-24440665.059101808328598592801988+(46026711.758282276839290000880383-23948858.150650940794427317531256*y)*y)*y+(-11247410.167180709694525686626287+(68639138.092490642812599722567262+(-98789039.871435130777012684816434+33927549.04675549945877203316928*y)*y)*y+(18442759.066907532531422822652419+(-80185908.986554489267055750662690+63614154.46266656148519756219240*y)*y+(-14326549.072264402082380627451734+32715850.866514231620958746270378*y+4240943.6308444374323465041461598*x)*x)*x)*x)*x)*x;
            h[2] = 2291.0259710444139790587357332198+(-10691.454531540598568940766755025+10691.454531540598568940766755025*y)*y+(-132879.50632057601078540667252674+(609412.90829781411842962370503644-598721.45376627351986068293828142*y)*y+(1702232.2964859995864406406497822+(-7334337.8086368506182933659939474+6735616.3548705770984326830556656*y)*y+(-8146888.3530339361095328642673292+(30684474.505521517892860000586922-23948858.150650940794427317531256*y)*y+(17159784.523122660703149930641816+(-49394519.935717565388506342408217+25445661.78506662459407902487696*y)*y+x*(5452641.8110857052701597910450630*x-16037181.797310897853411150132538+25445661.78506662459407902487696*y))*x)*x)*x)*x;
            return;
          case ( 41 ):
            h[0] = 16744.784262569643509799299505354+(-460974.06087544665662271012755916+(2943142.0809740055768988415836468+(-7107668.4258060322098065732488608+(7180557.4867136883050845231408252-2553087.1063870891751411637834046*y)*y)*y)*y)*y+(-248216.80200985589202761314560877+(6063581.8776693367909602639855858+(-33615646.900763340806025323148160+(68318719.791284145519981141981846+(-55316887.305053598794725215307098+14467493.602860171992466594772625*y)*y)*y)*y)*y+(1258813.7816214120238543238098730+(-25637249.693303687133709186325021+(112229454.05159912832391365797882+(-162641104.55502938449047413731318+72337468.014300859962332973863124*y)*y)*y)*y+(-2990421.4718330257468088631351915+(46983894.666151293848083916847374+(-141838172.57706050973006465463358+107166619.28044571846271551683426*y)*y)*y+(3649377.9819306193649297885098435+(-39005497.458691640175767780024235+60281223.345250716635277478219272*y)*y+(-2222131.3703739479857710129225928+12056244.669050143327055495643854*y+535833.09640222859231357758417133*x)*x)*x)*x)*x)*x;
            h[1] = 20684.733500821324335634428800731+(-283676.34515412101946012930926716+(1111065.6851869739928855064612964+(-1631138.9846361958618957435282863+797839.72074596536723161368231390*y)*y)*y)*y+(-460974.06087544665662271012755916+(5886284.1619480111537976831672936+(-21323005.277418096629419719746583+(28722229.946854753220338092563301-12765435.531935445875705818917023*y)*y)*y)*y+(3031790.9388346683954801319927929+(-33615646.900763340806025323148160+(102478079.68692621827997171297277+(-110633774.61010719758945043061420+36168734.007150429981166486931564*y)*y)*y)*y+(-8545749.8977678957112363954416736+(74819636.034399418882609105319216+(-162641104.55502938449047413731317+96449957.352401146616443965150832*y)*y)*y+(11745973.666537823462020979211844+(-70919086.288530254865032327316792+80374964.460334288847036637625695*y)*y+(-7801099.4917383280351535560048470+24112489.338100286654110991287709*y+2009374.1115083572211759159406424*x)*x)*x)*x)*x)*x;
            h[2] = 5909.923857377521238752693943066+(-47279.390859020169910021551544527+(106378.62943279538229754849097519-70919.086288530254865032327316791*y)*y)*y+(-283676.34515412101946012930926716+(2222131.3703739479857710129225928+(-4893416.9539085875856872305848586+3191358.8829838614689264547292556*y)*y)*y+(2943142.0809740055768988415836468+(-21323005.277418096629419719746583+(43083344.920282129830507138844950-25530871.063870891751411637834046*y)*y)*y+(-11205215.633587780268675107716053+(68318719.791284145519981141981846+(-110633774.61010719758945043061420+48224978.676200573308221982575417*y)*y)*y+(18704909.008599854720652276329804+(-81320552.277514692245237068656588+72337468.014300859962332973863124*y)*y+x*(4018748.2230167144423518318812848*x-14183817.257706050973006465463358+32149985.784133715538814655050278*y))*x)*x)*x)*x;
            return;
          case ( 42 ):
            h[0] = 10493.782158973951180198085216369+(-393195.59273216682381313641749496+(3469372.8770485307983512036837792+(-12078557.423798588705370857269453+(19370665.230187630290794220567767+(-14247557.948412633145228943128053+3844579.1289367422772840005266174*y)*y)*y)*y)*y)*y+(-120785.57423798588705370857269453+(3893407.3397989067848163508006854+(-28525954.766843475453109896955517+(77868146.795978135696327016013710+(-87890779.551896113558230493322406+34601212.160430680495556004739556*y)*y)*y)*y)*y+(494706.87320877198420933830305740+(-12990873.995170609767159507127039+(72856830.418019146765375277359361+(-135691028.08012031566884707741003+78639118.546433364762627283498992*y)*y)*y)*y+(-980847.39363470808990422918961160+(19544133.874040056830711780751956+(-74013288.043701990364825678587288+69901438.707940768677890918665772*y)*y)*y+(1024749.9516467419672907721991903+(-13723297.158103077380144761238060+26213039.515477788254209094499663*y)*y+(-544820.03698836187351885568960087+3669825.5321668903555892732299528*y+116502.39784656794779648486444295*x)*x)*x)*x)*x)*x;
            h[1] = 23771.628972369562877591580796264+(-462583.05027313743978016049117054+(2698401.1265933017320509361984948+(-6553259.878869447063552273624916+(6996568.6353812037766749274289545-2713820.5616024063133769415482007*y)*y)*y)*y)*y+(-393195.59273216682381313641749496+(6938745.7540970615967024073675584+(-36235672.271395766116112571808359+(77482660.920750521163176882271067+(-71237789.742063165726144715640263+23067474.773620453663704003159704*y)*y)*y)*y)*y+(1946703.6698994533924081754003427+(-28525954.766843475453109896955516+(116802220.19396720354449052402056+(-175781559.10379222711646098664481+86503030.401076701238890011848890*y)*y)*y)*y+(-4330291.3317235365890531690423464+(48571220.278679431176916851572908+(-135691028.08012031566884707741003+104852158.06191115301683637799866*y)*y)*y+(4886033.4685100142076779451879890+(-37006644.021850995182412839293644+52426079.030955576508418188999329*y)*y+(-2744659.4316206154760289522476118+10485215.806191115301683637799865*y+611637.58869448172593154553832547*x)*x)*x)*x)*x)*x;
            h[2] = 12849.529174253817771671124754737+(-154194.35009104581326005349705685+(578228.81284142179972520061396318+(-848068.92550075197293029423381267+424034.46275037598646514711690633*y)*y)*y)*y+(-462583.05027313743978016049117054+(5396802.2531866034641018723969896+(-19659779.636608341190656820874748+(27986274.541524815106699709715818-13569102.808012031566884707741003*y)*y)*y)*y+(3469372.8770485307983512036837792+(-36235672.271395766116112571808359+(116223991.38112578174476532340660+(-142475579.48412633145228943128053+57668686.934051134159260007899260*y)*y)*y)*y+(-9508651.5889478251510366323185056+(77868146.795978135696327016013710+(-175781559.10379222711646098664481+115337373.86810226831852001579852*y)*y)*y+(12142805.069669857794229212893227+(-67845514.040060157834423538705014+78639118.546433364762627283498992*y)*y+x*(1747535.9676985192169472729666442*x-7401328.8043701990364825678587288+20970431.612382230603367275599731*y))*x)*x)*x)*x;
            return;
          case ( 43 ):
            h[0] = 4600.8694830433953530385461755268+(-215320.69180643090252220396101466+(2360246.0448012618161087741880452+(-10213930.252356337683745572509669+(20496873.546958326297786723211972+(-19130415.310494437877934274997840+6710828.2279670964619420234516232*y)*y)*y)*y)*y)*y+(-38647.303657564520965523787874425+(1518286.9294043204665027202379238+(-13416135.412554540849460400647836+(43892294.868233991667987730514525+(-59213190.246768498193606089279029+27875748.023863323764989943568281*y)*y)*y)*y)*y+(124223.47604217167453204074673922+(-3919940.7995529728407888413415488+(26086929.968856051651728556815237+(-57142798.979398970284738743500042+38716316.699810171895819366067057*y)*y)*y)*y+(-202438.25725390939553369603172318+(4803307.7402973047485722422072500+(-21366437.879253528019511008439146+23464434.363521316300496585495186*y)*y)*y+(179433.90983869241876850330084555+(-2843337.3405208183281778215364755+6335397.2781507554011340780837004*y)*y+(-82815.650694781116354693831159481+657004.16217859685641390439386522*y+15642.956242347544200331056996791*x)*x)*x)*x)*x)*x;
            h[1] = 21163.999621999618623977312407423+(-546583.29458555536794097928565258+(4347821.6614760086086214261358727+(-15182869.294043204665027202379239+(25962706.492813879977196516068498+(-21316748.488836659349698192140451+6710828.2279670964619420234516233*y)*y)*y)*y)*y)*y+(-215320.69180643090252220396101466+(4720492.0896025236322175483760904+(-30641790.757069013051236717529007+(81987494.187833305191146892847888+(-95652076.552472189389671374989200+40264969.367802578771652140709741*y)*y)*y)*y)*y+(759143.46470216023325136011896191+(-13416135.412554540849460400647836+(65838442.302350987501981595771787+(-118426380.49353699638721217855806+69689370.059658309412474858920705*y)*y)*y)*y+(-1306646.9331843242802629471138496+(17391286.645904034434485704543491+(-57142798.979398970284738743500043+51621755.599746895861092488089409*y)*y)*y+(1200826.9350743261871430605518125+(-10683218.939626764009755504219573+17598325.772640987225372439121390*y)*y+(-568667.46810416366563556430729510+2534158.9112603021604536312334803*y+109500.69369643280940231739897754*x)*x)*x)*x)*x)*x;
            h[2] = 24844.695208434334906408149347844+(-414078.25347390558177346915579740+(2277430.3941064806997540803568858+(-5465832.9458555536794097928565259+(5921319.0246768498193606089279030-2368527.6098707399277442435711611*y)*y)*y)*y)*y+(-546583.29458555536794097928565258+(8695643.3229520172172428522717454+(-45548607.882129613995081607137714+(103850825.97125551990878606427399+(-106583742.44418329674849096070225+40264969.367802578771652140709740*y)*y)*y)*y)*y+(2360246.0448012618161087741880452+(-30641790.757069013051236717529007+(122981241.28174995778672033927183+(-191304153.10494437877934274997840+100662423.41950644692913035177435*y)*y)*y)*y+(-4472045.137518180283153466882612+(43892294.868233991667987730514525+(-118426380.49353699638721217855806+92919160.079544412549966478560940*y)*y)*y+(4347821.6614760086086214261358728+(-28571399.489699485142369371750021+38716316.699810171895819366067056*y)*y+x*(422359.81854338369340893853891336*x-2136643.7879253528019511008439146+7039330.3090563948901489756485558*y))*x)*x)*x)*x;
            return;
          case ( 44 ):
            h[0] = 979.59991833401047910685768342766+(-52898.395590036565871770314905094+(661229.94487545707339712893631366+(-3232679.7305022345810526303553112+(7273529.3936300278073684182994504+(-7564470.5693752289196631550314284+2941738.5547570334687578936233332*y)*y)*y)*y)*y)*y+(-5877.5995100040628746411461005659+(264491.97795018282935885157452547+(-2644919.7795018282935885157452547+(9698039.1915067037431578910659336+(-14547058.787260055614736836598901+7564470.5693752289196631550314284*y)*y)*y)*y)*y+(14693.998775010157186602865251415+(-528983.95590036565871770314905094+(3967379.6692527424403827736178820+(-9698039.1915067037431578910659338+7273529.3936300278073684182994508*y)*y)*y)*y+(-19591.998366680209582137153668553+(528983.95590036565871770314905094+(-2644919.7795018282935885157452546+3232679.7305022345810526303553112*y)*y)*y+(14693.998775010157186602865251415+(-264491.97795018282935885157452547+661229.94487545707339712893631366*y)*y+(-5877.5995100040628746411461005658+52898.395590036565871770314905091*y+979.59991833401047910685768342765*x)*x)*x)*x)*x)*x;
            h[1] = 8816.3992650060943119617191508489+(-264491.97795018282935885157452546+(2424509.7978766759357894727664834+(-9698039.1915067037431578910659340+(18911176.423438072299157887578571+(-17650431.328542200812547361739999+6303725.4744793574330526291928567*y)*y)*y)*y)*y)*y+(-52898.395590036565871770314905094+(1322459.8897509141467942578726273+(-9698039.1915067037431578910659336+(29094117.574520111229473673197802+(-37822352.846876144598315775157142+17650431.328542200812547361739999*y)*y)*y)*y)*y+(132245.98897509141467942578726274+(-2644919.7795018282935885157452548+(14547058.787260055614736836598900+(-29094117.574520111229473673197802+18911176.423438072299157887578571*y)*y)*y)*y+(-176327.98530012188623923438301698+(2644919.7795018282935885157452546+(-9698039.1915067037431578910659337+9698039.1915067037431578910659344*y)*y)*y+(132245.98897509141467942578726274+(-1322459.8897509141467942578726273+2424509.7978766759357894727664834*y)*y+(-52898.395590036565871770314905094+264491.97795018282935885157452545*y+8816.3992650060943119617191508486*x)*x)*x)*x)*x)*x;
            h[2] = 44081.996325030471559808595754244+(-969803.91915067037431578910659336+(7273529.3936300278073684182994502+(-25214901.897917429732210516771428+(44126078.321355502031368404349998+(-37822352.846876144598315775157142+12607450.948958714866105258385714*y)*y)*y)*y)*y)*y+(-264491.97795018282935885157452546+(4849019.5957533518715789455329668+(-29094117.574520111229473673197802+(75644705.693752289196631550314284+(-88252156.642711004062736808700000+37822352.846876144598315775157140*y)*y)*y)*y)*y+(661229.94487545707339712893631366+(-9698039.1915067037431578910659336+(43641176.361780166844210509796702+(-75644705.693752289196631550314284+44126078.321355502031368404349998*y)*y)*y)*y+(-881639.92650060943119617191508490+(9698039.1915067037431578910659336+(-29094117.574520111229473673197802+25214901.897917429732210516771428*y)*y)*y+(661229.94487545707339712893631366+(-4849019.5957533518715789455329668+7273529.3936300278073684182994508*y)*y+x*(44081.996325030471559808595754244*x-264491.97795018282935885157452546+969803.91915067037431578910659336*y))*x)*x)*x)*x;
            return;
          #endif
        }
        printf("Error in hess_triangle_2d -- unmatched switch/case %d\n",i);
      }

      /* \phi_i(x,y) for quadrilateral */
      static RangeField
      eval_quadrilateral_2d ( const int i, DomainType xi )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];

        switch (i)	{
          #if (PMAX2D>=0)
          case ( 0 ):
            return 1.;
          #endif
          #if (PMAX2D>=1)
          case ( 1 ):
            return -1.7320508075688772935274463415059
             + 3.4641016151377545870548926830117*x;
          case ( 2 ):
            return -1.7320508075688772935274463415059
             + 3.4641016151377545870548926830117*y;
          #endif
          #if (PMAX2D>=2)
          case ( 3 ):
            return 2.2360679774997896964091736687313
             + x*(-13.416407864998738178455042012388
             + 13.416407864998738178455042012388*x);
          case ( 4 ):
            return 3.
             - 6.*y
             + x*(-6.
             + 12.*y);
          case ( 5 ):
            return 2.2360679774997896964091736687313
             + y*(-13.416407864998738178455042012388
             + 13.416407864998738178455042012388*y);
          #endif
          #if (PMAX2D>=3)
          case ( 6 ):
            return -2.6457513110645905905016157536393
             + x*(31.749015732775087086019389043671
             + x*(-79.372539331937717715048472609178
             + 52.91502622129181181003231507279*x));
          case ( 7 ):
            return -3.8729833462074168851792653997824
             + 7.745966692414833770358530799565*y
             + x*(23.237900077244501311075592398694
             - 46.475800154489002622151184797389*y
             + x*(-23.237900077244501311075592398694
             + 46.475800154489002622151184797389*y));
          case ( 8 ):
            return -3.8729833462074168851792653997824
             + (23.237900077244501311075592398694
             - 23.237900077244501311075592398694*y)*y
             + x*(7.7459666924148337703585307995648
             + y*(-46.475800154489002622151184797389
             + 46.475800154489002622151184797389*y));
          case ( 9 ):
            return -2.6457513110645905905016157536393
             + y*(31.749015732775087086019389043671
             + y*(-79.372539331937717715048472609178
             + 52.91502622129181181003231507279*y));
          #endif
          #if (PMAX2D>=4)
          case ( 10 ):
            return 3.
             + x*(-60.
             + x*(270.
             + x*(-420.
             + 210.*x)));
          case ( 11 ):
            return 4.582575694955840006588047193728
             - 9.165151389911680013176094387456*y
             + x*(-54.990908339470080079056566324736
             + 109.98181667894016015811313264947*y
             + x*(137.47727084867520019764141581184
             - 274.95454169735040039528283162368*y
             + x*(-91.65151389911680013176094387456
             + 183.30302779823360026352188774912*y)));
          case ( 12 ):
            return 5.
             + y*(-30.
             + 30.*y)
             + x*(-30.
             + (180.
             - 180.*y)*y
             + x*(30.
             + y*(-180.
             + 180.*y)));
          case ( 13 ):
            return 4.582575694955840006588047193728
             + y*(-54.990908339470080079056566324736
             + (137.47727084867520019764141581184
             - 91.65151389911680013176094387456*y)*y)
             + x*(-9.165151389911680013176094387456
             + y*(109.98181667894016015811313264947
             + y*(-274.95454169735040039528283162368
             + 183.30302779823360026352188774912*y)));
          case ( 14 ):
            return 3.
             + y*(-60.
             + y*(270.
             + y*(-420.
             + 210.*y)));
          #endif
          #if (PMAX2D>=5)
          case ( 15 ):
            return -3.3166247903553998491149327366707
             + x*(99.498743710661995473447982100121
             + x*(-696.49120597463396831413587470084
             + x*(1857.3098825990239155043623325356
             + x*(-2089.4736179239019049424076241025
             + 835.789447169560761976963049641*x))));
          case ( 16 ):
            return -5.1961524227066318805823390245176
             + 10.392304845413263761164678049035*y
             + x*(103.92304845413263761164678049035
             - 207.8460969082652752232935609807*y
             + x*(-467.65371804359686925241051220659
             + 935.3074360871937385048210244132*y
             + x*(727.46133917892846328152746343247
             - 1454.9226783578569265630549268649*y
             + x*(-363.73066958946423164076373171623
             + 727.4613391789284632815274634325*y))));
          case ( 17 ):
            return -5.9160797830996160425673282915616
             + (35.49647869859769625540396974937
             - 35.49647869859769625540396974937*y)*y
             + x*(70.992957397195392510807939498739
             + y*(-425.95774438317235506484763699244
             + 425.95774438317235506484763699244*y)
             + x*(-177.48239349298848127701984874685
             + (1064.8943609579308876621190924811
             - 1064.8943609579308876621190924811*y)*y
             + x*(118.32159566199232085134656583123
             + y*(-709.92957397195392510807939498739
             + 709.9295739719539251080793949874*y))));
          case ( 18 ):
            return -5.9160797830996160425673282915616
             + y*(70.992957397195392510807939498739
             + y*(-177.48239349298848127701984874685
             + 118.32159566199232085134656583123*y))
             + x*(35.49647869859769625540396974937
             + y*(-425.95774438317235506484763699244
             + (1064.8943609579308876621190924811
             - 709.9295739719539251080793949874*y)*y)
             + x*(-35.49647869859769625540396974937
             + y*(425.95774438317235506484763699244
             + y*(-1064.8943609579308876621190924811
             + 709.9295739719539251080793949874*y))));
          case ( 19 ):
            return -5.1961524227066318805823390245176
             + y*(103.92304845413263761164678049035
             + y*(-467.65371804359686925241051220659
             + (727.46133917892846328152746343247
             - 363.73066958946423164076373171623*y)*y))
             + x*(10.392304845413263761164678049035
             + y*(-207.8460969082652752232935609807
             + y*(935.30743608719373850482102441317
             + y*(-1454.9226783578569265630549268649
             + 727.4613391789284632815274634325*y))));
          case ( 20 ):
            return -3.3166247903553998491149327366707
             + y*(99.498743710661995473447982100121
             + y*(-696.49120597463396831413587470084
             + y*(1857.3098825990239155043623325356
             + y*(-2089.4736179239019049424076241025
             + 835.789447169560761976963049641*y))));
          #endif
          #if (PMAX2D>=6)
          case ( 21 ):
            return 3.6055512754639892931192212674705
             + x*(-151.43315356948755031100729323376
             + x*(1514.3315356948755031100729323376
             + x*(-6057.3261427795020124402917293504
             + x*(11357.486517711566273325546992532
             + x*(-9994.5881355861783205264813534282
             + 3331.5293785287261068421604511427*x)))));
          case ( 22 ):
            return 5.7445626465380286598506114682189
             - 11.489125293076057319701222936438*y
             + x*(-172.33687939614085979551834404657
             + 344.67375879228171959103668809314*y
             + x*(1206.358155772986018568628408326
             - 2412.716311545972037137256816652*y
             + x*(-3216.9550820612960495163424222026
             + 6433.910164122592099032684844405*y
             + x*(3619.0744673189580557058852249779
             - 7238.148934637916111411770449956*y
             + x*(-1447.6297869275832222823540899912
             + 2895.2595738551664445647081799823*y)))));
          case ( 23 ):
            return 6.7082039324993690892275210061938
             + y*(-40.249223594996214535365126037163
             + 40.249223594996214535365126037163*y)
             + x*(-134.16407864998738178455042012388
             + (804.98447189992429070730252074326
             - 804.9844718999242907073025207433*y)*y
             + x*(603.73835392494321803047689055744
             + y*(-3622.4301235496593081828613433447
             + 3622.4301235496593081828613433447*y)
             + x*(-939.14855054991167249185294086714
             + (5634.8913032994700349511176452028
             - 5634.891303299470034951117645203*y)*y
             + x*(469.57427527495583624592647043357
             + y*(-2817.4456516497350174755588226014
             + 2817.4456516497350174755588226014*y)))));
          case ( 24 ):
            return 7.
             + y*(-84.
             + (210.
             - 140.*y)*y)
             + x*(-84.
             + y*(1008.
             + y*(-2520.
             + 1680.*y))
             + x*(210.
             + y*(-2520.
             + (6300.
             - 4200.*y)*y)
             + x*(-140.
             + y*(1680.
             + y*(-4200.
             + 2800.*y)))));
          case ( 25 ):
            return 6.7082039324993690892275210061938
             + y*(-134.16407864998738178455042012388
             + y*(603.73835392494321803047689055744
             + y*(-939.14855054991167249185294086714
             + 469.57427527495583624592647043357*y)))
             + x*(-40.249223594996214535365126037163
             + y*(804.98447189992429070730252074326
             + y*(-3622.4301235496593081828613433447
             + (5634.8913032994700349511176452028
             - 2817.4456516497350174755588226014*y)*y))
             + x*(40.249223594996214535365126037163
             + y*(-804.98447189992429070730252074326
             + y*(3622.4301235496593081828613433447
             + y*(-5634.8913032994700349511176452028
             + 2817.4456516497350174755588226014*y)))));
          case ( 26 ):
            return 5.7445626465380286598506114682189
             + y*(-172.33687939614085979551834404657
             + y*(1206.358155772986018568628408326
             + y*(-3216.9550820612960495163424222026
             + (3619.0744673189580557058852249779
             - 1447.6297869275832222823540899912*y)*y)))
             + x*(-11.489125293076057319701222936438
             + y*(344.67375879228171959103668809314
             + y*(-2412.716311545972037137256816652
             + y*(6433.9101641225920990326848444052
             + y*(-7238.1489346379161114117704499559
             + 2895.2595738551664445647081799823*y)))));
          case ( 27 ):
            return 3.6055512754639892931192212674705
             + y*(-151.43315356948755031100729323376
             + y*(1514.3315356948755031100729323376
             + y*(-6057.3261427795020124402917293504
             + y*(11357.486517711566273325546992532
             + y*(-9994.5881355861783205264813534282
             + 3331.5293785287261068421604511427*y)))));
          #endif
          #if (PMAX2D>=7)
          case ( 28 ):
            return -3.8729833462074168851792653997824
             + x*(216.88706738761534557003886238781
             + x*(-2927.9754097328071651955246422355
             + x*(16266.530054071150917752914679086
             + x*(-44732.957648695665023820515367487
             + x*(64415.459014121757634301542129181
             + x*(-46522.275954643491624773335982186
             + 13292.078844183854749935238852053*x))))));
          case ( 29 ):
            return -6.2449979983983982058468931209398
             + 12.48999599679679641169378624188*y
             + x*(262.28991593273272464556951107947
             - 524.5798318654654492911390221589*y
             + x*(-2622.8991593273272464556951107947
             + 5245.798318654654492911390221589*y
             + x*(10491.596637309308985822780443179
             - 20983.193274618617971645560886358*y
             + x*(-19671.74369495495434841771333096
             + 39343.487389909908696835426661921*y
             + x*(17311.134451560359826607587731245
             - 34622.26890312071965321517546249*y
             + x*(-5770.3781505201199422025292437484
             + 11540.756301040239884405058487497*y))))));
          case ( 30 ):
            return -7.4161984870956629487113974408007
             + (44.497190922573977692268384644804
             - 44.497190922573977692268384644804*y)*y
             + x*(222.48595461286988846134192322402
             + y*(-1334.9157276772193307680515393441
             + 1334.9157276772193307680515393441*y)
             + x*(-1557.4016822900892192293934625681
             + (9344.4100937405353153763607754089
             - 9344.410093740535315376360775409*y)*y
             + x*(4153.0711527735712512783825668484
             + y*(-24918.42691664142750767029540109
             + 24918.42691664142750767029540109*y)
             + x*(-4672.2050468702676576881803877044
             + (28033.230281221605946129082326227
             - 28033.230281221605946129082326227*y)*y
             + x*(1868.8820187481070630752721550818
             + y*(-11213.292112488642378451632930491
             + 11213.292112488642378451632930491*y))))));
          case ( 31 ):
            return -7.9372539331937717715048472609178
             + y*(95.247047198325261258058167131013
             + y*(-238.11761799581315314514541782753
             + 158.74507866387543543009694521836*y))
             + x*(158.74507866387543543009694521836
             + y*(-1904.9409439665052251611633426203
             + (4762.3523599162630629029083565507
             - 3174.9015732775087086019389043671*y)*y)
             + x*(-714.3528539874394594354362534826
             + y*(8572.2342478492735132252350417912
             + y*(-21430.585619623183783063087604478
             + 14287.057079748789188708725069652*y))
             + x*(1111.2155506471280480106786165285
             + y*(-13334.586607765536576128143398342
             + (33336.466519413841440320358495855
             - 22224.31101294256096021357233057*y)*y)
             + x*(-555.60777532356402400533930826424
             + y*(6667.2933038827682880640716991709
             + y*(-16668.233259706920720160179247927
             + 11112.155506471280480106786165285*y))))));
          case ( 32 ):
            return -7.9372539331937717715048472609178
             + y*(158.74507866387543543009694521836
             + y*(-714.3528539874394594354362534826
             + (1111.2155506471280480106786165285
             - 555.6077753235640240053393082642*y)*y))
             + x*(95.247047198325261258058167131013
             + y*(-1904.9409439665052251611633426203
             + y*(8572.2342478492735132252350417912
             + y*(-13334.586607765536576128143398342
             + 6667.293303882768288064071699171*y)))
             + x*(-238.11761799581315314514541782753
             + y*(4762.3523599162630629029083565507
             + y*(-21430.585619623183783063087604478
             + (33336.466519413841440320358495855
             - 16668.233259706920720160179247927*y)*y))
             + x*(158.74507866387543543009694521836
             + y*(-3174.9015732775087086019389043671
             + y*(14287.057079748789188708725069652
             + y*(-22224.31101294256096021357233057
             + 11112.155506471280480106786165285*y))))));
          case ( 33 ):
            return -7.4161984870956629487113974408007
             + y*(222.48595461286988846134192322402
             + y*(-1557.4016822900892192293934625681
             + y*(4153.0711527735712512783825668484
             + y*(-4672.2050468702676576881803877044
             + 1868.8820187481070630752721550818*y))))
             + x*(44.497190922573977692268384644804
             + y*(-1334.9157276772193307680515393441
             + y*(9344.4100937405353153763607754089
             + y*(-24918.42691664142750767029540109
             + (28033.230281221605946129082326227
             - 11213.292112488642378451632930491*y)*y)))
             + x*(-44.497190922573977692268384644804
             + y*(1334.9157276772193307680515393441
             + y*(-9344.4100937405353153763607754089
             + y*(24918.42691664142750767029540109
             + y*(-28033.230281221605946129082326227
             + 11213.292112488642378451632930491*y))))));
          case ( 34 ):
            return -6.2449979983983982058468931209398
             + y*(262.28991593273272464556951107947
             + y*(-2622.8991593273272464556951107947
             + y*(10491.596637309308985822780443179
             + y*(-19671.74369495495434841771333096
             + (17311.134451560359826607587731245
             - 5770.378150520119942202529243748*y)*y))))
             + x*(12.48999599679679641169378624188
             + y*(-524.57983186546544929113902215894
             + y*(5245.7983186546544929113902215894
             + y*(-20983.193274618617971645560886358
             + y*(39343.487389909908696835426661921
             + y*(-34622.26890312071965321517546249
             + 11540.756301040239884405058487497*y))))));
          case ( 35 ):
            return -3.8729833462074168851792653997824
             + y*(216.88706738761534557003886238781
             + y*(-2927.9754097328071651955246422355
             + y*(16266.530054071150917752914679086
             + y*(-44732.957648695665023820515367487
             + y*(64415.459014121757634301542129181
             + y*(-46522.275954643491624773335982186
             + 13292.078844183854749935238852053*y))))));
          #endif
          #if (PMAX2D>=8)
          case ( 36 ):
            return 4.1231056256176605498214098559741
             + x*(-296.86360504447155958714150963013
             + x*(5195.1130882782522927749764185273
             + x*(-38097.4959807071834803498270692
             + x*(142865.6099276519380513118515095
             + x*(-297160.46864951603114672865113976
             + x*(346687.21342443536967118342632972
             + x*(-212257.47760679716510480617938555
             + 53064.36940169929127620154484639*x)))))));
          case ( 37 ):
            return 6.7082039324993690892275210061938
             - 13.416407864998738178455042012388*y
             + x*(-375.65942021996466899674117634685
             + 751.3188404399293379934823526937*y
             + x*(5071.4021729695230314560058806825
             - 10142.804345939046062912011761365*y
             + x*(-28174.456516497350174755588226014
             + 56348.91303299470034951117645203*y
             + x*(77479.755420367712980577867621539
             - 154959.51084073542596115573524308*y
             + x*(-111570.84780532950669203212937502
             + 223141.69561065901338406425875003*y
             + x*(80578.9456371824214998009823264
             - 161157.8912743648429996019646528*y
             + x*(-23022.555896337834714228852093257
             + 46045.111792675669428457704186514*y)))))));
          case ( 38 ):
            return 8.0622577482985496523666132303038
             + y*(-48.373546489791297914199679381823
             + 48.373546489791297914199679381823*y)
             + x*(-338.61482542853908539939775567276
             + (2031.6889525712345123963865340366
             - 2031.6889525712345123963865340366*y)*y
             + x*(3386.1482542853908539939775567276
             + y*(-20316.889525712345123963865340366
             + 20316.889525712345123963865340366*y)
             + x*(-13544.59301714156341597591022691
             + (81267.558102849380495855461361462
             - 81267.55810284938049585546136146*y)*y
             + x*(25396.111907140431404954831675457
             + y*(-152376.67144284258842972899005274
             + 152376.67144284258842972899005274*y)
             + x*(-22348.578478283579636360251874402
             + (134091.47086970147781816151124641
             - 134091.47086970147781816151124641*y)*y
             + x*(7449.5261594278598787867506248007
             + y*(-44697.156956567159272720503748804
             + 44697.156956567159272720503748804*y)))))));
          case ( 39 ):
            return 8.7749643873921220604063883074163
             + y*(-105.299572648705464724876659689
             + (263.24893162176366181219164922249
             - 175.49928774784244120812776614833*y)*y)
             + x*(-263.24893162176366181219164922249
             + y*(3158.9871794611639417462997906699
             + y*(-7897.4679486529098543657494766747
             + 5264.97863243527323624383298445*y))
             + x*(1842.7425213523456326853415445574
             + y*(-22112.910256228147592224098534689
             + (55282.275640570368980560246336723
             - 36854.850427046912653706830891149*y)*y)
             + x*(-4913.9800569395883538275774521531
             + y*(58967.760683275060245930929425838
             + y*(-147419.40170818765061482732356459
             + 98279.60113879176707655154904306*y))
             + x*(5528.2275640570368980560246336723
             + y*(-66338.730768684442776672295604067
             + (165846.82692171110694168073901017
             - 110564.55128114073796112049267345*y)*y)
             + x*(-2211.2910256228147592224098534689
             + y*(26535.492307473777110668918241627
             + y*(-66338.730768684442776672295604067
             + 44225.820512456295184448197069378*y)))))));
          case ( 40 ):
            return 9.
             + y*(-180.
             + y*(810.
             + y*(-1260.
             + 630.*y)))
             + x*(-180.
             + y*(3600.
             + y*(-16200.
             + (25200.
             - 12600.*y)*y))
             + x*(810.
             + y*(-16200.
             + y*(72900.
             + y*(-113400.
             + 56700.*y)))
             + x*(-1260.
             + y*(25200.
             + y*(-113400.
             + (176400.
             - 88200.*y)*y))
             + x*(630.
             + y*(-12600.
             + y*(56700.
             + y*(-88200.
             + 44100.*y)))))));
          case ( 41 ):
            return 8.7749643873921220604063883074163
             + y*(-263.24893162176366181219164922249
             + y*(1842.7425213523456326853415445574
             + y*(-4913.9800569395883538275774521531
             + (5528.2275640570368980560246336723
             - 2211.2910256228147592224098534689*y)*y)))
             + x*(-105.299572648705464724876659689
             + y*(3158.9871794611639417462997906699
             + y*(-22112.910256228147592224098534689
             + y*(58967.760683275060245930929425838
             + y*(-66338.730768684442776672295604067
             + 26535.492307473777110668918241627*y))))
             + x*(263.24893162176366181219164922249
             + y*(-7897.4679486529098543657494766747
             + y*(55282.275640570368980560246336723
             + y*(-147419.40170818765061482732356459
             + (165846.82692171110694168073901017
             - 66338.73076868444277667229560407*y)*y)))
             + x*(-175.49928774784244120812776614833
             + y*(5264.9786324352732362438329844498
             + y*(-36854.850427046912653706830891149
             + y*(98279.601138791767076551549043063
             + y*(-110564.55128114073796112049267345
             + 44225.820512456295184448197069378*y)))))));
          case ( 42 ):
            return 8.0622577482985496523666132303038
             + y*(-338.61482542853908539939775567276
             + y*(3386.1482542853908539939775567276
             + y*(-13544.59301714156341597591022691
             + y*(25396.111907140431404954831675457
             + y*(-22348.578478283579636360251874402
             + 7449.526159427859878786750624801*y)))))
             + x*(-48.373546489791297914199679381823
             + y*(2031.6889525712345123963865340366
             + y*(-20316.889525712345123963865340366
             + y*(81267.558102849380495855461361462
             + y*(-152376.67144284258842972899005274
             + (134091.47086970147781816151124641
             - 44697.156956567159272720503748804*y)*y))))
             + x*(48.373546489791297914199679381823
             + y*(-2031.6889525712345123963865340366
             + y*(20316.889525712345123963865340366
             + y*(-81267.558102849380495855461361462
             + y*(152376.67144284258842972899005274
             + y*(-134091.47086970147781816151124641
             + 44697.156956567159272720503748804*y)))))));
          case ( 43 ):
            return 6.7082039324993690892275210061938
             + y*(-375.65942021996466899674117634685
             + y*(5071.4021729695230314560058806825
             + y*(-28174.456516497350174755588226014
             + y*(77479.755420367712980577867621539
             + y*(-111570.84780532950669203212937502
             + (80578.9456371824214998009823264
             - 23022.555896337834714228852093257*y)*y)))))
             + x*(-13.416407864998738178455042012388
             + y*(751.31884043992933799348235269371
             + y*(-10142.804345939046062912011761365
             + y*(56348.913032994700349511176452028
             + y*(-154959.51084073542596115573524308
             + y*(223141.69561065901338406425875003
             + y*(-161157.8912743648429996019646528
             + 46045.111792675669428457704186514*y)))))));
          case ( 44 ):
            return 4.1231056256176605498214098559741
             + y*(-296.86360504447155958714150963013
             + y*(5195.1130882782522927749764185273
             + y*(-38097.4959807071834803498270692
             + y*(142865.6099276519380513118515095
             + y*(-297160.46864951603114672865113976
             + y*(346687.21342443536967118342632972
             + y*(-212257.47760679716510480617938555
             + 53064.36940169929127620154484639*y)))))));
          #endif
        }

        printf("Error in eval_quadrilateral_2d -- unmatched switch/case %d\n",i);
        return -123456789.0;
      }


      /* \nabla\phi_i(x,y) for quadrilateral */
      static void
      grad_quadrilateral_2d ( const int i, DomainType xi, JacobianRangeType grad )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];

        switch (i)	{
          #if (PMAX2D>=0)
          case ( 0 ):
            grad[0]= 0;
            grad[1]= 0;
            return;
          #endif
          #if (PMAX2D>=1)
          case ( 1 ):
            grad[0]= 3.4641016151377545870548926830117;
            grad[1]= 0;
            return;
          case ( 2 ):
            grad[0]= 0;
            grad[1]= 3.4641016151377545870548926830117;
            return;
          #endif
          #if (PMAX2D>=2)
          case ( 3 ):
            grad[0]= -13.416407864998738178455042012388
             + 26.832815729997476356910084024775*x;
            grad[1]= 0;
            return;
          case ( 4 ):
            grad[0]= -6.
             + 12.*y;
            grad[1]= -6.
             + 12.*x;
            return;
          case ( 5 ):
            grad[0]= 0;
            grad[1]= -13.416407864998738178455042012388
             + 26.832815729997476356910084024775*y;
            return;
          #endif
          #if (PMAX2D>=3)
          case ( 6 ):
            grad[0]= 31.749015732775087086019389043671
             + x*(-158.74507866387543543009694521836
             + 158.74507866387543543009694521836*x);
            grad[1]= 0;
            return;
          case ( 7 ):
            grad[0]= 23.237900077244501311075592398694
             - 46.475800154489002622151184797389*y
             + x*(-46.475800154489002622151184797389
             + 92.95160030897800524430236959478*y);
            grad[1]= 7.7459666924148337703585307995648
             + x*(-46.475800154489002622151184797389
             + 46.475800154489002622151184797389*x);
            return;
          case ( 8 ):
            grad[0]= 7.7459666924148337703585307995648
             + y*(-46.475800154489002622151184797389
             + 46.475800154489002622151184797389*y);
            grad[1]= 23.237900077244501311075592398694
             - 46.475800154489002622151184797389*y
             + x*(-46.475800154489002622151184797389
             + 92.95160030897800524430236959478*y);
            return;
          case ( 9 ):
            grad[0]= 0;
            grad[1]= 31.749015732775087086019389043671
             + y*(-158.74507866387543543009694521836
             + 158.74507866387543543009694521836*y);
            return;
          #endif
          #if (PMAX2D>=4)
          case ( 10 ):
            grad[0]= -60.
             + x*(540.
             + x*(-1260.
             + 840.*x));
            grad[1]= 0;
            return;
          case ( 11 ):
            grad[0]= -54.990908339470080079056566324736
             + 109.98181667894016015811313264947*y
             + x*(274.95454169735040039528283162368
             - 549.9090833947008007905656632474*y
             + x*(-274.95454169735040039528283162368
             + 549.9090833947008007905656632474*y));
            grad[1]= -9.165151389911680013176094387456
             + x*(109.98181667894016015811313264947
             + x*(-274.95454169735040039528283162368
             + 183.30302779823360026352188774912*x));
            return;
          case ( 12 ):
            grad[0]= -30.
             + (180.
             - 180.*y)*y
             + x*(60.
             + y*(-360.
             + 360.*y));
            grad[1]= -30.
             + 60.*y
             + x*(180.
             - 360.*y
             + x*(-180.
             + 360.*y));
            return;
          case ( 13 ):
            grad[0]= -9.165151389911680013176094387456
             + y*(109.98181667894016015811313264947
             + y*(-274.95454169735040039528283162368
             + 183.30302779823360026352188774912*y));
            grad[1]= -54.990908339470080079056566324736
             + (274.95454169735040039528283162368
             - 274.95454169735040039528283162368*y)*y
             + x*(109.98181667894016015811313264947
             + y*(-549.90908339470080079056566324736
             + 549.9090833947008007905656632474*y));
            return;
          case ( 14 ):
            grad[0]= 0;
            grad[1]= -60.
             + y*(540.
             + y*(-1260.
             + 840.*y));
            return;
          #endif
          #if (PMAX2D>=5)
            return;
          case ( 15 ):
            grad[0]= 99.498743710661995473447982100121
             + x*(-1392.9824119492679366282717494017
             + x*(5571.9296477970717465130869976068
             + x*(-8357.8944716956076197696304964101
             + 4178.9472358478038098848152482051*x)));
            grad[1]= 0;
            return;
          case ( 16 ):
            grad[0]= 103.92304845413263761164678049035
             - 207.8460969082652752232935609807*y
             + x*(-935.30743608719373850482102441317
             + 1870.6148721743874770096420488263*y
             + x*(2182.3840175367853898445823902974
             - 4364.7680350735707796891647805948*y
             + x*(-1454.9226783578569265630549268649
             + 2909.8453567157138531261098537299*y)));
            grad[1]= 10.392304845413263761164678049035
             + x*(-207.8460969082652752232935609807
             + x*(935.30743608719373850482102441317
             + x*(-1454.9226783578569265630549268649
             + 727.4613391789284632815274634325*x)));
            return;
          case ( 17 ):
            grad[0]= 70.992957397195392510807939498739
             + y*(-425.95774438317235506484763699244
             + 425.95774438317235506484763699244*y)
             + x*(-354.9647869859769625540396974937
             + (2129.7887219158617753242381849622
             - 2129.7887219158617753242381849622*y)*y
             + x*(354.9647869859769625540396974937
             + y*(-2129.7887219158617753242381849622
             + 2129.7887219158617753242381849622*y)));
            grad[1]= 35.49647869859769625540396974937
             - 70.99295739719539251080793949874*y
             + x*(-425.95774438317235506484763699244
             + 851.9154887663447101296952739849*y
             + x*(1064.8943609579308876621190924811
             - 2129.7887219158617753242381849622*y
             + x*(-709.92957397195392510807939498739
             + 1419.8591479439078502161587899748*y)));
            return;
          case ( 18 ):
            grad[0]= 35.49647869859769625540396974937
             + y*(-425.95774438317235506484763699244
             + (1064.8943609579308876621190924811
             - 709.9295739719539251080793949874*y)*y)
             + x*(-70.992957397195392510807939498739
             + y*(851.91548876634471012969527398487
             + y*(-2129.7887219158617753242381849622
             + 1419.8591479439078502161587899748*y)));
            grad[1]= 70.992957397195392510807939498739
             + y*(-354.9647869859769625540396974937
             + 354.9647869859769625540396974937*y)
             + x*(-425.95774438317235506484763699244
             + (2129.7887219158617753242381849622
             - 2129.7887219158617753242381849622*y)*y
             + x*(425.95774438317235506484763699244
             + y*(-2129.7887219158617753242381849622
             + 2129.7887219158617753242381849622*y)));
            return;
          case ( 19 ):
            grad[0]= 10.392304845413263761164678049035
             + y*(-207.8460969082652752232935609807
             + y*(935.30743608719373850482102441317
             + y*(-1454.9226783578569265630549268649
             + 727.4613391789284632815274634325*y)));
            grad[1]= 103.92304845413263761164678049035
             + y*(-935.30743608719373850482102441317
             + (2182.3840175367853898445823902974
             - 1454.9226783578569265630549268649*y)*y)
             + x*(-207.8460969082652752232935609807
             + y*(1870.6148721743874770096420488263
             + y*(-4364.7680350735707796891647805948
             + 2909.8453567157138531261098537299*y)));
            return;
          case ( 20 ):
            grad[0]= 0;
            grad[1]= 99.498743710661995473447982100121
             + y*(-1392.9824119492679366282717494017
             + y*(5571.9296477970717465130869976068
             + y*(-8357.8944716956076197696304964101
             + 4178.9472358478038098848152482051*y)));
            return;
          #endif
          #if (PMAX2D>=6)
          case ( 21 ):
            grad[0]= -151.43315356948755031100729323376
             + x*(3028.6630713897510062201458646752
             + x*(-18171.978428338506037320875188051
             + x*(45429.946070846265093302187970128
             + x*(-49972.940677930891602632406767141
             + 19989.176271172356641052962706856*x))));
            grad[1]= 0;
            return;
          case ( 22 ):
            grad[0]= -172.33687939614085979551834404657
             + 344.67375879228171959103668809314*y
             + x*(2412.716311545972037137256816652
             - 4825.4326230919440742745136333039*y
             + x*(-9650.8652461838881485490272666078
             + 19301.730492367776297098054533216*y
             + x*(14476.297869275832222823540899912
             - 28952.595738551664445647081799823*y
             + x*(-7238.1489346379161114117704499559
             + 14476.297869275832222823540899912*y))));
            grad[1]= -11.489125293076057319701222936438
             + x*(344.67375879228171959103668809314
             + x*(-2412.716311545972037137256816652
             + x*(6433.9101641225920990326848444052
             + x*(-7238.1489346379161114117704499559
             + 2895.2595738551664445647081799823*x))));
            return;
          case ( 23 ):
            grad[0]= -134.16407864998738178455042012388
             + (804.98447189992429070730252074326
             - 804.9844718999242907073025207433*y)*y
             + x*(1207.4767078498864360609537811149
             + y*(-7244.8602470993186163657226866893
             + 7244.860247099318616365722686689*y)
             + x*(-2817.4456516497350174755588226014
             + (16904.673909898410104853352935608
             - 16904.673909898410104853352935608*y)*y
             + x*(1878.2971010998233449837058817343
             + y*(-11269.782606598940069902235290406
             + 11269.782606598940069902235290406*y))));
            grad[1]= -40.249223594996214535365126037163
             + 80.49844718999242907073025207433*y
             + x*(804.98447189992429070730252074326
             - 1609.9689437998485814146050414865*y
             + x*(-3622.4301235496593081828613433447
             + 7244.860247099318616365722686689*y
             + x*(5634.8913032994700349511176452028
             - 11269.782606598940069902235290406*y
             + x*(-2817.4456516497350174755588226014
             + 5634.891303299470034951117645203*y))));
            return;
          case ( 24 ):
            grad[0]= -84.
             + y*(1008.
             + y*(-2520.
             + 1680.*y))
             + x*(420.
             + y*(-5040.
             + (12600.
             - 8400.*y)*y)
             + x*(-420.
             + y*(5040.
             + y*(-12600.
             + 8400.*y))));
            grad[1]= -84.
             + (420.
             - 420.*y)*y
             + x*(1008.
             + y*(-5040.
             + 5040.*y)
             + x*(-2520.
             + (12600.
             - 12600.*y)*y
             + x*(1680.
             + y*(-8400.
             + 8400.*y))));
            return;
          case ( 25 ):
            grad[0]= -40.249223594996214535365126037163
             + y*(804.98447189992429070730252074326
             + y*(-3622.4301235496593081828613433447
             + (5634.8913032994700349511176452028
             - 2817.4456516497350174755588226014*y)*y))
             + x*(80.498447189992429070730252074326
             + y*(-1609.9689437998485814146050414865
             + y*(7244.8602470993186163657226866893
             + y*(-11269.782606598940069902235290406
             + 5634.891303299470034951117645203*y))));
            grad[1]= -134.16407864998738178455042012388
             + y*(1207.4767078498864360609537811149
             + y*(-2817.4456516497350174755588226014
             + 1878.2971010998233449837058817343*y))
             + x*(804.98447189992429070730252074326
             + y*(-7244.8602470993186163657226866893
             + (16904.673909898410104853352935608
             - 11269.782606598940069902235290406*y)*y)
             + x*(-804.98447189992429070730252074326
             + y*(7244.8602470993186163657226866893
             + y*(-16904.673909898410104853352935608
             + 11269.782606598940069902235290406*y))));
            return;
          case ( 26 ):
            grad[0]= -11.489125293076057319701222936438
             + y*(344.67375879228171959103668809314
             + y*(-2412.716311545972037137256816652
             + y*(6433.9101641225920990326848444052
             + y*(-7238.1489346379161114117704499559
             + 2895.2595738551664445647081799823*y))));
            grad[1]= -172.33687939614085979551834404657
             + y*(2412.716311545972037137256816652
             + y*(-9650.8652461838881485490272666078
             + (14476.297869275832222823540899912
             - 7238.148934637916111411770449956*y)*y))
             + x*(344.67375879228171959103668809314
             + y*(-4825.4326230919440742745136333039
             + y*(19301.730492367776297098054533216
             + y*(-28952.595738551664445647081799823
             + 14476.297869275832222823540899912*y))));
            return;
          case ( 27 ):
            grad[0]= 0;
            grad[1]= -151.43315356948755031100729323376
             + y*(3028.6630713897510062201458646752
             + y*(-18171.978428338506037320875188051
             + y*(45429.946070846265093302187970128
             + y*(-49972.940677930891602632406767141
             + 19989.176271172356641052962706856*y))));
            return;
          #endif
          #if (PMAX2D>=7)
          case ( 28 ):
            grad[0]= 216.88706738761534557003886238781
             + x*(-5855.950819465614330391049284471
             + x*(48799.590162213452753258744037258
             + x*(-178931.83059478266009528206146995
             + x*(322077.2950706087881715077106459
             + x*(-279133.65572786094974864001589312
             + 93044.55190928698324954667196437*x)))));
            grad[1]= 0;
            return;
          case ( 29 ):
            grad[0]= 262.28991593273272464556951107947
             - 524.5798318654654492911390221589*y
             + x*(-5245.7983186546544929113902215894
             + 10491.596637309308985822780443179*y
             + x*(31474.789911927926957468341329537
             - 62949.57982385585391493668265907*y
             + x*(-78686.974779819817393670853323841
             + 157373.94955963963478734170664768*y
             + x*(86555.672257801799133037938656226
             - 173111.34451560359826607587731245*y
             + x*(-34622.26890312071965321517546249
             + 69244.53780624143930643035092498*y)))));
            grad[1]= 12.48999599679679641169378624188
             + x*(-524.57983186546544929113902215894
             + x*(5245.7983186546544929113902215894
             + x*(-20983.193274618617971645560886358
             + x*(39343.487389909908696835426661921
             + x*(-34622.26890312071965321517546249
             + 11540.756301040239884405058487497*x)))));
            return;
          case ( 30 ):
            grad[0]= 222.48595461286988846134192322402
             + y*(-1334.9157276772193307680515393441
             + 1334.9157276772193307680515393441*y)
             + x*(-3114.8033645801784384587869251363
             + (18688.820187481070630752721550818
             - 18688.820187481070630752721550818*y)*y
             + x*(12459.213458320713753835147700545
             + y*(-74755.280749924282523010886203271
             + 74755.28074992428252301088620327*y)
             + x*(-18688.820187481070630752721550818
             + (112132.92112488642378451632930491
             - 112132.92112488642378451632930491*y)*y
             + x*(9344.4100937405353153763607754089
             + y*(-56066.460562443211892258164652453
             + 56066.46056244321189225816465245*y)))));
            grad[1]= 44.497190922573977692268384644804
             - 88.99438184514795538453676928961*y
             + x*(-1334.9157276772193307680515393441
             + 2669.8314553544386615361030786883*y
             + x*(9344.4100937405353153763607754089
             - 18688.820187481070630752721550818*y
             + x*(-24918.42691664142750767029540109
             + 49836.853833282855015340590802181*y
             + x*(28033.230281221605946129082326227
             - 56066.46056244321189225816465245*y
             + x*(-11213.292112488642378451632930491
             + 22426.584224977284756903265860981*y)))));
            return;
          case ( 31 ):
            grad[0]= 158.74507866387543543009694521836
             + y*(-1904.9409439665052251611633426203
             + (4762.3523599162630629029083565507
             - 3174.9015732775087086019389043671*y)*y)
             + x*(-1428.7057079748789188708725069652
             + y*(17144.468495698547026450470083582
             + y*(-42861.171239246367566126175208956
             + 28574.114159497578377417450139304*y))
             + x*(3333.6466519413841440320358495855
             + y*(-40003.759823296609728384430195026
             + (100009.39955824152432096107548756
             - 66672.93303882768288064071699171*y)*y)
             + x*(-2222.431101294256096021357233057
             + y*(26669.173215531073152256286796684
             + y*(-66672.933038827682880640716991709
             + 44448.62202588512192042714466114*y)))));
            grad[1]= 95.247047198325261258058167131013
             + y*(-476.23523599162630629029083565507
             + 476.23523599162630629029083565507*y)
             + x*(-1904.9409439665052251611633426203
             + (9524.7047198325261258058167131013
             - 9524.704719832526125805816713101*y)*y
             + x*(8572.2342478492735132252350417912
             + y*(-42861.171239246367566126175208956
             + 42861.171239246367566126175208956*y)
             + x*(-13334.586607765536576128143398342
             + (66672.933038827682880640716991709
             - 66672.93303882768288064071699171*y)*y
             + x*(6667.2933038827682880640716991709
             + y*(-33336.466519413841440320358495855
             + 33336.466519413841440320358495855*y)))));
            return;
          case ( 32 ):
            grad[0]= 95.247047198325261258058167131013
             + y*(-1904.9409439665052251611633426203
             + y*(8572.2342478492735132252350417912
             + y*(-13334.586607765536576128143398342
             + 6667.293303882768288064071699171*y)))
             + x*(-476.23523599162630629029083565507
             + y*(9524.7047198325261258058167131013
             + y*(-42861.171239246367566126175208956
             + (66672.933038827682880640716991709
             - 33336.466519413841440320358495855*y)*y))
             + x*(476.23523599162630629029083565507
             + y*(-9524.7047198325261258058167131013
             + y*(42861.171239246367566126175208956
             + y*(-66672.933038827682880640716991709
             + 33336.466519413841440320358495855*y)))));
            grad[1]= 158.74507866387543543009694521836
             + y*(-1428.7057079748789188708725069652
             + (3333.6466519413841440320358495855
             - 2222.431101294256096021357233057*y)*y)
             + x*(-1904.9409439665052251611633426203
             + y*(17144.468495698547026450470083582
             + y*(-40003.759823296609728384430195026
             + 26669.173215531073152256286796684*y))
             + x*(4762.3523599162630629029083565507
             + y*(-42861.171239246367566126175208956
             + (100009.39955824152432096107548756
             - 66672.93303882768288064071699171*y)*y)
             + x*(-3174.9015732775087086019389043671
             + y*(28574.114159497578377417450139304
             + y*(-66672.933038827682880640716991709
             + 44448.62202588512192042714466114*y)))));
            return;
          case ( 33 ):
            grad[0]= 44.497190922573977692268384644804
             + y*(-1334.9157276772193307680515393441
             + y*(9344.4100937405353153763607754089
             + y*(-24918.42691664142750767029540109
             + (28033.230281221605946129082326227
             - 11213.292112488642378451632930491*y)*y)))
             + x*(-88.994381845147955384536769289609
             + y*(2669.8314553544386615361030786883
             + y*(-18688.820187481070630752721550818
             + y*(49836.853833282855015340590802181
             + y*(-56066.460562443211892258164652453
             + 22426.584224977284756903265860981*y)))));
            grad[1]= 222.48595461286988846134192322402
             + y*(-3114.8033645801784384587869251363
             + y*(12459.213458320713753835147700545
             + y*(-18688.820187481070630752721550818
             + 9344.410093740535315376360775409*y)))
             + x*(-1334.9157276772193307680515393441
             + y*(18688.820187481070630752721550818
             + y*(-74755.280749924282523010886203271
             + (112132.92112488642378451632930491
             - 56066.46056244321189225816465245*y)*y))
             + x*(1334.9157276772193307680515393441
             + y*(-18688.820187481070630752721550818
             + y*(74755.280749924282523010886203271
             + y*(-112132.92112488642378451632930491
             + 56066.46056244321189225816465245*y)))));
            return;
          case ( 34 ):
            grad[0]= 12.48999599679679641169378624188
             + y*(-524.57983186546544929113902215894
             + y*(5245.7983186546544929113902215894
             + y*(-20983.193274618617971645560886358
             + y*(39343.487389909908696835426661921
             + y*(-34622.26890312071965321517546249
             + 11540.756301040239884405058487497*y)))));
            grad[1]= 262.28991593273272464556951107947
             + y*(-5245.7983186546544929113902215894
             + y*(31474.789911927926957468341329537
             + y*(-78686.974779819817393670853323841
             + (86555.672257801799133037938656226
             - 34622.26890312071965321517546249*y)*y)))
             + x*(-524.57983186546544929113902215894
             + y*(10491.596637309308985822780443179
             + y*(-62949.579823855853914936682659073
             + y*(157373.94955963963478734170664768
             + y*(-173111.34451560359826607587731245
             + 69244.53780624143930643035092498*y)))));
            return;
          case ( 35 ):
            grad[0]= 0;
            grad[1]= 216.88706738761534557003886238781
             + y*(-5855.950819465614330391049284471
             + y*(48799.590162213452753258744037258
             + y*(-178931.83059478266009528206146995
             + y*(322077.2950706087881715077106459
             + y*(-279133.65572786094974864001589312
             + 93044.55190928698324954667196437*y)))));
            return;
          #endif
          #if (PMAX2D>=8)
          case ( 36 ):
            grad[0]= -296.86360504447155958714150963013
             + x*(10390.226176556504585549952837055
             + x*(-114292.4879421215504410494812076
             + x*(571462.43971060775220524740603801
             + x*(-1.4858023432475801557336432556988e6
             + x*(2.0801232805466122180271005579783e6
             + x*(-1.4858023432475801557336432556988e6
             + 424514.95521359433020961235877109*x))))));
            grad[1]= 0;
            return;
          case ( 37 ):
            grad[0]= -375.65942021996466899674117634685
             + 751.3188404399293379934823526937*y
             + x*(10142.804345939046062912011761365
             - 20285.60869187809212582402352273*y
             + x*(-84523.369549492050524266764678042
             + 169046.73909898410104853352935608*y
             + x*(309919.02168147085192231147048615
             - 619838.0433629417038446229409723*y
             + x*(-557854.23902664753346016064687508
             + 1.1157084780532950669203212937502e6*y
             + x*(483473.6738230945289988058939584
             - 966947.3476461890579976117879168*y
             + x*(-161157.8912743648429996019646528
             + 322315.7825487296859992039293056*y))))));
            grad[1]= -13.416407864998738178455042012388
             + x*(751.31884043992933799348235269371
             + x*(-10142.804345939046062912011761365
             + x*(56348.913032994700349511176452028
             + x*(-154959.51084073542596115573524308
             + x*(223141.69561065901338406425875003
             + x*(-161157.8912743648429996019646528
             + 46045.111792675669428457704186514*x))))));
            return;
          case ( 38 ):
            grad[0]= -338.61482542853908539939775567276
             + (2031.6889525712345123963865340366
             - 2031.6889525712345123963865340366*y)*y
             + x*(6772.2965085707817079879551134552
             + y*(-40633.779051424690247927730680731
             + 40633.779051424690247927730680731*y)
             + x*(-40633.779051424690247927730680731
             + (243802.67430854814148756638408439
             - 243802.67430854814148756638408439*y)*y
             + x*(101584.44762856172561981932670183
             + y*(-609506.68577137035371891596021097
             + 609506.685771370353718915960211*y)
             + x*(-111742.89239141789818180125937201
             + (670457.35434850738909080755623206
             - 670457.3543485073890908075562321*y)*y
             + x*(44697.156956567159272720503748804
             + y*(-268182.94173940295563632302249282
             + 268182.94173940295563632302249282*y))))));
            grad[1]= -48.373546489791297914199679381823
             + 96.74709297958259582839935876365*y
             + x*(2031.6889525712345123963865340366
             - 4063.3779051424690247927730680731*y
             + x*(-20316.889525712345123963865340366
             + 40633.779051424690247927730680731*y
             + x*(81267.558102849380495855461361462
             - 162535.11620569876099171092272292*y
             + x*(-152376.67144284258842972899005274
             + 304753.34288568517685945798010548*y
             + x*(134091.47086970147781816151124641
             - 268182.94173940295563632302249282*y
             + x*(-44697.156956567159272720503748804
             + 89394.31391313431854544100749761*y))))));
          case ( 39 ):
            grad[0]= -263.24893162176366181219164922249
             + y*(3158.9871794611639417462997906699
             + y*(-7897.4679486529098543657494766747
             + 5264.97863243527323624383298445*y))
             + x*(3685.4850427046912653706830891149
             + y*(-44225.820512456295184448197069378
             + (110564.55128114073796112049267345
             - 73709.7008540938253074136617823*y)*y)
             + x*(-14741.940170818765061482732356459
             + y*(176903.28204982518073779278827751
             + y*(-442258.20512456295184448197069378
             + 294838.80341637530122965464712919*y))
             + x*(22112.910256228147592224098534689
             + y*(-265354.92307473777110668918241627
             + (663387.30768684442776672295604067
             - 442258.20512456295184448197069378*y)*y)
             + x*(-11056.455128114073796112049267345
             + y*(132677.46153736888555334459120813
             + y*(-331693.65384342221388336147802034
             + 221129.10256228147592224098534689*y))))));
            grad[1]= -105.299572648705464724876659689
             + (526.49786324352732362438329844498
             - 526.497863243527323624383298445*y)*y
             + x*(3158.9871794611639417462997906699
             + y*(-15794.935897305819708731498953349
             + 15794.935897305819708731498953349*y)
             + x*(-22112.910256228147592224098534689
             + (110564.55128114073796112049267345
             - 110564.55128114073796112049267345*y)*y
             + x*(58967.760683275060245930929425838
             + y*(-294838.80341637530122965464712919
             + 294838.80341637530122965464712919*y)
             + x*(-66338.730768684442776672295604067
             + (331693.65384342221388336147802034
             - 331693.65384342221388336147802034*y)*y
             + x*(26535.492307473777110668918241627
             + y*(-132677.46153736888555334459120813
             + 132677.46153736888555334459120813*y))))));
            return;
          case ( 40 ):
            grad[0]= -180.
             + y*(3600.
             + y*(-16200.
             + (25200.
             - 12600.*y)*y))
             + x*(1620.
             + y*(-32400.
             + y*(145800.
             + y*(-226800.
             + 113400.*y)))
             + x*(-3780.
             + y*(75600.
             + y*(-340200.
             + (529200.
             - 264600.*y)*y))
             + x*(2520.
             + y*(-50400.
             + y*(226800.
             + y*(-352800.
             + 176400.*y))))));
            grad[1]= -180.
             + y*(1620.
             + y*(-3780.
             + 2520.*y))
             + x*(3600.
             + y*(-32400.
             + (75600.
             - 50400.*y)*y)
             + x*(-16200.
             + y*(145800.
             + y*(-340200.
             + 226800.*y))
             + x*(25200.
             + y*(-226800.
             + (529200.
             - 352800.*y)*y)
             + x*(-12600.
             + y*(113400.
             + y*(-264600.
             + 176400.*y))))));
            return;
          case ( 41 ):
            grad[0]= -105.299572648705464724876659689
             + y*(3158.9871794611639417462997906699
             + y*(-22112.910256228147592224098534689
             + y*(58967.760683275060245930929425838
             + y*(-66338.730768684442776672295604067
             + 26535.492307473777110668918241627*y))))
             + x*(526.49786324352732362438329844498
             + y*(-15794.935897305819708731498953349
             + y*(110564.55128114073796112049267345
             + y*(-294838.80341637530122965464712919
             + (331693.65384342221388336147802034
             - 132677.46153736888555334459120813*y)*y)))
             + x*(-526.49786324352732362438329844498
             + y*(15794.935897305819708731498953349
             + y*(-110564.55128114073796112049267345
             + y*(294838.80341637530122965464712919
             + y*(-331693.65384342221388336147802034
             + 132677.46153736888555334459120813*y))))));
            grad[1]= -263.24893162176366181219164922249
             + y*(3685.4850427046912653706830891149
             + y*(-14741.940170818765061482732356459
             + (22112.910256228147592224098534689
             - 11056.455128114073796112049267345*y)*y))
             + x*(3158.9871794611639417462997906699
             + y*(-44225.820512456295184448197069378
             + y*(176903.28204982518073779278827751
             + y*(-265354.92307473777110668918241627
             + 132677.46153736888555334459120813*y)))
             + x*(-7897.4679486529098543657494766747
             + y*(110564.55128114073796112049267345
             + y*(-442258.20512456295184448197069378
             + (663387.30768684442776672295604067
             - 331693.65384342221388336147802034*y)*y))
             + x*(5264.9786324352732362438329844498
             + y*(-73709.700854093825307413661782297
             + y*(294838.80341637530122965464712919
             + y*(-442258.20512456295184448197069378
             + 221129.10256228147592224098534689*y))))));
            return;
          case ( 42 ):
            grad[0]= -48.373546489791297914199679381823
             + y*(2031.6889525712345123963865340366
             + y*(-20316.889525712345123963865340366
             + y*(81267.558102849380495855461361462
             + y*(-152376.67144284258842972899005274
             + (134091.47086970147781816151124641
             - 44697.156956567159272720503748804*y)*y))))
             + x*(96.747092979582595828399358763645
             + y*(-4063.3779051424690247927730680731
             + y*(40633.779051424690247927730680731
             + y*(-162535.11620569876099171092272292
             + y*(304753.34288568517685945798010548
             + y*(-268182.94173940295563632302249282
             + 89394.31391313431854544100749761*y))))));
            grad[1]= -338.61482542853908539939775567276
             + y*(6772.2965085707817079879551134552
             + y*(-40633.779051424690247927730680731
             + y*(101584.44762856172561981932670183
             + y*(-111742.89239141789818180125937201
             + 44697.156956567159272720503748804*y))))
             + x*(2031.6889525712345123963865340366
             + y*(-40633.779051424690247927730680731
             + y*(243802.67430854814148756638408439
             + y*(-609506.68577137035371891596021097
             + (670457.35434850738909080755623206
             - 268182.94173940295563632302249282*y)*y)))
             + x*(-2031.6889525712345123963865340366
             + y*(40633.779051424690247927730680731
             + y*(-243802.67430854814148756638408439
             + y*(609506.68577137035371891596021097
             + y*(-670457.35434850738909080755623206
             + 268182.94173940295563632302249282*y))))));
            return;
          case ( 43 ):
            grad[0]= -13.416407864998738178455042012388
             + y*(751.31884043992933799348235269371
             + y*(-10142.804345939046062912011761365
             + y*(56348.913032994700349511176452028
             + y*(-154959.51084073542596115573524308
             + y*(223141.69561065901338406425875003
             + y*(-161157.8912743648429996019646528
             + 46045.111792675669428457704186514*y))))));
            grad[1]= -375.65942021996466899674117634685
             + y*(10142.804345939046062912011761365
             + y*(-84523.369549492050524266764678042
             + y*(309919.02168147085192231147048615
             + y*(-557854.23902664753346016064687508
             + (483473.6738230945289988058939584
             - 161157.8912743648429996019646528*y)*y))))
             + x*(751.31884043992933799348235269371
             + y*(-20285.60869187809212582402352273
             + y*(169046.73909898410104853352935608
             + y*(-619838.04336294170384462294097231
             + y*(1.1157084780532950669203212937502e6
             + y*(-966947.3476461890579976117879168
             + 322315.7825487296859992039293056*y))))));
          case ( 44 ):
            grad[0]= 0;
            grad[1]= -296.86360504447155958714150963013
             + y*(10390.226176556504585549952837055
             + y*(-114292.4879421215504410494812076
             + y*(571462.43971060775220524740603801
             + y*(-1.4858023432475801557336432556988e6
             + y*(2.0801232805466122180271005579783e6
             + y*(-1.4858023432475801557336432556988e6
             + 424514.95521359433020961235877109*y))))));
            return;
          #endif
        }
      }

      /* H\phi_i(x,y) for quadrilateral */
      static void
      hess_quadrilateral_2d ( const int i, DomainType xi, HessianRangeType &h )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];

        switch( i )
        {
          #if (PMAX2D>=0)
          case ( 0 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 0;
            return;
          #endif
          #if (PMAX2D>=1)
          case ( 1 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 2 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 0;
            return;
          #endif
          #if (PMAX2D>=2)
          case ( 3 ):
            h[0] = 26.832815729997476356910084024776;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 4 ):
            h[0] = 0;
            h[1] = 12.;
            h[2] = 0;
            return;
          case ( 5 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 26.832815729997476356910084024776;
            return;
          #endif
          #if (PMAX2D>=3)
          case ( 6 ):
            h[0] = -158.74507866387543543009694521836+317.49015732775087086019389043674*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 7 ):
            h[0] = -46.475800154489002622151184797388+92.951600308978005244302369594778*y;
            h[1] = -46.475800154489002622151184797389+92.951600308978005244302369594778*x;
            h[2] = 0;
            return;
          case ( 8 ):
            h[0] = 0;
            h[1] = -46.475800154489002622151184797389+92.951600308978005244302369594778*y;
            h[2] = -46.475800154489002622151184797388+92.951600308978005244302369594778*x;
            return;
          case ( 9 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = -158.74507866387543543009694521836+317.49015732775087086019389043674*y;
            return;
          #endif
          #if (PMAX2D>=4)
          case ( 10 ):
            h[0] = 540.+(-2520.+2520.*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 11 ):
            h[0] = 274.95454169735040039528283162368-549.90908339470080079056566324736*y+(-549.90908339470080079056566324736+1099.8181667894016015811313264947*y)*x;
            h[1] = 109.98181667894016015811313264947+(-549.90908339470080079056566324736+549.90908339470080079056566324736*x)*x;
            h[2] = 0;
            return;
          case ( 12 ):
            h[0] = 60.+(-360.+360.*y)*y;
            h[1] = -360.*y+180.+(-360.+720.*y)*x;
            h[2] = 60.+x*(-360.+360.*x);
            return;
          case ( 13 ):
            h[0] = 0;
            h[1] = 109.98181667894016015811313264947+(-549.90908339470080079056566324736+549.90908339470080079056566324736*y)*y;
            h[2] = 274.95454169735040039528283162368-549.90908339470080079056566324736*y+(-549.90908339470080079056566324736+1099.8181667894016015811313264947*y)*x;
            return;
          case ( 14 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 540.+(-2520.+2520.*y)*y;
            return;
          #endif
          #if (PMAX2D>=5)
          case ( 15 ):
            h[0] = -1392.9824119492679366282717494017+(11143.859295594143493026173995214+(-25073.683415086822859308891489230+16715.788943391215239539260992820*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 16 ):
            h[0] = -935.30743608719373850482102441318+1870.6148721743874770096420488264*y+(4364.7680350735707796891647805947-8729.5360701471415593783295611894*y+(-4364.7680350735707796891647805948+8729.5360701471415593783295611900*y)*x)*x;
            h[1] = -207.8460969082652752232935609807+(1870.6148721743874770096420488264+(-4364.7680350735707796891647805947+2909.8453567157138531261098537300*x)*x)*x;
            h[2] = 0;
            return;
          case ( 17 ):
            h[0] = -354.96478698597696255403969749370+(2129.7887219158617753242381849622-2129.7887219158617753242381849622*y)*y+(709.92957397195392510807939498738+(-4259.5774438317235506484763699243+4259.5774438317235506484763699244*y)*y)*x;
            h[1] = -425.95774438317235506484763699244+851.91548876634471012969527398488*y+(-4259.5774438317235506484763699244*y+2129.7887219158617753242381849622+(-2129.7887219158617753242381849622+4259.5774438317235506484763699244*y)*x)*x;
            h[2] = -70.99295739719539251080793949874+x*(851.91548876634471012969527398488+x*(-2129.7887219158617753242381849622+1419.8591479439078502161587899748*x));
            return;
          case ( 18 ):
            h[0] = -70.99295739719539251080793949874+(851.91548876634471012969527398488+(-2129.7887219158617753242381849622+1419.8591479439078502161587899748*y)*y)*y;
            h[1] = -425.95774438317235506484763699244+(2129.7887219158617753242381849622-2129.7887219158617753242381849622*y)*y+(851.91548876634471012969527398488+(-4259.5774438317235506484763699244+4259.5774438317235506484763699244*y)*y)*x;
            h[2] = -354.96478698597696255403969749370+709.92957397195392510807939498738*y+(-4259.5774438317235506484763699244*y+2129.7887219158617753242381849622+(-2129.7887219158617753242381849622+4259.5774438317235506484763699244*y)*x)*x;
            return;
          case ( 19 ):
            h[0] = 0;
            h[1] = -207.8460969082652752232935609807+(1870.6148721743874770096420488263+(-4364.7680350735707796891647805947+2909.8453567157138531261098537300*y)*y)*y;
            h[2] = -935.30743608719373850482102441318+(4364.7680350735707796891647805947-4364.7680350735707796891647805948*y)*y+(1870.6148721743874770096420488263+(-8729.5360701471415593783295611894+8729.5360701471415593783295611900*y)*y)*x;
            return;
          case ( 20 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = -1392.9824119492679366282717494017+(11143.859295594143493026173995214+(-25073.683415086822859308891489230+16715.788943391215239539260992820*y)*y)*y;
            return;
          #endif
          #if (PMAX2D>=6)
          case ( 21 ):
            h[0] = 3028.6630713897510062201458646752+(-36343.956856677012074641750376103+(136289.83821253879527990656391038+(-199891.76271172356641052962706856+99945.881355861783205264813534280*x)*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 22 ):
            h[0] = 2412.716311545972037137256816652-4825.432623091944074274513633304*y+(-19301.730492367776297098054533215+38603.460984735552594196109066430*y+(43428.893607827496668470622699736-86857.787215654993336941245399472*y+(-28952.595738551664445647081799824+57905.191477103328891294163599647*y)*x)*x)*x;
            h[1] = 344.67375879228171959103668809314+(-4825.432623091944074274513633304+(19301.730492367776297098054533215+(-28952.595738551664445647081799824+14476.297869275832222823540899911*x)*x)*x)*x;
            h[2] = 0;
            return;
          case ( 23 ):
            h[0] = 1207.4767078498864360609537811149+(-7244.8602470993186163657226866894+7244.8602470993186163657226866894*y)*y+(-5634.8913032994700349511176452029+(33809.347819796820209706705871217-33809.347819796820209706705871218*y)*y+(5634.8913032994700349511176452028+(-33809.347819796820209706705871217+33809.347819796820209706705871217*y)*y)*x)*x;
            h[1] = -1609.9689437998485814146050414866*y+804.98447189992429070730252074326+(-7244.8602470993186163657226866894+14489.720494198637232731445373379*y+(-33809.347819796820209706705871218*y+16904.673909898410104853352935609+(-11269.782606598940069902235290406+22539.565213197880139804470580812*y)*x)*x)*x;
            h[2] = 80.498447189992429070730252074326+x*(-1609.9689437998485814146050414866+x*(7244.8602470993186163657226866894+x*(-11269.782606598940069902235290406+5634.8913032994700349511176452028*x)));
            return;
          case ( 24 ):
            h[0] = 420.+(-5040.+(12600.-8400.*y)*y)*y+(-840.+(10080.+(-25200.+16800.*y)*y)*y)*x;
            h[1] = 1008.+(-5040.+5040.*y)*y+(-5040.+(25200.-25200.*y)*y+(5040.+(-25200.+25200.*y)*y)*x)*x;
            h[2] = -840.*y+420.+x*(-5040.+10080.*y+x*(-25200.*y+12600.+x*(-8400.+16800.*y)));
            return;
          case ( 25 ):
            h[0] = 80.498447189992429070730252074326+(-1609.9689437998485814146050414865+(7244.8602470993186163657226866894+(-11269.782606598940069902235290406+5634.8913032994700349511176452028*y)*y)*y)*y;
            h[1] = 804.98447189992429070730252074326+(-7244.8602470993186163657226866894+(16904.673909898410104853352935609-11269.782606598940069902235290406*y)*y)*y+(-1609.9689437998485814146050414865+(14489.720494198637232731445373379+(-33809.347819796820209706705871218+22539.565213197880139804470580811*y)*y)*y)*x;
            h[2] = 1207.4767078498864360609537811149+(-5634.8913032994700349511176452029+5634.8913032994700349511176452028*y)*y+(-7244.8602470993186163657226866894+(33809.347819796820209706705871218-33809.347819796820209706705871218*y)*y+(7244.8602470993186163657226866894+(-33809.347819796820209706705871218+33809.347819796820209706705871218*y)*y)*x)*x;
            return;
          case ( 26 ):
            h[0] = 0;
            h[1] = 344.67375879228171959103668809314+(-4825.432623091944074274513633304+(19301.730492367776297098054533215+(-28952.595738551664445647081799824+14476.297869275832222823540899911*y)*y)*y)*y;
            h[2] = 2412.716311545972037137256816652+(-19301.730492367776297098054533215+(43428.893607827496668470622699736-28952.595738551664445647081799824*y)*y)*y+(-4825.432623091944074274513633304+(38603.460984735552594196109066430+(-86857.787215654993336941245399472+57905.191477103328891294163599647*y)*y)*y)*x;
            return;
          case ( 27 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 3028.6630713897510062201458646752+(-36343.956856677012074641750376103+(136289.83821253879527990656391038+(-199891.76271172356641052962706856+99945.881355861783205264813534280*y)*y)*y)*y;
            return;
          #endif
          #if (PMAX2D>=7)
          case ( 28 ):
            h[0] = -5855.9508194656143303910492844710+(97599.180324426905506517488074516+(-536795.49178434798028584618440984+(1288309.1802824351526860308425836+(-1395668.2786393047487432000794656+558267.31145572189949728003178623*x)*x)*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 29 ):
            h[0] = -5245.7983186546544929113902215894+10491.596637309308985822780443178*y+(62949.579823855853914936682659074-125899.15964771170782987336531815*y+(-236060.92433945945218101255997152+472121.84867891890436202511994304*y+(346222.68903120719653215175462490-692445.37806241439306430350924980*y+(-173111.34451560359826607587731245+346222.68903120719653215175462490*y)*x)*x)*x)*x;
            h[1] = -524.5798318654654492911390221589+(10491.596637309308985822780443178+(-62949.579823855853914936682659074+(157373.94955963963478734170664768+(-173111.34451560359826607587731245+69244.537806241439306430350924982*x)*x)*x)*x)*x;
            h[2] = 0;
            return;
          case ( 30 ):
            h[0] = -3114.8033645801784384587869251362+(18688.820187481070630752721550818-18688.820187481070630752721550818*y)*y+(24918.426916641427507670295401091+(-149510.56149984856504602177240654+149510.56149984856504602177240654*y)*y+(-56066.460562443211892258164652454+(336398.76337465927135354898791472-336398.76337465927135354898791472*y)*y+(37377.640374962141261505443101637+(-224265.84224977284756903265860982+224265.84224977284756903265860982*y)*y)*x)*x)*x;
            h[1] = -1334.9157276772193307680515393441+2669.8314553544386615361030786882*y+(-37377.640374962141261505443101636*y+18688.820187481070630752721550818+(-74755.28074992428252301088620327+149510.56149984856504602177240654*y+(-224265.84224977284756903265860981*y+112132.92112488642378451632930491+(-56066.460562443211892258164652455+112132.92112488642378451632930491*y)*x)*x)*x)*x;
            h[2] = -88.994381845147955384536769289608+x*(2669.8314553544386615361030786882+x*(-18688.820187481070630752721550818+x*(49836.85383328285501534059080218+x*(-56066.460562443211892258164652454+22426.584224977284756903265860982*x))));
            return;
          case ( 31 ):
            h[0] = -1428.7057079748789188708725069652+(17144.468495698547026450470083582+(-42861.171239246367566126175208956+28574.114159497578377417450139304*y)*y)*y+(6667.2933038827682880640716991710+(-80007.519646593219456768860390052+(200018.79911648304864192215097513-133345.86607765536576128143398342*y)*y)*y+(-6667.2933038827682880640716991710+(80007.519646593219456768860390051+(-200018.79911648304864192215097512+133345.86607765536576128143398342*y)*y)*y)*x)*x;
            h[1] = -1904.9409439665052251611633426203+(9524.7047198325261258058167131014-9524.7047198325261258058167131013*y)*y+(17144.468495698547026450470083582+(-85722.342478492735132252350417912+85722.342478492735132252350417912*y)*y+(-40003.759823296609728384430195026+(200018.79911648304864192215097512-200018.79911648304864192215097513*y)*y+(26669.173215531073152256286796684+(-133345.86607765536576128143398342+133345.86607765536576128143398342*y)*y)*x)*x)*x;
            h[2] = -476.23523599162630629029083565506+952.47047198325261258058167131016*y+x*(-19049.409439665052251611633426202*y+9524.7047198325261258058167131014+x*(-42861.171239246367566126175208956+85722.342478492735132252350417912*y+x*(-133345.86607765536576128143398342*y+66672.933038827682880640716991710+x*(-33336.466519413841440320358495854+66672.933038827682880640716991710*y))));
            return;
          case ( 32 ):
            h[0] = -476.23523599162630629029083565506+(9524.7047198325261258058167131014+(-42861.171239246367566126175208956+(66672.933038827682880640716991710-33336.466519413841440320358495854*y)*y)*y)*y+(952.47047198325261258058167131016+(-19049.409439665052251611633426203+(85722.342478492735132252350417912+(-133345.86607765536576128143398342+66672.933038827682880640716991710*y)*y)*y)*y)*x;
            h[1] = -1904.9409439665052251611633426203+(17144.468495698547026450470083582+(-40003.759823296609728384430195026+26669.173215531073152256286796684*y)*y)*y+(9524.7047198325261258058167131014+(-85722.342478492735132252350417912+(200018.79911648304864192215097513-133345.86607765536576128143398341*y)*y)*y+(-9524.7047198325261258058167131013+(85722.342478492735132252350417912+(-200018.79911648304864192215097513+133345.86607765536576128143398342*y)*y)*y)*x)*x;
            h[2] = -1428.7057079748789188708725069652+(6667.2933038827682880640716991710-6667.2933038827682880640716991704*y)*y+(17144.468495698547026450470083582+(-80007.519646593219456768860390052+80007.519646593219456768860390052*y)*y+(-42861.171239246367566126175208956+(200018.79911648304864192215097513-200018.79911648304864192215097512*y)*y+(28574.114159497578377417450139304+(-133345.86607765536576128143398342+133345.86607765536576128143398342*y)*y)*x)*x)*x;
            return;
          case ( 33 ):
            h[0] = -88.994381845147955384536769289608+(2669.8314553544386615361030786882+(-18688.820187481070630752721550818+(49836.85383328285501534059080218+(-56066.460562443211892258164652454+22426.584224977284756903265860982*y)*y)*y)*y)*y;
            h[1] = -1334.9157276772193307680515393441+(18688.820187481070630752721550818+(-74755.28074992428252301088620327+(112132.92112488642378451632930491-56066.460562443211892258164652455*y)*y)*y)*y+(2669.8314553544386615361030786882+(-37377.640374962141261505443101636+(149510.56149984856504602177240654+(-224265.84224977284756903265860981+112132.92112488642378451632930491*y)*y)*y)*y)*x;
            h[2] = -3114.8033645801784384587869251362+(24918.426916641427507670295401091+(-56066.460562443211892258164652454+37377.640374962141261505443101637*y)*y)*y+(18688.820187481070630752721550818+(-149510.56149984856504602177240654+(336398.76337465927135354898791472-224265.84224977284756903265860982*y)*y)*y+(-18688.820187481070630752721550818+(149510.56149984856504602177240654+(-336398.76337465927135354898791472+224265.84224977284756903265860982*y)*y)*y)*x)*x;
            return;
          case ( 34 ):
            h[0] = 0;
            h[1] = -524.57983186546544929113902215894+(10491.596637309308985822780443179+(-62949.579823855853914936682659074+(157373.94955963963478734170664768+(-173111.34451560359826607587731245+69244.537806241439306430350924982*y)*y)*y)*y)*y;
            h[2] = -5245.7983186546544929113902215894+(62949.579823855853914936682659074+(-236060.92433945945218101255997152+(346222.68903120719653215175462490-173111.34451560359826607587731244*y)*y)*y)*y+(10491.596637309308985822780443179+(-125899.15964771170782987336531815+(472121.84867891890436202511994304+(-692445.37806241439306430350924980+346222.68903120719653215175462491*y)*y)*y)*y)*x;
            return;
          case ( 35 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = -5855.9508194656143303910492844710+(97599.180324426905506517488074516+(-536795.49178434798028584618440984+(1288309.1802824351526860308425836+(-1395668.2786393047487432000794656+558267.31145572189949728003178623*y)*y)*y)*y)*y;
            return;
          #endif
          #if (PMAX2D>=8)
          case ( 36 ):
            h[0] = 10390.226176556504585549952837055+(-228584.9758842431008820989624152+(1714387.3191318232566157422181140+(-5943209.3729903206229345730227951+(10400616.402733061090135502789892+(-8914814.0594854809344018595341932+2971604.6864951603114672865113979*x)*x)*x)*x)*x)*x;
            h[1] = 0;
            h[2] = 0;
            return;
          case ( 37 ):
            h[0] = 10142.804345939046062912011761365-20285.608691878092125824023522730*y+(-169046.73909898410104853352935609+338093.47819796820209706705871218*y+(929757.06504441255576693441145848-1859514.1300888251115338688229170*y+(-2231416.9561065901338406425875003+4462833.9122131802676812851750007*y+(2417368.3691154726449940294697920-4834736.7382309452899880589395840*y+(-966947.34764618905799761178791677+1933894.6952923781159952235758335*y)*x)*x)*x)*x)*x;
            h[1] = 751.3188404399293379934823526937+(-20285.608691878092125824023522730+(169046.73909898410104853352935609+(-619838.04336294170384462294097232+(1115708.4780532950669203212937502+(-966947.3476461890579976117879168+322315.78254872968599920392930558*x)*x)*x)*x)*x)*x;
            h[2] = 0;
            return;
          case ( 38 ):
            h[0] = 6772.2965085707817079879551134552+(-40633.779051424690247927730680732+40633.779051424690247927730680732*y)*y+(-81267.55810284938049585546136146+(487605.34861709628297513276816877-487605.34861709628297513276816876*y)*y+(304753.34288568517685945798010548+(-1828520.0573141110611567478806329+1828520.0573141110611567478806329*y)*y+(-446971.56956567159272720503748803+(2681829.4173940295563632302249282-2681829.4173940295563632302249282*y)*y+(223485.78478283579636360251874402+(-1340914.7086970147781816151124641+1340914.7086970147781816151124641*y)*y)*x)*x)*x)*x;
            h[1] = -4063.3779051424690247927730680732*y+2031.6889525712345123963865340366+(-40633.779051424690247927730680732+81267.558102849380495855461361464*y+(-487605.34861709628297513276816876*y+243802.67430854814148756638408438+(-609506.68577137035371891596021096+1219013.3715427407074378319204219*y+(-1340914.7086970147781816151124641*y+670457.35434850738909080755623205+(-268182.94173940295563632302249281+536365.88347880591127264604498566*y)*x)*x)*x)*x)*x;
            h[2] = 96.747092979582595828399358763646+x*(-4063.3779051424690247927730680732+x*(40633.779051424690247927730680732+x*(-162535.11620569876099171092272292+x*(304753.34288568517685945798010548+x*(-268182.94173940295563632302249282+89394.313913134318545441007497608*x)))));
            return;
          case ( 39 ):
            h[0] = 3685.4850427046912653706830891148+(-44225.820512456295184448197069378+(110564.55128114073796112049267345-73709.700854093825307413661782298*y)*y)*y+(-29483.880341637530122965464712918+(353806.56409965036147558557655503+(-884516.41024912590368896394138754+589677.60683275060245930929425836*y)*y)*y+(66338.730768684442776672295604070+(-796064.76922421331332006754724880+(1990161.9230605332833001688681220-1326774.6153736888555334459120814*y)*y)*y+(-44225.820512456295184448197069377+(530709.84614947554221337836483254+(-1326774.6153736888555334459120813+884516.41024912590368896394138756*y)*y)*y)*x)*x)*x;
            h[1] = 3158.9871794611639417462997906699+(-15794.935897305819708731498953349+15794.93589730581970873149895335*y)*y+(-44225.820512456295184448197069378+(221129.10256228147592224098534690-221129.10256228147592224098534690*y)*y+(176903.28204982518073779278827752+(-884516.41024912590368896394138754+884516.41024912590368896394138754*y)*y+(-265354.92307473777110668918241627+(1326774.6153736888555334459120814-1326774.6153736888555334459120814*y)*y+(132677.46153736888555334459120814+(-663387.30768684442776672295604068+663387.30768684442776672295604067*y)*y)*x)*x)*x)*x;
            h[2] = -1052.9957264870546472487665968900*y+526.49786324352732362438329844498+x*(-15794.935897305819708731498953349+31589.87179461163941746299790670*y+x*(-221129.10256228147592224098534690*y+110564.55128114073796112049267345+x*(-294838.80341637530122965464712918+589677.60683275060245930929425836*y+x*(-663387.30768684442776672295604070*y+331693.65384342221388336147802034+x*(-132677.46153736888555334459120813+265354.92307473777110668918241627*y)))));
            return;
          case ( 40 ):
            h[0] = 1620.+(-32400.+(145800.+(-226800.+113400.*y)*y)*y)*y+(-7560.+(151200.+(-680400.+(1058400.-529200.*y)*y)*y)*y+(7560.+(-151200.+(680400.+(-1058400.+529200.*y)*y)*y)*y)*x)*x;
            h[1] = 3600.+(-32400.+(75600.-50400.*y)*y)*y+(-32400.+(291600.+(-680400.+453600.*y)*y)*y+(75600.+(-680400.+(1587600.-1058400.*y)*y)*y+(-50400.+(453600.+(-1058400.+705600.*y)*y)*y)*x)*x)*x;
            h[2] = 1620.+(-7560.+7560.*y)*y+(-32400.+(151200.-151200.*y)*y+(145800.+(-680400.+680400.*y)*y+(-226800.+(1058400.-1058400.*y)*y+(113400.+(-529200.+529200.*y)*y)*x)*x)*x)*x;
            return;
          case ( 41 ):
            h[0] = 526.49786324352732362438329844498+(-15794.935897305819708731498953349+(110564.55128114073796112049267345+(-294838.80341637530122965464712918+(331693.65384342221388336147802034-132677.46153736888555334459120814*y)*y)*y)*y)*y+(-1052.9957264870546472487665968900+(31589.871794611639417462997906699+(-221129.10256228147592224098534689+(589677.60683275060245930929425838+(-663387.30768684442776672295604070+265354.92307473777110668918241627*y)*y)*y)*y)*y)*x;
            h[1] = 3158.9871794611639417462997906699+(-44225.820512456295184448197069378+(176903.28204982518073779278827752+(-265354.92307473777110668918241627+132677.46153736888555334459120814*y)*y)*y)*y+(-15794.935897305819708731498953349+(221129.10256228147592224098534690+(-884516.41024912590368896394138754+(1326774.6153736888555334459120814-663387.30768684442776672295604070*y)*y)*y)*y+(15794.935897305819708731498953350+(-221129.10256228147592224098534690+(884516.41024912590368896394138758+(-1326774.6153736888555334459120814+663387.30768684442776672295604066*y)*y)*y)*y)*x)*x;
            h[2] = 3685.4850427046912653706830891148+(-29483.880341637530122965464712918+(66338.730768684442776672295604070-44225.820512456295184448197069377*y)*y)*y+(-44225.820512456295184448197069378+(353806.56409965036147558557655504+(-796064.76922421331332006754724878+530709.84614947554221337836483253*y)*y)*y+(110564.55128114073796112049267345+(-884516.41024912590368896394138754+(1990161.9230605332833001688681220-1326774.6153736888555334459120814*y)*y)*y+(-73709.700854093825307413661782298+(589677.60683275060245930929425839+(-1326774.6153736888555334459120814+884516.41024912590368896394138756*y)*y)*y)*x)*x)*x;
            return;
          case ( 42 ):
            h[0] = 96.747092979582595828399358763646+(-4063.3779051424690247927730680732+(40633.779051424690247927730680732+(-162535.11620569876099171092272292+(304753.34288568517685945798010548+(-268182.94173940295563632302249282+89394.313913134318545441007497608*y)*y)*y)*y)*y)*y;
            h[1] = 2031.6889525712345123963865340366+(-40633.779051424690247927730680732+(243802.67430854814148756638408438+(-609506.68577137035371891596021096+(670457.35434850738909080755623205-268182.94173940295563632302249281*y)*y)*y)*y)*y+(-4063.3779051424690247927730680732+(81267.558102849380495855461361464+(-487605.34861709628297513276816876+(1219013.3715427407074378319204219+(-1340914.7086970147781816151124641+536365.88347880591127264604498563*y)*y)*y)*y)*y)*x;
            h[2] = 6772.2965085707817079879551134552+(-81267.55810284938049585546136146+(304753.34288568517685945798010548+(-446971.56956567159272720503748803+223485.78478283579636360251874403*y)*y)*y)*y+(-40633.779051424690247927730680732+(487605.34861709628297513276816876+(-1828520.0573141110611567478806329+(2681829.4173940295563632302249282-1340914.7086970147781816151124641*y)*y)*y)*y+(40633.779051424690247927730680732+(-487605.34861709628297513276816876+(1828520.0573141110611567478806329+(-2681829.4173940295563632302249282+1340914.7086970147781816151124641*y)*y)*y)*y)*x)*x;
            return;
          case ( 43 ):
            h[0] = 0;
            h[1] = 751.31884043992933799348235269371+(-20285.608691878092125824023522730+(169046.73909898410104853352935609+(-619838.04336294170384462294097232+(1115708.4780532950669203212937502+(-966947.3476461890579976117879168+322315.78254872968599920392930558*y)*y)*y)*y)*y)*y;
            h[2] = 10142.804345939046062912011761365+(-169046.73909898410104853352935609+(929757.06504441255576693441145848+(-2231416.9561065901338406425875003+(2417368.3691154726449940294697920-966947.34764618905799761178791677*y)*y)*y)*y)*y+(-20285.608691878092125824023522730+(338093.47819796820209706705871218+(-1859514.1300888251115338688229169+(4462833.9122131802676812851750007+(-4834736.7382309452899880589395840+1933894.6952923781159952235758336*y)*y)*y)*y)*y)*x;
            return;
          case ( 44 ):
            h[0] = 0;
            h[1] = 0;
            h[2] = 10390.226176556504585549952837055+(-228584.9758842431008820989624152+(1714387.3191318232566157422181140+(-5943209.3729903206229345730227951+(10400616.402733061090135502789892+(-8914814.0594854809344018595341932+2971604.6864951603114672865113979*y)*y)*y)*y)*y)*y;
            return;
          #endif
        }
        printf( "Error in hess_quadrilateral_2d -- unmatched switch/case %d\n", i );
      }

    }; // end class OrthonormalBase_2D
  } // end namespace Fem

} // end namespace Dune
#endif
