agePlot <- function (data, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")
	
	df_high = subset (data, data$general_age %in% c("30-39","40-49","50-59","60-69",">69"))
	df_low  = subset (data, data$general_age %in% c("<18","18-24"))
	df_mid  = subset (data, data$general_age %in% c("25-29"))
	
	df_high$general_age <- ">29"
	df_low$general_age  <- "<25"
	
	df_high$general_age = factor(df_high$general_age, levels=c("<25","25-29",">29"))
	df_mid$general_age  = factor(df_mid$general_age, levels=c("<25","25-29",">29"))
	df_low$general_age  = factor(df_low$general_age, levels=c("<25","25-29",">29"))
	
	df = rbind (df_high, df_mid, df_low)

	p1 = ggplot (df, aes(x=general_age, y=score_round1, fill=general_age)) +
		geom_boxplot() +
		xlab("Age") +
		ylab("Score") +
		scale_fill_manual(values = c("deeppink3","green3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=0)) +
		theme (axis.title.y = element_text(size=12, vjust=0.65)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,0.2,-0.2), "cm")) +
		ggtitle("Round 1")

	p2 = ggplot (df, aes(x=general_age, y=score_round2, fill=general_age)) +
		geom_boxplot() +
		xlab("Age") +
		ylab("") +
		scale_fill_manual(values = c("deeppink3","green3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=0)) +
		theme (axis.title.y = element_text(size=12, vjust=0.2)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,0.2,0), "cm")) +
		ggtitle("Round 2")

	p3 = ggplot (df, aes(x=general_age, y=score_round3, fill=general_age)) +
		geom_boxplot() +
		xlab("Age") +
		ylab("") + 
		scale_fill_manual(values = c("deeppink3","green3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=0)) +
		theme (axis.title.y = element_text(size=12, vjust=0.2)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,0.2,0), "cm")) +
		ggtitle("Round 3")

	p4 = ggplot (df, aes(x=general_age, y=score_round4, fill=general_age)) +
		geom_boxplot() +
		xlab("Age") +
		ylab("") +
		scale_fill_manual(values = c("deeppink3","green3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=0)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,0.2,0), "cm")) +
		ggtitle("Round 4")

	#pl = arrangeGrob (p1,p2,p3,p4,ncol=2,heights=c(0.5,0.5))
	#ggsave (filename=filename, plot=pl, width=8, height=5)
	pl = arrangeGrob (p1,p2,p3,p4,ncol=4,heights=c(1,1,1,1))
	ggsave (filename=filename, plot=pl, width=8, height=2.5)
	print (pl)
}
