genderPlot <- function (data, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")
	
	df = data
	df$gender_feedback = factor ("f/ch","f/of","m/ch","m/of")
	f1 = subset (df, df$general_gender == "female" & df$feedback_group %in% c("control","highscore"))
	f2 = subset (df, df$general_gender == "female" & df$feedback_group %in% c("indicate","trend","value","chart"))
	m1 = subset (df, df$general_gender == "male" & df$feedback_group %in% c("control","highscore"))
	m2 = subset (df, df$general_gender == "male" & df$feedback_group %in% c("indicate","trend","value","chart"))
	f1$gender_feedback <- "f/ch"
	f2$gender_feedback <- "f/of"
	m1$gender_feedback <- "m/ch"
	m2$gender_feedback <- "m/of"
	df = rbind (f1,f2,m1,m2)

	p1 = ggplot (df, aes(x=gender_feedback, y=score_round1, fill=gender_feedback)) +
		geom_boxplot() +
		xlab("") +
		ylab("Score") +
		scale_fill_manual(values = c("deeppink3","firebrick2","dodgerblue","darkturquoise")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.4)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0,0.2,0), "cm")) +
		ggtitle("Round 1")

	p2 = ggplot (df, aes(x=gender_feedback, y=score_round2, fill=gender_feedback)) +
		geom_boxplot() +
		xlab("") +
		ylab("") +
		scale_fill_manual(values = c("deeppink3","firebrick2","dodgerblue","darkturquoise")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0.1,0.2,0), "cm")) +
		ggtitle("Round 2")

	p3 = ggplot (df, aes(x=gender_feedback, y=score_round3, fill=gender_feedback)) +
		geom_boxplot() +
		xlab("Gender/Feedback") +
		ylab("Score") + 
		scale_fill_manual(values = c("deeppink3","firebrick2","dodgerblue","darkturquoise")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.1)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0,0.3,0.25), "cm")) +
		ggtitle("Round 3")

	p4 = ggplot (df, aes(x=gender_feedback, y=score_round4, fill=gender_feedback)) +
		geom_boxplot() +
		xlab("Gender/Feedback") +
		ylab("") +
		scale_fill_manual(values = c("deeppink3","firebrick2","dodgerblue","darkturquoise")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0.1,0.3,0), "cm")) +
		ggtitle("Round 4")

	pl = arrangeGrob (p1,p2,p3,p4,ncol=2,heights=c(0.5,0.5))
	ggsave (filename=filename, plot=pl, width=8, height=5)
	print (pl)
}
