histogramGroups <- function (data, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")
	
	df <- data
	df$feedback_group <- factor(df$feedback_group, c("all", "control", "highscore", "indicate", "trend", "value", "chart"))

	p1 = ggplot (df, aes(x=feedback_group, fill=feedback_group)) +
	     geom_histogram() +
	     xlab ("Group") +
	     ylab ("Count") +
	     theme (legend.position="none") +
	     scale_x_discrete (breaks=c("control", "highscore", "indicate", "trend", "value", "chart"),
		                   labels=c("co","hs","in", "tr", "va", "ch")) +
	     scale_fill_manual (values = c("#C49A00", "#53B400", "#00C094", "#00B6EB", "#A58AFF", "#FB61D7"))
	     theme (axis.title.x = element_text(size=12, vjust=0)) +
		 theme (axis.title.y = element_text(size=12, vjust=0.2)) +
	     theme (plot.margin=unit(c(0.1,0.1,0.2,0.2), "cm"))
	
	ggsave (filename=filename, plot=p1, width=4, height=2.5)
	print (p1)
}
