require ("ggplot2")
require ("grid")
require ("gridExtra")

p1 = ggplot (tailor.cleaned, aes(x=general_gender, fill=general_gender)) +
geom_histogram() +
scale_fill_manual(values = c("deeppink3","dodgerblue")) +
xlab("") +
ylab("Number of participants") +
scale_y_continuous (limits=c(0,85), breaks=seq(0, 80, 10)) +
theme (legend.position="none") +
theme (axis.title.x = element_text(size=12, vjust=0)) +
theme (axis.title.y = element_text(size=12, vjust=0.3)) +
theme (plot.margin=unit(c(0.1,0.1,-0.5,0.1), "cm"))

p2 = ggplot (tailor.cleaned, aes(x=general_economics, fill=general_economics)) +
geom_histogram() +
scale_fill_manual(values = c("deeppink3","dodgerblue")) +
scale_y_continuous (limits=c(0,85), breaks=seq(0, 80, 10)) +
xlab("") +
ylab("") +
theme (legend.position="none") +
theme (axis.title.x = element_text(size=12, vjust=0)) +
theme (axis.title.y = element_text(size=12, vjust=0.3)) +
theme (plot.margin=unit(c(0.1,0.1,-0.5,-0.5), "cm"))

p3 = ggplot (tailor.cleaned, aes(x=general_games, fill=general_games)) +
geom_histogram() +
scale_fill_manual(values = c("deeppink3","dodgerblue")) +
scale_y_continuous (limits=c(0,85), breaks=seq(0, 80, 10)) +
xlab("") +
ylab("") +
theme (legend.position="none") +
theme (axis.title.x = element_text(size=12, vjust=0)) +
theme (axis.title.y = element_text(size=12, vjust=0.3)) +
theme (plot.margin=unit(c(0.1,0.1,-0.5,-0.5), "cm"))

p4 = ggplot (tailor.cleaned, aes(x=general_problems, fill=general_problems)) +
geom_histogram() +
scale_fill_manual(values = c("deeppink3","dodgerblue")) +
scale_y_continuous (limits=c(0,85), breaks=seq(0, 80, 10)) +
xlab("") +
ylab("") +
theme (legend.position="none") +
theme (axis.title.x = element_text(size=12, vjust=0)) +
theme (axis.title.y = element_text(size=12, vjust=0.3)) +
theme (plot.margin=unit(c(0.1,0.1,-0.5,-0.5), "cm"))

ggsave (filename="histogram_general-gender.pdf", plot=p1, width=2, height=2.5)
ggsave (filename="histogram_general-economics.pdf", plot=p2, width=2, height=2.5)
ggsave (filename="histogram_general-games.pdf", plot=p3, width=2, height=2.5)
ggsave (filename="histogram_general-problems.pdf", plot=p4, width=2, height=2.5)

pl = arrangeGrob (p1,p2,p3,p4,ncol=4,heights=c(1,1,1,1))
ggsave (filename="histogram_general-factors.pdf", plot=pl, width=8, height=2.5)
print (pl)

p5 = ggplot (tailor.cleaned, aes(x=factor(general_age, levels=c("<18","18-24","25-29","30-39","40-49","50-59","60-69",">69")), fill=general_age)) +
geom_histogram() +
xlab("Age") +
ylab("Number of participants") +
scale_x_discrete("Age", breaks=factor(c("<18","18-24","25-29","30-39","40-49","50-59","60-69",">69")), drop=FALSE) +
theme (legend.position="none") +
theme (axis.title.x = element_text(size=12, vjust=0)) +
theme (axis.title.y = element_text(size=12, vjust=0.3)) +
theme (plot.margin=unit(c(0.1,0.1,0.1,0.1), "cm"))
ggsave (filename="histogram_general-age.pdf", plot=p5, width=8, height=2.5)
print (p5)
