factorPlot <- function (data, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")

	p1 = ggplot (data, aes(x=general_problems, y=score_round1, fill=general_problems)) +
		geom_boxplot() +
		xlab("") +
		ylab("Score") +
		scale_fill_manual(values = c("deeppink3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.3e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.4)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,-0.4,0), "cm")) +
		ggtitle("Round 1")

	p2 = ggplot (data, aes(x=general_problems, y=score_round2, fill=general_problems)) +
		geom_boxplot() +
		xlab("") +
		ylab("") +
		scale_fill_manual(values = c("deeppink3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.5e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,-0.4,0), "cm")) +
		ggtitle("Round 2")

	p3 = ggplot (data, aes(x=general_problems, y=score_round3, fill=general_problems)) +
		geom_boxplot() +
		xlab("") +
		ylab("") + 
		scale_fill_manual(values = c("deeppink3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.5e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,-0.4,0), "cm")) +
		ggtitle("Round 3")

	p4 = ggplot (data, aes(x=general_problems, y=score_round4, fill=general_problems)) +
		geom_boxplot() +
		xlab("") +
		ylab("") +
		scale_fill_manual(values = c("deeppink3","dodgerblue")) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-5e5,5.5e5), breaks=seq(-4e5, 5e5, 2e5)) +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=0.9), plot.margin=unit(c(0,0,-0.4,0), "cm")) +
		ggtitle("Round 4")

	pl = arrangeGrob (p1,p2,p3,p4,ncol=4,heights=c(1,1,1,1))
	ggsave (filename=filename, plot=pl, width=8, height=2.5)
	print (pl)
}
