histogramBfi <- function (data, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")
	
	p1 = ggplot (data=data, aes(x=bfi10_agreeableness, stat="bin", fill=..x..)) +
	     geom_histogram() +
	     scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
	     scale_y_continuous (limits=c(0,35), breaks=seq(0, 35, 10)) +
	     scale_x_discrete (breaks=factor(seq(2, 10, 2)), drop=FALSE) +
	     xlab ("Agreeableness") +
	     ylab ("Number of Participants") +
	     theme (axis.title.y = element_text(size=12, vjust=0.5)) +
	     theme (plot.margin=unit(c(0.1,0,0,-0.1), "cm")) +
	     theme (legend.position="none")

	p2 = ggplot (data=data, aes(x=bfi10_conscientiousness, stat="bin", fill=..x..)) +
	     geom_histogram() +
	     scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
	     scale_y_continuous (limits=c(0,35), breaks=seq(0, 35, 10)) +
	     scale_x_discrete (breaks=factor(seq(2, 10, 2)), drop=FALSE) +
	     xlab ("Conscientiousness") +
	     ylab ("") +
	     theme (axis.title.x = element_text(size=12,family="NimbusSanCond")) +
	     theme (plot.margin=unit(c(0.1,0,0,0), "cm")) +
	     theme (legend.position="none")

	p3 = ggplot (data=data, aes(x=bfi10_extraversion, stat="bin", fill=..x..)) +
	     geom_histogram() +
	     scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
	     scale_y_continuous (limits=c(0,35), breaks=seq(0, 35, 10)) +
	     scale_x_discrete (breaks=factor(seq(2, 10, 2)), drop=FALSE) +
	     xlab ("Extraversion") +
	     ylab ("") +
	     theme (plot.margin=unit(c(0.1,0,0,0), "cm")) +
	     theme (legend.position="none")

	p4 = ggplot (data=data, aes(x=bfi10_neuroticism, stat="bin", fill=..x..)) +
	     geom_histogram() +
	     scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
	     scale_y_continuous (limits=c(0,35), breaks=seq(0, 35, 10)) +
	     scale_x_discrete (breaks=factor(seq(2, 10, 2)), drop=FALSE) +
	     xlab ("Neuroticism") +
	     ylab ("") +
	     theme (plot.margin=unit(c(0.1,0,0,0), "cm")) +
	     theme (legend.position="none")

	p5 = ggplot (data=data, aes(x=bfi10_openness, stat="bin", fill=..x..)) +
	     geom_histogram() +
	     scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
	     scale_y_continuous (limits=c(0,35), breaks=seq(0, 35, 10)) +
	     scale_x_discrete (breaks=factor(seq(2, 10, 2)), drop=FALSE) +
	     xlab ("Openness") +
	     ylab ("") +
	     theme (plot.margin=unit(c(0.1,0,0,0), "cm")) +
	     theme (legend.position="none")

	plot = arrangeGrob (p1,p2,p3,p4,p5,ncol=5,heights=c(1,1,1,1,1))
	ggsave (filename=filename, plot=plot, width=8, height=2.5)
	print (plot)
}
