histogramCombined <- function (data, filename, yMax=21) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")

	df = data

	p1 = ggplot (data, aes(x=score_round1, stat="bin", fill=..x..)) +
		geom_histogram(binwidth=70000) +
		xlab("") +
		ylab("Number of participants") +
		scale_y_continuous (limits=c(0,yMax)) +
		scale_x_continuous (labels=fancy_scientific, breaks=seq(-9e5, 3e5, 3e5)) +
		scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.3)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0,0.2,0.1), "cm")) +
		ggtitle("Round 1")

	p2 = ggplot (data, aes(x=score_round2, stat="bin", fill=..x..)) +
		geom_histogram(binwidth=100000) +
		xlab("") +
		ylab("") +
		scale_y_continuous (limits=c(0,yMax)) +
		scale_x_continuous (labels=fancy_scientific, breaks=seq(-2e6, 1e5, 5e5)) +
		scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0.1,0.2,0), "cm")) +
		ggtitle("Round 2")

	p3 = ggplot (data, aes(x=score_round3, stat="bin", fill=..x..)) +
		geom_histogram(binwidth=35000) +
		xlab("Score") +
		ylab("Number of participants") +
		scale_y_continuous (limits=c(0,yMax)) +
		scale_x_continuous (labels=fancy_scientific, breaks=seq(-2e5, 2e5, 2e5)) +
		scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-0.3)) +
		theme (axis.title.y = element_text(size=12, vjust=0.3)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0,0.3,0.1), "cm")) +
		ggtitle("Round 3")

	p4 = ggplot (data, aes(x=score_round4, stat="bin", fill=..x..)) +
		geom_histogram(binwidth=90000) +
		xlab("Score") +
		ylab("") +
		scale_y_continuous (limits=c(0,yMax)) +
		scale_x_continuous (labels=fancy_scientific, breaks=seq(-9e5, 5e5, 3e5)) +
		scale_fill_gradient(low = "darkorchid4", high = "deeppink3") +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-0.3)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0.1,0.3,0), "cm")) +
		ggtitle("Round 4")

	pl = arrangeGrob (p1,p2,p3,p4,ncol=2,heights=c(0.5,0.5))
	ggsave (filename=filename, plot=pl, width=8, height=5)
	print (pl)
}
