boxplotCombined <- function (data, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")

	temp = data
	temp$feedback_group <- "all"
	df = rbind (temp, data)
	df$feedback_group <- factor(df$feedback_group, c("all", "control", "highscore", "indicate", "trend", "value", "chart"))

	p1 = ggplot (df, aes(x=feedback_group, y=score_round1, fill=feedback_group)) +
		geom_boxplot() +
		xlab("") +
		ylab("Score") +
		#scale_y_continuous (labels=fancy_scientific) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-1.8e6,5.3e5), breaks=seq(-1.5e6, 0.5e6, 0.5e6)) +
		#scale_y_continuous (labels=fancy_scientific, limits=c(-5.0e5,5.3e5), breaks=seq(-4e5, 4e5, 2e5)) +
		scale_fill_hue(name="Experimental\nCondition",
		               breaks=c("all", "control", "highscore", "indicate", "trend", "value", "chart"),
                       labels=c("all","co","hs","in", "tr", "va", "ch")) +
		scale_x_discrete (breaks=c("all", "control", "highscore", "indicate", "trend", "value", "chart"),
		                  labels=c("all","co","hs","in", "tr", "va", "ch")) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.5)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0,0.2,-0.05), "cm")) +
		ggtitle("Round 1")

	p2 = ggplot (df, aes(x=feedback_group, y=score_round2, fill=feedback_group)) +
		geom_boxplot() +
		xlab("") +
		ylab("") +
		#scale_y_continuous (labels=fancy_scientific) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-1.8e6,5.3e5), breaks=seq(-1.5e6, 0.5e6, 0.5e6)) +
		#scale_y_continuous (labels=fancy_scientific, limits=c(-5.0e5,5.3e5), breaks=seq(-4e5, 4e5, 2e5)) +
		scale_fill_hue() +
		scale_x_discrete (breaks=c("all", "control", "highscore", "indicate", "trend", "value", "chart"),
		                  labels=c("all","co","hs","in", "tr", "va", "ch")) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0.1,0.2,0), "cm")) +
		ggtitle("Round 2")

	p3 = ggplot (df, aes(x=feedback_group, y=score_round3, fill=feedback_group)) +
		geom_boxplot() +
		xlab("Group") +
		ylab("Score") +
		#scale_y_continuous (labels=fancy_scientific) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-1.8e6,5.3e5), breaks=seq(-1.5e6, 0.5e6, 0.5e6)) +
		#scale_y_continuous (labels=fancy_scientific, limits=c(-5.0e5,5.3e5), breaks=seq(-4e5, 4e5, 2e5)) +
		scale_fill_hue() +
		scale_x_discrete (breaks=c("all", "control", "highscore", "indicate", "trend", "value", "chart"),
		                  labels=c("all","co","hs","in", "tr", "va", "ch")) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-0.3)) +
		theme (axis.title.y = element_text(size=12, vjust=0.5)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0,0.3,-0.05), "cm")) +
		ggtitle("Round 3")

	p4 = ggplot (df, aes(x=feedback_group, y=score_round4, fill=feedback_group)) +
		geom_boxplot() +
		xlab("Group") +
		ylab("") +
		#scale_y_continuous (labels=fancy_scientific) +
		scale_y_continuous (labels=fancy_scientific, limits=c(-1.8e6,5.3e5), breaks=seq(-1.5e6, 0.5e6, 0.5e6)) +
		#scale_y_continuous (labels=fancy_scientific, limits=c(-5.0e5,5.3e5), breaks=seq(-4e5, 4e5, 2e5)) +
		scale_fill_hue() +
		scale_x_discrete (breaks=c("all", "control", "highscore", "indicate", "trend", "value", "chart"),
		                  labels=c("all","co","hs","in", "tr", "va", "ch")) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-0.3)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.5)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0.1,0.3,0), "cm")) +
		ggtitle("Round 4")

	pl = arrangeGrob (p1,p2,p3,p4,ncol=2,heights=c(0.5,0.5))
	ggsave (filename=filename, plot=pl, width=8, height=5)
	print (pl)
}
