boxplotCombinedBfi <- function (data, ylabel, filename) {
	require ("ggplot2")
	require ("grid")
	require ("gridExtra")

	factor = "bfi10_openness"
	data = subset (data, !is.na (with (data, get(factor))))
	#df = data

	p1 = ggplot (data, aes (x=bfi10_openness, y=score_round1, fill=bfi10_openness ) ) +
		geom_boxplot() +
		xlab("") +
		ylab("Score") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_fill_hue() +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.4)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0,0,0), "cm")) +
		ggtitle("Round 1")

	p2 = ggplot (data, aes(x=bfi10_openness, y=score_round2, fill=bfi10_openness)) +
		geom_boxplot() +
		xlab("") +
		ylab("") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_fill_hue() +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.1,0,0,0), "cm")) +
		ggtitle("Round 2")

	p3 = ggplot (data, aes(x=bfi10_openness, y=score_round3, fill=bfi10_openness)) +
		geom_boxplot() +
		xlab(ylabel) +
		ylab("Score") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_fill_hue() +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=0)) +
		theme (axis.title.y = element_text(size=12, vjust=0.1)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0,0.1,0.25), "cm")) +
		ggtitle("Round 3")

	p4 = ggplot (data, aes(x=bfi10_openness, y=score_round4, fill=bfi10_openness)) +
		geom_boxplot() +
		xlab(ylabel) +
		ylab("") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_fill_hue() +
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=0)) +
		theme (axis.title.y = element_text(size=12, vjust=-0.2)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0,0,0.1,0), "cm")) +
		ggtitle("Round 4")

	pl = arrangeGrob (p1,p2,p3,p4,ncol=2,heights=c(0.5,0.5))
	ggsave (filename=filename, plot=pl, width=8, height=5)
	print (pl)
}
