require ("ggplot2")
require ("grid")
require ("gridExtra")

p1 = ggplot (tailor.cleaned, aes(x=bfi10_agreeableness, y=score_sum)) +
		geom_point(size=2) +
		xlab("") +
		ylab("Score") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_x_discrete (breaks=c(2,3,4,5,6,7,8,9,10), drop=FALSE) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.5)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.05,0.05,-0.5,-0.05), "cm"))

p2 = ggplot (tailor.cleaned, aes(x=bfi10_conscientiousness, y=score_sum)) +
		geom_point(size=2) +
		xlab("") +
		ylab("") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_x_discrete (breaks=c(2,3,4,5,6,7,8,9,10), drop=FALSE) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.text.y = element_blank()) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.05,0.05,-0.5,-0.25), "cm"))

p3 = ggplot (tailor.cleaned, aes(x=bfi10_extraversion, y=score_sum)) +
		geom_point(size=2) +
		xlab("") +
		ylab("Score") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_x_discrete (breaks=c(2,3,4,5,6,7,8,9,10), drop=FALSE) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.title.y = element_text(size=12, vjust=0.5)) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.05,0.05,-0.5,-0.05), "cm"))

p4 = ggplot (tailor.cleaned, aes(x=bfi10_neuroticism, y=score_sum)) +
		geom_point(size=2) +
		xlab("") +
		ylab("") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_x_discrete (breaks=c(2,3,4,5,6,7,8,9,10), drop=FALSE) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.text.y = element_blank()) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.05,0.05,-0.5,-0.25), "cm"))

p5 = ggplot (tailor.cleaned, aes(x=bfi10_openness, y=score_sum)) +
		geom_point(size=2) +
		xlab("") +
		ylab("") +
		scale_y_continuous (labels=fancy_scientific) +
		scale_x_discrete (breaks=c(2,3,4,5,6,7,8,9,10), drop=FALSE) + 
		theme (legend.position="none") +
		theme (axis.title.x = element_text(size=12, vjust=-1)) +
		theme (axis.text.y = element_blank()) +
		theme (plot.title = element_text(vjust=1), plot.margin=unit(c(0.05,0.05,-0.5,-0.25), "cm"))

emptyGrob = grob()

ggsave (filename="scatterplot_bfi10-agreeableness.pdf", plot=p1, width=3.1, height=2.5)
ggsave (filename="scatterplot_bfi10-conscientiousness.pdf", plot=p2, width=2.45, height=2.5)
ggsave (filename="scatterplot_bfi10-extraversion.pdf", plot=p3, width=3.1, height=2.5)
ggsave (filename="scatterplot_bfi10-neuroticism.pdf", plot=p4, width=2.45, height=2.5)
ggsave (filename="scatterplot_bfi10-openness.pdf", plot=p5, width=2.45, height=2.5)

pl = arrangeGrob (p1,p2,emptyGrob,p3,p4,p5,ncol=3,heights=c(0.5,0.5,0.5,0.5,0.5,0.5))
print(pl)
